/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import net.ltgt.gradle.errorprone.ErrorProneOptions;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.compile.JavaCompile;

public final class BaselineNullAway
implements Plugin<Project> {
    private static final Logger log = Logging.getLogger(BaselineNullAway.class);
    private static final ImmutableSet<String> DEFAULT_ANNOTATED_PACKAGES = ImmutableSet.of((Object)"com.palantir");

    public void apply(Project project) {
        project.getPluginManager().withPlugin("com.palantir.baseline-error-prone", _unused0 -> project.getPluginManager().withPlugin("java-base", _unused1 -> this.applyToProject(project)));
    }

    private void applyToProject(final Project project) {
        final String version = Optional.ofNullable(BaselineNullAway.class.getPackage().getImplementationVersion()).orElseGet(() -> {
            log.warn("BaselineNullAway is using 'latest.release' - beware this compromises build reproducibility");
            return "latest.release";
        });
        project.getConfigurations().matching((Spec)new Spec<Configuration>(){

            public boolean isSatisfiedBy(Configuration config) {
                return "errorprone".equals(config.getName());
            }
        }).configureEach((Action)new Action<Configuration>(){

            public void execute(Configuration _files) {
                project.getDependencies().add("errorprone", (Object)("com.palantir.baseline:baseline-null-away:" + version));
            }
        });
        BaselineNullAway.configureErrorProneOptions(project, new Action<ErrorProneOptions>(){

            public void execute(ErrorProneOptions options) {
                options.option("NullAway:AnnotatedPackages", String.join((CharSequence)",", DEFAULT_ANNOTATED_PACKAGES));
                if (((Boolean)options.getCompilingTestOnlyCode().get()).booleanValue()) {
                    options.disable(new String[]{"NullAway"});
                }
            }
        });
    }

    private static void configureErrorProneOptions(Project proj, final Action<ErrorProneOptions> action) {
        proj.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                project.getTasks().withType(JavaCompile.class).configureEach((Action)new Action<JavaCompile>(){

                    public void execute(JavaCompile javaCompile) {
                        ((ExtensionAware)javaCompile.getOptions()).getExtensions().configure(ErrorProneOptions.class, action);
                    }
                });
            }
        });
    }
}

