/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.palantir.baseline.util.VersionsProps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.BaseStream;

abstract class VersionsProps_ParsedVersionsProps_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private List<String> lines = ImmutableList.of();
    private final LinkedHashMap<String, Integer> namesToLocationMap = new LinkedHashMap();
    private List<VersionsProps.VersionForce> forces = ImmutableList.of();

    VersionsProps_ParsedVersionsProps_Builder() {
    }

    public static VersionsProps.ParsedVersionsProps.Builder from(VersionsProps.ParsedVersionsProps value) {
        return new VersionsProps.ParsedVersionsProps.Builder().mergeFrom(value);
    }

    public VersionsProps.ParsedVersionsProps.Builder addLines(String element) {
        if (this.lines instanceof ImmutableList) {
            this.lines = new ArrayList<String>(this.lines);
        }
        this.lines.add((String)Preconditions.checkNotNull((Object)element));
        return (VersionsProps.ParsedVersionsProps.Builder)this;
    }

    public VersionsProps.ParsedVersionsProps.Builder addLines(String ... elements) {
        return this.addAllLines(Arrays.asList(elements));
    }

    public VersionsProps.ParsedVersionsProps.Builder addAllLines(Spliterator<? extends String> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.lines instanceof ImmutableList) {
                this.lines = new ArrayList<String>(this.lines);
            }
            ((ArrayList)this.lines).ensureCapacity(this.lines.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addLines);
        return (VersionsProps.ParsedVersionsProps.Builder)this;
    }

    public VersionsProps.ParsedVersionsProps.Builder addAllLines(BaseStream<? extends String, ?> elements) {
        return this.addAllLines(elements.spliterator());
    }

    public VersionsProps.ParsedVersionsProps.Builder addAllLines(Iterable<? extends String> elements) {
        return this.addAllLines(elements.spliterator());
    }

    public VersionsProps.ParsedVersionsProps.Builder mutateLines(Consumer<? super List<String>> mutator) {
        if (this.lines instanceof ImmutableList) {
            this.lines = new ArrayList<String>(this.lines);
        }
        mutator.accept(this.lines);
        return (VersionsProps.ParsedVersionsProps.Builder)this;
    }

    public VersionsProps.ParsedVersionsProps.Builder clearLines() {
        if (this.lines instanceof ImmutableList) {
            this.lines = ImmutableList.of();
        } else {
            this.lines.clear();
        }
        return (VersionsProps.ParsedVersionsProps.Builder)this;
    }

    public List<String> lines() {
        if (this.lines instanceof ImmutableList) {
            this.lines = new ArrayList<String>(this.lines);
        }
        return Collections.unmodifiableList(this.lines);
    }

    public VersionsProps.ParsedVersionsProps.Builder putNamesToLocationMap(String key, int value) {
        Preconditions.checkNotNull((Object)key);
        this.namesToLocationMap.put(key, value);
        return (VersionsProps.ParsedVersionsProps.Builder)this;
    }

    public VersionsProps.ParsedVersionsProps.Builder putAllNamesToLocationMap(Map<? extends String, ? extends Integer> map) {
        for (Map.Entry<? extends String, ? extends Integer> entry : map.entrySet()) {
            this.putNamesToLocationMap(entry.getKey(), entry.getValue());
        }
        return (VersionsProps.ParsedVersionsProps.Builder)this;
    }

    public VersionsProps.ParsedVersionsProps.Builder removeNamesToLocationMap(String key) {
        Preconditions.checkNotNull((Object)key);
        this.namesToLocationMap.remove(key);
        return (VersionsProps.ParsedVersionsProps.Builder)this;
    }

    public VersionsProps.ParsedVersionsProps.Builder mutateNamesToLocationMap(Consumer<? super Map<String, Integer>> mutator) {
        mutator.accept(this.namesToLocationMap);
        return (VersionsProps.ParsedVersionsProps.Builder)this;
    }

    public VersionsProps.ParsedVersionsProps.Builder clearNamesToLocationMap() {
        this.namesToLocationMap.clear();
        return (VersionsProps.ParsedVersionsProps.Builder)this;
    }

    public Map<String, Integer> namesToLocationMap() {
        return Collections.unmodifiableMap(this.namesToLocationMap);
    }

    public VersionsProps.ParsedVersionsProps.Builder addForces(VersionsProps.VersionForce element) {
        if (this.forces instanceof ImmutableList) {
            this.forces = new ArrayList<VersionsProps.VersionForce>(this.forces);
        }
        this.forces.add((VersionsProps.VersionForce)Preconditions.checkNotNull((Object)element));
        return (VersionsProps.ParsedVersionsProps.Builder)this;
    }

    public VersionsProps.ParsedVersionsProps.Builder addForces(VersionsProps.VersionForce ... elements) {
        return this.addAllForces(Arrays.asList(elements));
    }

    public VersionsProps.ParsedVersionsProps.Builder addAllForces(Spliterator<? extends VersionsProps.VersionForce> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.forces instanceof ImmutableList) {
                this.forces = new ArrayList<VersionsProps.VersionForce>(this.forces);
            }
            ((ArrayList)this.forces).ensureCapacity(this.forces.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addForces);
        return (VersionsProps.ParsedVersionsProps.Builder)this;
    }

    public VersionsProps.ParsedVersionsProps.Builder addAllForces(BaseStream<? extends VersionsProps.VersionForce, ?> elements) {
        return this.addAllForces(elements.spliterator());
    }

    public VersionsProps.ParsedVersionsProps.Builder addAllForces(Iterable<? extends VersionsProps.VersionForce> elements) {
        return this.addAllForces(elements.spliterator());
    }

    public VersionsProps.ParsedVersionsProps.Builder mutateForces(Consumer<? super List<VersionsProps.VersionForce>> mutator) {
        if (this.forces instanceof ImmutableList) {
            this.forces = new ArrayList<VersionsProps.VersionForce>(this.forces);
        }
        mutator.accept(this.forces);
        return (VersionsProps.ParsedVersionsProps.Builder)this;
    }

    public VersionsProps.ParsedVersionsProps.Builder clearForces() {
        if (this.forces instanceof ImmutableList) {
            this.forces = ImmutableList.of();
        } else {
            this.forces.clear();
        }
        return (VersionsProps.ParsedVersionsProps.Builder)this;
    }

    public List<VersionsProps.VersionForce> forces() {
        if (this.forces instanceof ImmutableList) {
            this.forces = new ArrayList<VersionsProps.VersionForce>(this.forces);
        }
        return Collections.unmodifiableList(this.forces);
    }

    public VersionsProps.ParsedVersionsProps.Builder mergeFrom(VersionsProps.ParsedVersionsProps value) {
        if (value instanceof Value && this.lines == ImmutableList.of()) {
            this.lines = ImmutableList.copyOf(value.lines());
        } else {
            this.addAllLines(value.lines());
        }
        this.putAllNamesToLocationMap(value.namesToLocationMap());
        if (value instanceof Value && this.forces == ImmutableList.of()) {
            this.forces = ImmutableList.copyOf(value.forces());
        } else {
            this.addAllForces(value.forces());
        }
        return (VersionsProps.ParsedVersionsProps.Builder)this;
    }

    public VersionsProps.ParsedVersionsProps.Builder mergeFrom(VersionsProps.ParsedVersionsProps.Builder template) {
        VersionsProps.ParsedVersionsProps.Builder base = template;
        this.addAllLines(base.lines);
        this.putAllNamesToLocationMap(base.namesToLocationMap);
        this.addAllForces(base.forces);
        return (VersionsProps.ParsedVersionsProps.Builder)this;
    }

    public VersionsProps.ParsedVersionsProps.Builder clear() {
        this.clearLines();
        this.namesToLocationMap.clear();
        this.clearForces();
        return (VersionsProps.ParsedVersionsProps.Builder)this;
    }

    public VersionsProps.ParsedVersionsProps build() {
        return new Value(this);
    }

    @VisibleForTesting
    public VersionsProps.ParsedVersionsProps buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements VersionsProps.ParsedVersionsProps {
        private final List<String> lines;
        private final Map<String, Integer> namesToLocationMap;
        private final List<VersionsProps.VersionForce> forces;

        Partial(VersionsProps_ParsedVersionsProps_Builder builder) {
            this.lines = ImmutableList.copyOf(builder.lines);
            this.namesToLocationMap = ImmutableMap.copyOf(builder.namesToLocationMap);
            this.forces = ImmutableList.copyOf(builder.forces);
        }

        @Override
        public List<String> lines() {
            return this.lines;
        }

        @Override
        public Map<String, Integer> namesToLocationMap() {
            return this.namesToLocationMap;
        }

        @Override
        public List<VersionsProps.VersionForce> forces() {
            return this.forces;
        }

        @Override
        public VersionsProps.ParsedVersionsProps.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            builder.addAllLines(this.lines);
            builder.putAllNamesToLocationMap(this.namesToLocationMap);
            builder.addAllForces(this.forces);
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.lines, other.lines) && Objects.equals(this.namesToLocationMap, other.namesToLocationMap) && Objects.equals(this.forces, other.forces);
        }

        public int hashCode() {
            return Objects.hash(this.lines, this.namesToLocationMap, this.forces);
        }

        public String toString() {
            return "partial ParsedVersionsProps{" + COMMA_JOINER.join((Object)("lines=" + this.lines), (Object)("namesToLocationMap=" + this.namesToLocationMap), new Object[]{"forces=" + this.forces}) + "}";
        }

        private static class PartialBuilder
        extends VersionsProps.ParsedVersionsProps.Builder {
            private PartialBuilder() {
            }

            @Override
            public VersionsProps.ParsedVersionsProps build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    implements VersionsProps.ParsedVersionsProps {
        private final List<String> lines;
        private final Map<String, Integer> namesToLocationMap;
        private final List<VersionsProps.VersionForce> forces;

        private Value(VersionsProps_ParsedVersionsProps_Builder builder) {
            this.lines = ImmutableList.copyOf(builder.lines);
            this.namesToLocationMap = ImmutableMap.copyOf(builder.namesToLocationMap);
            this.forces = ImmutableList.copyOf(builder.forces);
        }

        @Override
        public List<String> lines() {
            return this.lines;
        }

        @Override
        public Map<String, Integer> namesToLocationMap() {
            return this.namesToLocationMap;
        }

        @Override
        public List<VersionsProps.VersionForce> forces() {
            return this.forces;
        }

        @Override
        public VersionsProps.ParsedVersionsProps.Builder toBuilder() {
            return new VersionsProps.ParsedVersionsProps.Builder().mergeFrom(this);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.lines, other.lines) && Objects.equals(this.namesToLocationMap, other.namesToLocationMap) && Objects.equals(this.forces, other.forces);
        }

        public int hashCode() {
            return Objects.hash(this.lines, this.namesToLocationMap, this.forces);
        }

        public String toString() {
            return "ParsedVersionsProps{lines=" + this.lines + ", namesToLocationMap=" + this.namesToLocationMap + ", forces=" + this.forces + "}";
        }
    }
}

