/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins.javaversions;

import com.palantir.baseline.plugins.javaversions.BaselineJavaToolchain;
import com.palantir.baseline.plugins.javaversions.BaselineJavaVersionExtension;
import com.palantir.baseline.plugins.javaversions.BaselineJavaVersionsExtension;
import com.palantir.baseline.plugins.javaversions.ChosenJavaVersion;
import com.palantir.baseline.plugins.javaversions.JavaToolchains;
import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.scala.ScalaCompile;
import org.gradle.api.tasks.scala.ScalaDoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.external.javadoc.CoreJavadocOptions;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.util.GradleVersion;

public final class BaselineJavaVersion
implements Plugin<Project> {
    public static final String EXTENSION_NAME = "javaVersion";

    public void apply(Project project) {
        final BaselineJavaVersionExtension extension = (BaselineJavaVersionExtension)project.getExtensions().create(EXTENSION_NAME, BaselineJavaVersionExtension.class, new Object[]{project});
        project.getPluginManager().withPlugin("java", unused -> {
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            javaPluginExtension.toolchain((Action)new Action<JavaToolchainSpec>(){

                public void execute(JavaToolchainSpec javaToolchainSpec) {
                    javaToolchainSpec.getLanguageVersion().set(extension.runtime().map(ChosenJavaVersion::javaLanguageVersion));
                }
            });
            JavaToolchains javaToolchains = new JavaToolchains(project, (BaselineJavaVersionsExtension)project.getRootProject().getExtensions().getByType(BaselineJavaVersionsExtension.class));
            BaselineJavaVersion.configureCompilationTasks(project, extension.target(), javaToolchains.forVersion((Provider<ChosenJavaVersion>)extension.target()));
            BaselineJavaVersion.configureExecutionTasks(project, extension.runtime(), javaToolchains.forVersion((Provider<ChosenJavaVersion>)extension.runtime()));
            TaskProvider checkJavaVersions = project.getTasks().register("checkJavaVersions", CheckJavaVersionsTask.class, (Action)new Action<CheckJavaVersionsTask>(){

                public void execute(CheckJavaVersionsTask task) {
                    task.getTargetVersion().set(extension.target());
                    task.getRuntimeVersion().set(extension.runtime());
                }
            });
            project.getTasks().named("check").configure(check -> check.dependsOn(new Object[]{checkJavaVersions}));
        });
    }

    private static void configureCompilationTasks(Project project, final Property<ChosenJavaVersion> target, final Provider<BaselineJavaToolchain> javaToolchain) {
        project.getTasks().withType(JavaCompile.class).configureEach((Action)new Action<JavaCompile>(){

            public void execute(JavaCompile javaCompileTask) {
                javaCompileTask.getJavaCompiler().set(javaToolchain.flatMap(BaselineJavaToolchain::javaCompiler));
                javaCompileTask.getOptions().getCompilerArgumentProviders().add(new EnablePreviewArgumentProvider((Provider<ChosenJavaVersion>)target));
                javaCompileTask.doFirst((Action)new Action<Task>(){

                    public void execute(Task task) {
                        ((JavaCompile)task).setSourceCompatibility(((ChosenJavaVersion)target.get()).javaLanguageVersion().toString());
                    }
                });
            }
        });
        project.getTasks().withType(Javadoc.class).configureEach((Action)new Action<Javadoc>(){

            public void execute(Javadoc javadocTask) {
                javadocTask.getJavadocTool().set(javaToolchain.flatMap(BaselineJavaToolchain::javadocTool));
                javadocTask.doFirst((Action)new Action<Task>(){

                    public void execute(Task task) {
                        CoreJavadocOptions options = (CoreJavadocOptions)((Javadoc)task).getOptions();
                        if (((ChosenJavaVersion)target.get()).enablePreview()) {
                            options.addBooleanOption("-enable-preview", true);
                            options.setSource(((ChosenJavaVersion)target.get()).javaLanguageVersion().toString());
                        }
                    }
                });
            }
        });
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.5")) >= 0) {
            project.getTasks().withType(Checkstyle.class).configureEach((Action)new Action<Checkstyle>(){

                public void execute(Checkstyle checkstyle) {
                    checkstyle.getJavaLauncher().set(javaToolchain.flatMap(BaselineJavaToolchain::javaLauncher));
                }
            });
        }
        project.getTasks().withType(GroovyCompile.class).configureEach((Action)new Action<GroovyCompile>(){

            public void execute(GroovyCompile groovyCompileTask) {
                groovyCompileTask.getJavaLauncher().set(javaToolchain.flatMap(BaselineJavaToolchain::javaLauncher));
                groovyCompileTask.getOptions().getCompilerArgumentProviders().add(new EnablePreviewArgumentProvider((Provider<ChosenJavaVersion>)target));
                groovyCompileTask.doFirst((Action)new Action<Task>(){

                    public void execute(Task task) {
                        ((GroovyCompile)task).setSourceCompatibility(((ChosenJavaVersion)target.get()).javaLanguageVersion().toString());
                    }
                });
            }
        });
        project.getTasks().withType(ScalaCompile.class).configureEach((Action)new Action<ScalaCompile>(){

            public void execute(ScalaCompile scalaCompileTask) {
                scalaCompileTask.getJavaLauncher().set(javaToolchain.flatMap(BaselineJavaToolchain::javaLauncher));
                scalaCompileTask.getOptions().getCompilerArgumentProviders().add(new EnablePreviewArgumentProvider((Provider<ChosenJavaVersion>)target));
                scalaCompileTask.doFirst((Action)new Action<Task>(){

                    public void execute(Task task) {
                        ((ScalaCompile)task).setSourceCompatibility(((ChosenJavaVersion)target.get()).javaLanguageVersion().toString());
                    }
                });
            }
        });
        project.getTasks().withType(ScalaDoc.class).configureEach((Action)new Action<ScalaDoc>(){

            public void execute(ScalaDoc scalaDoc) {
                scalaDoc.getJavaLauncher().set(javaToolchain.flatMap(BaselineJavaToolchain::javaLauncher));
            }
        });
    }

    private static void configureExecutionTasks(Project project, final Provider<ChosenJavaVersion> runtime, final Provider<BaselineJavaToolchain> javaToolchain) {
        project.getTasks().withType(JavaExec.class).configureEach((Action)new Action<JavaExec>(){

            public void execute(JavaExec javaExec) {
                javaExec.getJavaLauncher().set(javaToolchain.flatMap(BaselineJavaToolchain::javaLauncher));
                javaExec.getJvmArgumentProviders().add(new EnablePreviewArgumentProvider((Provider<ChosenJavaVersion>)runtime));
            }
        });
        project.getTasks().withType(Test.class).configureEach((Action)new Action<Test>(){

            public void execute(Test test) {
                test.getJavaLauncher().set(javaToolchain.flatMap(BaselineJavaToolchain::javaLauncher));
                test.getJvmArgumentProviders().add(new EnablePreviewArgumentProvider((Provider<ChosenJavaVersion>)runtime));
            }
        });
    }

    private static class EnablePreviewArgumentProvider
    implements CommandLineArgumentProvider {
        public static final String FLAG = "--enable-preview";
        private final Provider<ChosenJavaVersion> provider;

        private EnablePreviewArgumentProvider(Provider<ChosenJavaVersion> provider) {
            this.provider = provider;
        }

        public Iterable<String> asArguments() {
            return ((ChosenJavaVersion)this.provider.get()).enablePreview() ? Collections.singletonList(FLAG) : Collections.emptyList();
        }
    }

    @CacheableTask
    public static class CheckJavaVersionsTask
    extends DefaultTask {
        private final Property<ChosenJavaVersion> targetVersion;
        private final Property<ChosenJavaVersion> runtimeVersion;

        @Inject
        public CheckJavaVersionsTask() {
            this.setGroup("Verification");
            this.setDescription("Ensures configured java versions are compatible: The runtime version must be greater than or equal to the target version.");
            this.targetVersion = this.getProject().getObjects().property(ChosenJavaVersion.class);
            this.runtimeVersion = this.getProject().getObjects().property(ChosenJavaVersion.class);
        }

        @Input
        public Property<ChosenJavaVersion> getTargetVersion() {
            return this.targetVersion;
        }

        @Input
        public Property<ChosenJavaVersion> getRuntimeVersion() {
            return this.runtimeVersion;
        }

        @TaskAction
        public final void checkJavaVersions() {
            ChosenJavaVersion target = (ChosenJavaVersion)this.getTargetVersion().get();
            ChosenJavaVersion runtime = (ChosenJavaVersion)this.getRuntimeVersion().get();
            this.getLogger().debug("BaselineJavaVersion configured project {} with target version {} and runtime version {}", new Object[]{this.getProject(), target, runtime});
            if (target.enablePreview() && !target.equals(runtime)) {
                throw new GradleException(String.format("Runtime Java version (%s) must be exactly the same as the compilation target (%s), because --enable-preview is enabled. Otherwise Java will fail to start. See https://openjdk.org/jeps/12.", runtime, target));
            }
            if (target.javaLanguageVersion().asInt() > runtime.javaLanguageVersion().asInt()) {
                throw new GradleException(String.format("The requested compilation target Java version (%s) must not exceed the requested runtime Java version (%s)", target, runtime));
            }
        }
    }
}

