/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.tasks;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.work.InputChanges;

public class CompileRefasterTask
extends JavaCompile {
    private static final ImmutableList<String> REFASTER_EXPORTS = ImmutableList.of((Object)"--add-exports=jdk.compiler/com.sun.tools.javac.api=ALL-UNNAMED", (Object)"--add-exports=jdk.compiler/com.sun.tools.javac.file=ALL-UNNAMED", (Object)"--add-exports=jdk.compiler/com.sun.tools.javac.main=ALL-UNNAMED", (Object)"--add-exports=jdk.compiler/com.sun.tools.javac.model=ALL-UNNAMED", (Object)"--add-exports=jdk.compiler/com.sun.tools.javac.parser=ALL-UNNAMED", (Object)"--add-exports=jdk.compiler/com.sun.tools.javac.processing=ALL-UNNAMED", (Object)"--add-exports=jdk.compiler/com.sun.tools.javac.tree=ALL-UNNAMED", (Object)"--add-exports=jdk.compiler/com.sun.tools.javac.util=ALL-UNNAMED", (Object)"--add-opens=jdk.compiler/com.sun.tools.javac.code=ALL-UNNAMED", (Object)"--add-opens=jdk.compiler/com.sun.tools.javac.comp=ALL-UNNAMED");
    private final Property<Configuration> refasterSources = this.getProject().getObjects().property(Configuration.class);
    private final Property<File> refasterRulesFile = this.getProject().getObjects().property(File.class);

    public CompileRefasterTask() {
        this.getDestinationDirectory().set(this.getTemporaryDir());
        this.getOptions().setIncremental(true);
    }

    protected final void compile(InputChanges inputs) {
        this.getOptions().getCompilerArgumentProviders().clear();
        this.getOptions().setCompilerArgs((List)ImmutableList.of((Object)("-Xplugin:BaselineRefasterCompiler --out " + ((File)this.refasterRulesFile.get()).getAbsolutePath())));
        this.getOptions().getForkOptions().getJvmArgs().addAll(REFASTER_EXPORTS);
        List javaSources = ((Configuration)this.getRefasterSources().get()).getResolvedConfiguration().getFirstLevelModuleDependencies().stream().flatMap(dep -> dep.getModuleArtifacts().stream()).map(ResolvedArtifact::getFile).flatMap(file -> {
            if (file.getName().endsWith(".jar")) {
                return this.getProject().zipTree(file).getFiles().stream().filter(zipFile -> zipFile.getName().endsWith(".java"));
            }
            if (file.getName().endsWith(".java")) {
                return Stream.of(file);
            }
            this.getLogger().warn("Skipping refaster rule: {}", file);
            return Stream.empty();
        }).collect(Collectors.toList());
        if (!javaSources.isEmpty()) {
            this.setSource(javaSources);
            super.compile(inputs);
        } else {
            this.setDidWork(false);
        }
    }

    @InputFiles
    public final Property<Configuration> getRefasterSources() {
        return this.refasterSources;
    }

    @OutputFile
    public final Property<File> getRefasterRulesFile() {
        return this.refasterRulesFile;
    }
}

