/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Objects;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.process.CommandLineArgumentProvider;

public final class BaselineImmutables
implements Plugin<Project> {
    private static final ImmutableList<String> GRADLE_INCREMENTAL = ImmutableList.of((Object)"-Aimmutables.gradle.incremental");
    private static final ImmutableList<String> EXPORTS = ImmutableList.of((Object)"--add-exports=jdk.compiler/com.sun.tools.javac.code=ALL-UNNAMED");

    public void apply(final Project project) {
        project.getPluginManager().withPlugin("java", unused -> ((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).configureEach(sourceSet -> project.getTasks().named(sourceSet.getCompileJavaTaskName(), JavaCompile.class).configure(javaCompileTask -> {
            javaCompileTask.getOptions().getCompilerArgumentProviders().add(new CommandLineArgumentProvider((SourceSet)sourceSet){
                final /* synthetic */ SourceSet val$sourceSet;
                {
                    this.val$sourceSet = sourceSet;
                }

                public Iterable<String> asArguments() {
                    return BaselineImmutables.hasImmutablesProcessor(project, this.val$sourceSet) ? GRADLE_INCREMENTAL : Collections.emptyList();
                }
            });
            javaCompileTask.getOptions().getForkOptions().getJvmArgumentProviders().add(new CommandLineArgumentProvider((SourceSet)sourceSet){
                final /* synthetic */ SourceSet val$sourceSet;
                {
                    this.val$sourceSet = sourceSet;
                }

                public Iterable<String> asArguments() {
                    return BaselineImmutables.hasImmutablesProcessor(project, this.val$sourceSet) ? EXPORTS : Collections.emptyList();
                }
            });
        })));
    }

    private static boolean hasImmutablesProcessor(Project project, SourceSet sourceSet) {
        return project.getConfigurations().getByName(sourceSet.getAnnotationProcessorConfigurationName()).getIncoming().getResolutionResult().getAllComponents().stream().anyMatch(BaselineImmutables::isImmutablesValue);
    }

    private static boolean isImmutablesValue(ResolvedComponentResult component) {
        ComponentIdentifier id = component.getId();
        if (!(id instanceof ModuleComponentIdentifier)) {
            return false;
        }
        ModuleComponentIdentifier moduleId = (ModuleComponentIdentifier)id;
        return Objects.equals(moduleId.getGroup(), "org.immutables") && Objects.equals(moduleId.getModule(), "value");
    }
}

