/*
 * Decompiled with CFR 0.152.
 */
package com.owlr.provider;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.owlr.provider.MetaDataUtils;
import com.owlr.provider.SharedCursorUtils;
import com.owlr.provider.SharedSharedPreferences;
import com.owlr.provider.Types;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SharedProviderFinder
implements Types {
    private static SharedProviderFinder sharedProviderFinder;
    private final Context context;
    private final Pattern authorityMatcherPattern;
    private final String sharedPermission;
    private final ContentResolver contentResolver;

    private static SharedProviderFinder initDefaultFinder(Context context) {
        String sharedPermission = MetaDataUtils.getSharedPermission(context);
        String matcherPattern = MetaDataUtils.getSharedAuthorityMatcher(context);
        if (TextUtils.isEmpty((CharSequence)matcherPattern)) {
            throw new IllegalStateException("You need to define the \"app_authority_matcher\" meta-data in your ApplicationManifest.xml");
        }
        Pattern pattern = Pattern.compile(matcherPattern);
        return new SharedProviderFinder(context, pattern, sharedPermission, context.getContentResolver());
    }

    public static SharedProviderFinder get(Context context) {
        if (sharedProviderFinder == null) {
            sharedProviderFinder = SharedProviderFinder.initDefaultFinder(context);
        }
        return sharedProviderFinder;
    }

    protected SharedProviderFinder(Context context, Pattern authorityMatcherPattern, String sharedPermission, ContentResolver contentResolver) {
        this.context = context;
        this.authorityMatcherPattern = authorityMatcherPattern;
        this.sharedPermission = sharedPermission;
        this.contentResolver = contentResolver;
    }

    public List<ProviderInfo> findProviders() {
        Log.i((String)"SharedProviders", (String)("Find Authorities using: " + this.authorityMatcherPattern.pattern() + " Permission: " + this.sharedPermission));
        List<ProviderInfo> installedProviders = this.getInstalledProviders();
        ArrayList<ProviderInfo> matchedProviders = new ArrayList<ProviderInfo>(installedProviders.size());
        for (ProviderInfo provider : installedProviders) {
            Matcher matcher = this.authorityMatcherPattern.matcher(provider.authority);
            if (!matcher.matches() || TextUtils.isEmpty((CharSequence)provider.authority) || !this.sharedPermission.equalsIgnoreCase(provider.writePermission)) continue;
            Log.d((String)"SharedProviders", (String)("provider: " + provider.authority + " Matches: " + matcher.matches()));
            matchedProviders.add(provider);
        }
        Log.d((String)"SharedProviders", (String)("Found " + matchedProviders.size() + " providers."));
        return matchedProviders;
    }

    public String findMasterProvider(List<ProviderInfo> providerInfos) {
        if (providerInfos.size() < 1) {
            throw new IllegalStateException("There should be at least one Provider registered for this to work.");
        }
        String masterAuthority = null;
        int size = providerInfos.size();
        for (int i = 0; i < size; ++i) {
            ProviderInfo providerInfo = providerInfos.get(i);
            String authority = providerInfo.authority;
            if (TextUtils.isEmpty((CharSequence)authority)) continue;
            Log.d((String)"SharedProviders", (String)("Auth " + authority + " check for master"));
            boolean isMaster = this.isProviderMaster(this.getContentUri(authority), this.contentResolver);
            Log.d((String)"SharedProviders", (String)("Auth " + authority + " isMaster: " + isMaster));
            if (isMaster && TextUtils.isEmpty(masterAuthority)) {
                masterAuthority = authority;
                continue;
            }
            if (!isMaster || TextUtils.isEmpty(masterAuthority)) continue;
            Log.d((String)"SharedProviders", (String)("Un-Delegate Auth: " + authority));
            this.delegateMaster(authority, false);
        }
        if (!TextUtils.isEmpty(masterAuthority)) {
            return masterAuthority;
        }
        return this.delegateMaster(providerInfos.get((int)0).authority, true);
    }

    public String findMasterProvider() {
        return this.findMasterProvider(this.findProviders());
    }

    boolean isProviderMaster(Uri contentUri, ContentResolver resolver) {
        return SharedCursorUtils.getBooleanValue(resolver.query(contentUri, null, null, null, null), false);
    }

    Uri getContentUri(String authority) {
        return SharedSharedPreferences.getContentUri(authority, "master", "boolean");
    }

    String delegateMaster(String authority, boolean isMaster) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("master", Boolean.valueOf(isMaster));
        this.context.getContentResolver().insert(SharedSharedPreferences.getContentUri(authority, "key", "type"), contentValues);
        return authority;
    }

    List<ProviderInfo> getInstalledProviders() {
        List installedPackages = this.context.getPackageManager().getInstalledPackages(8);
        ArrayList<ProviderInfo> providerInfoList = new ArrayList<ProviderInfo>();
        for (int i = 0; i < installedPackages.size(); ++i) {
            PackageInfo packageInfo = (PackageInfo)installedPackages.get(i);
            if (packageInfo.providers == null) continue;
            Collections.addAll(providerInfoList, packageInfo.providers);
        }
        return providerInfoList;
    }
}

