/*
 * Decompiled with CFR 0.152.
 */
package com.owlr.provider;

import android.content.ContentValues;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.ProviderInfo;
import android.text.TextUtils;
import android.util.Log;
import com.owlr.provider.MetaDataUtils;
import com.owlr.provider.SharedCursorUtils;
import com.owlr.provider.SharedSharedPreferences;
import com.owlr.provider.Types;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SharedProviderFinder
implements Types {
    private static SharedProviderFinder sharedProviderFinder;
    private final Pattern mPattern;
    private final Context context;

    public static SharedProviderFinder get(Context context) {
        if (sharedProviderFinder == null) {
            sharedProviderFinder = new SharedProviderFinder(context);
        }
        return sharedProviderFinder;
    }

    private SharedProviderFinder(Context context) {
        this.context = context;
        String matcherPattern = MetaDataUtils.getSharedAuthorityMatcher(context);
        if (TextUtils.isEmpty((CharSequence)matcherPattern)) {
            throw new IllegalStateException("You need to define the \"app_authority_matcher\" meta-data in your ApplicationManifest.xml");
        }
        this.mPattern = Pattern.compile(matcherPattern);
    }

    public List<ProviderInfo> findProviders() {
        Log.i((String)"SharedProviders", (String)("Find Authorities using: " + this.mPattern.pattern()));
        List<ProviderInfo> installedProviders = this.getInstalledProviders();
        ArrayList<ProviderInfo> sharedProviders = new ArrayList<ProviderInfo>(installedProviders);
        for (ProviderInfo provider : installedProviders) {
            Matcher matcher = this.mPattern.matcher(provider.authority);
            if (!matcher.matches() || TextUtils.isEmpty((CharSequence)provider.authority)) {
                sharedProviders.remove(provider);
                continue;
            }
            Log.d((String)"SharedProviders", (String)("provider: " + provider.authority + " Matches: " + matcher.matches()));
        }
        Log.d((String)"SharedProviders", (String)("Found " + sharedProviders.size() + " providers."));
        return sharedProviders;
    }

    public String findMasterProvider(List<ProviderInfo> providerInfos) {
        if (providerInfos.size() < 1) {
            throw new IllegalStateException("There should be at least one Provider registered for this to work.");
        }
        String masterAuthority = null;
        for (int i = 0; i < providerInfos.size(); ++i) {
            ProviderInfo providerInfo = providerInfos.get(i);
            String authority = providerInfo.authority;
            if (TextUtils.isEmpty((CharSequence)authority)) continue;
            boolean isMaster = SharedCursorUtils.getBooleanValue(this.context.getContentResolver().query(SharedSharedPreferences.getContentUri(authority, "master", "boolean"), null, null, null, null), false);
            Log.d((String)"SharedProviders", (String)("Auth " + authority + " isMaster: " + isMaster));
            if (isMaster && TextUtils.isEmpty(masterAuthority)) {
                masterAuthority = authority;
                continue;
            }
            if (!isMaster || TextUtils.isEmpty(masterAuthority)) continue;
            Log.d((String)"SharedProviders", (String)("Un-Delegate Auth: " + authority));
            this.delegateMaster(authority, false);
        }
        if (!TextUtils.isEmpty(masterAuthority)) {
            return masterAuthority;
        }
        return this.delegateMaster(providerInfos.get((int)0).authority, true);
    }

    public String findMasterProvider() {
        return this.findMasterProvider(this.findProviders());
    }

    private String delegateMaster(String authority, boolean isMaster) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("master", Boolean.valueOf(isMaster));
        this.context.getContentResolver().insert(SharedSharedPreferences.getContentUri(authority, "key", "type"), contentValues);
        return authority;
    }

    private List<ProviderInfo> getInstalledProviders() {
        List installedPackages = this.context.getPackageManager().getInstalledPackages(8);
        ArrayList<ProviderInfo> providerInfoList = new ArrayList<ProviderInfo>();
        for (int i = 0; i < installedPackages.size(); ++i) {
            PackageInfo packageInfo = (PackageInfo)installedPackages.get(i);
            if (packageInfo.providers == null) continue;
            Collections.addAll(providerInfoList, packageInfo.providers);
        }
        return providerInfoList;
    }
}

