/*
 * Decompiled with CFR 0.152.
 */
package com.owlr.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.Build;
import com.owlr.provider.MetaDataUtils;
import com.owlr.provider.SharedContentChangedReceiver;
import com.owlr.provider.SharedPreferencesProducer;
import com.owlr.provider.Types;
import java.util.Map;

public class SharedProvider
extends ContentProvider
implements Types {
    public static String AUTHORITY;
    public static Uri BASE_URI;
    private static UriMatcher sUriMatcher;
    private static final int MATCH_DATA = 0;
    private SharedPreferences mSharedPrefs;

    static void init(Context context) {
        if (BASE_URI != null) {
            return;
        }
        AUTHORITY = MetaDataUtils.getAppAuthority(context);
        sUriMatcher = new UriMatcher(-1);
        sUriMatcher.addURI(AUTHORITY, "*/*", 0);
        BASE_URI = Uri.parse((String)("content://" + AUTHORITY));
    }

    public boolean onCreate() {
        SharedProvider.init(this.getContext());
        this.mSharedPrefs = this.getSharedPreferences(this.getContext());
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        MatrixCursor cursor;
        switch (sUriMatcher.match(uri)) {
            case 0: {
                Object object;
                String key = (String)uri.getPathSegments().get(0);
                String type = (String)uri.getPathSegments().get(1);
                cursor = new MatrixCursor(new String[]{key});
                if (!this.mSharedPrefs.contains(key)) {
                    return cursor;
                }
                MatrixCursor.RowBuilder rowBuilder = cursor.newRow();
                if ("string".equals(type)) {
                    object = this.mSharedPrefs.getString(key, null);
                } else if ("boolean".equals(type)) {
                    object = this.mSharedPrefs.getBoolean(key, false) ? 1 : 0;
                } else if ("long".equals(type)) {
                    object = this.mSharedPrefs.getLong(key, 0L);
                } else if ("integer".equals(type)) {
                    object = this.mSharedPrefs.getInt(key, 0);
                } else if ("float".equals(type)) {
                    object = Float.valueOf(this.mSharedPrefs.getFloat(key, 0.0f));
                } else {
                    throw new IllegalArgumentException("Unsupported type " + uri);
                }
                rowBuilder.add(object);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported uri " + uri);
            }
        }
        return cursor;
    }

    public String getType(Uri uri) {
        return "vnd.android.cursor.item/vnd.com.owlr.provider.item";
    }

    public Uri insert(Uri uri, ContentValues values) {
        switch (sUriMatcher.match(uri)) {
            case 0: {
                SharedPreferences.Editor editor = this.mSharedPrefs.edit();
                for (Map.Entry entry : values.valueSet()) {
                    Object value = entry.getValue();
                    String key = (String)entry.getKey();
                    if (value == null) {
                        editor.remove(key);
                        continue;
                    }
                    if (value instanceof String) {
                        editor.putString(key, (String)value);
                        continue;
                    }
                    if (value instanceof Boolean) {
                        editor.putBoolean(key, ((Boolean)value).booleanValue());
                        continue;
                    }
                    if (value instanceof Long) {
                        editor.putLong(key, ((Long)value).longValue());
                        continue;
                    }
                    if (value instanceof Integer) {
                        editor.putInt(key, ((Integer)value).intValue());
                        continue;
                    }
                    if (value instanceof Float) {
                        editor.putFloat(key, ((Float)value).floatValue());
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported type " + uri);
                }
                if (Build.VERSION.SDK_INT > 8) {
                    editor.apply();
                } else {
                    editor.commit();
                }
                SharedProvider.updateSlaves(this.getContext(), this.mSharedPrefs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported uri " + uri);
            }
        }
        return null;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        switch (sUriMatcher.match(uri)) {
            case 0: {
                this.mSharedPrefs.edit().clear().commit();
                SharedProvider.updateSlaves(this.getContext(), this.mSharedPrefs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported uri " + uri);
            }
        }
        return 0;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException();
    }

    private SharedPreferences getSharedPreferences(Context context) {
        SharedPreferences sharedPreferences = null;
        if (context.getApplicationContext() instanceof SharedPreferencesProducer) {
            sharedPreferences = ((SharedPreferencesProducer)context.getApplicationContext()).provideSharedPreferences();
        }
        if (sharedPreferences == null) {
            sharedPreferences = this.getDefaultSharedPreferences(context);
        }
        if (!sharedPreferences.contains("created")) {
            sharedPreferences.edit().putLong("created", System.currentTimeMillis()).apply();
        }
        return sharedPreferences;
    }

    private SharedPreferences getDefaultSharedPreferences(Context context) {
        return context.getSharedPreferences("local_shared_prefs", 0);
    }

    private static void updateSlaves(Context context, SharedPreferences sharedPreferences) {
        if (sharedPreferences.getBoolean("master", false)) {
            SharedContentChangedReceiver.sendBroadcast(context, sharedPreferences.getAll());
        }
    }

    static {
        sUriMatcher = null;
    }
}

