/*
 * Decompiled with CFR 0.152.
 */
package com.owlr.provider;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.owlr.provider.SharedCursorUtils;
import com.owlr.provider.SharedProviderFinder;
import com.owlr.provider.Types;
import java.util.Map;
import java.util.Set;

public class SharedSharedPreferences
implements SharedPreferences,
Types {
    private final Context context;
    private String authority;

    static Uri getContentUri(String authority, String key, String type) {
        return Uri.parse((String)("content://" + authority)).buildUpon().appendPath(key).appendPath(type).build();
    }

    public SharedSharedPreferences(@NonNull Context context) {
        this.context = context.getApplicationContext();
        this.refreshAuthority();
    }

    protected SharedSharedPreferences(@NonNull Context context, @NonNull String authority) {
        this.context = context.getApplicationContext();
        this.authority = authority;
    }

    public SharedSharedPreferences refreshAuthority() {
        SharedProviderFinder finder = SharedProviderFinder.get(this.context);
        this.authority = finder.findMasterProvider();
        return this;
    }

    public Map<String, ?> getAll() {
        return null;
    }

    @Nullable
    public Set<String> getStringSet(String key, Set<String> defValues) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public String getString(String key, String def) {
        Cursor cursor = this.context.getContentResolver().query(SharedSharedPreferences.getContentUri(this.authority, key, "string"), null, null, null, null);
        return SharedCursorUtils.getStringValue(cursor, def);
    }

    public long getLong(String key, long def) {
        Cursor cursor = this.context.getContentResolver().query(SharedSharedPreferences.getContentUri(this.authority, key, "long"), null, null, null, null);
        return SharedCursorUtils.getLongValue(cursor, def);
    }

    public float getFloat(String key, float def) {
        Cursor cursor = this.context.getContentResolver().query(SharedSharedPreferences.getContentUri(this.authority, key, "float"), null, null, null, null);
        return SharedCursorUtils.getFloatValue(cursor, def);
    }

    public boolean getBoolean(String key, boolean def) {
        Cursor cursor = this.context.getContentResolver().query(SharedSharedPreferences.getContentUri(this.authority, key, "boolean"), null, null, null, null);
        return SharedCursorUtils.getBooleanValue(cursor, def);
    }

    public int getInt(String key, int def) {
        Cursor cursor = this.context.getContentResolver().query(SharedSharedPreferences.getContentUri(this.authority, key, "integer"), null, null, null, null);
        return SharedCursorUtils.getIntValue(cursor, def);
    }

    public boolean contains(String key) {
        return false;
    }

    public SharedEditor edit() {
        this.refreshAuthority();
        return new SharedEditor(this.context, this.authority);
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public static class SharedEditor
    implements SharedPreferences.Editor {
        private final Context context;
        private final String authority;
        private ContentValues values = new ContentValues();

        private SharedEditor(Context context, String authority) {
            this.context = context;
            this.authority = authority;
        }

        public void apply() {
            this.context.getContentResolver().insert(SharedSharedPreferences.getContentUri(this.authority, "key", "type"), this.values);
            this.values.clear();
        }

        public boolean commit() {
            this.apply();
            return true;
        }

        public SharedEditor putString(String key, String value) {
            this.values.put(key, value);
            return this;
        }

        public SharedEditor putStringSet(String key, Set<String> values) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public SharedEditor putLong(String key, long value) {
            this.values.put(key, Long.valueOf(value));
            return this;
        }

        public SharedEditor putBoolean(String key, boolean value) {
            this.values.put(key, Boolean.valueOf(value));
            return this;
        }

        public SharedEditor putInt(String key, int value) {
            this.values.put(key, Integer.valueOf(value));
            return this;
        }

        public SharedEditor putFloat(String key, float value) {
            this.values.put(key, Float.valueOf(value));
            return this;
        }

        public SharedEditor remove(String key) {
            this.values.putNull(key);
            return this;
        }

        public SharedEditor clear() {
            this.context.getContentResolver().delete(SharedSharedPreferences.getContentUri(this.authority, "key", "type"), null, null);
            return this;
        }
    }
}

