/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.reflect;

import com.owlike.genson.reflect.TypeUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public abstract class BeanProperty {
    protected final String name;
    protected final Type type;
    protected final Class<?> declaringClass;
    protected Annotation[] annotations;
    protected final int modifiers;

    protected BeanProperty(String name, Type type, Class<?> declaringClass, Annotation[] annotations, int modifiers) {
        this.name = name;
        this.type = type;
        this.declaringClass = declaringClass;
        this.annotations = annotations;
        this.modifiers = modifiers;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Class<?> getRawClass() {
        return TypeUtil.getRawClass(this.type);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        for (Annotation ann : this.annotations) {
            if (!annotationClass.isInstance(ann)) continue;
            return (T)((Annotation)annotationClass.cast(ann));
        }
        return null;
    }

    void updateWith(BeanProperty otherBeanProperty) {
        if (otherBeanProperty.annotations.length > 0) {
            Annotation[] mergedAnnotations = new Annotation[this.annotations.length + otherBeanProperty.annotations.length];
            System.arraycopy(this.annotations, 0, mergedAnnotations, 0, this.annotations.length);
            System.arraycopy(otherBeanProperty.annotations, 0, mergedAnnotations, this.annotations.length, otherBeanProperty.annotations.length);
            this.annotations = mergedAnnotations;
        }
    }

    abstract int priority();

    abstract String signature();
}

