/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.convert;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.Factory;
import com.owlike.genson.GenericType;
import com.owlike.genson.Genson;
import com.owlike.genson.JsonBindingException;
import com.owlike.genson.Operations;
import com.owlike.genson.annotation.HandleBeanView;
import com.owlike.genson.annotation.HandleClassMetadata;
import com.owlike.genson.annotation.HandleNull;
import com.owlike.genson.annotation.JsonConverter;
import com.owlike.genson.annotation.JsonDateFormat;
import com.owlike.genson.convert.ContextualFactory;
import com.owlike.genson.reflect.BeanProperty;
import com.owlike.genson.reflect.TypeUtil;
import com.owlike.genson.stream.JsonType;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import com.owlike.genson.stream.ValueType;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;

public final class DefaultConverters {
    private DefaultConverters() {
    }

    public static class WrappedRootValueConverter<T>
    implements Converter<T> {
        private final String inputName;
        private final String outputName;
        private final Converter<T> delegateConverter;

        public WrappedRootValueConverter(String inputName, String outputName, Converter<T> delegateConverter) {
            this.inputName = inputName;
            this.outputName = outputName;
            this.delegateConverter = delegateConverter;
        }

        @Override
        public void serialize(T object, ObjectWriter writer, Context ctx) throws Exception {
            if (writer.enclosingType() == JsonType.EMPTY) {
                writer.beginObject().writeName(this.outputName);
                this.delegateConverter.serialize(object, writer, ctx);
                writer.endObject();
            }
        }

        @Override
        public T deserialize(ObjectReader reader, Context ctx) throws Exception {
            T value = null;
            if (reader.enclosingType() == JsonType.EMPTY) {
                reader.beginObject();
                if (reader.hasNext()) {
                    reader.next();
                    if (!this.inputName.equalsIgnoreCase(reader.name())) {
                        throw new JsonBindingException(String.format("Expected key %s for unwrapping the value, but encountered key %s", this.inputName, reader.name()));
                    }
                    value = this.delegateConverter.deserialize(reader, ctx);
                }
                reader.endObject();
            }
            return value;
        }
    }

    public static final class PropertyConverterFactory
    implements ContextualFactory<Object> {
        @Override
        public Converter<Object> create(BeanProperty property, Genson genson) {
            JsonConverter ann = property.getAnnotation(JsonConverter.class);
            if (ann != null) {
                Type converterExpandedType = TypeUtil.expandType(TypeUtil.lookupGenericType(Converter.class, ann.value()), ann.value());
                Type converterPropertyType = TypeUtil.typeOf(0, converterExpandedType);
                Class<?> propertyClass = property.getRawClass();
                if (propertyClass.isPrimitive()) {
                    propertyClass = TypeUtil.wrap(propertyClass);
                }
                if (!TypeUtil.match(propertyClass, converterPropertyType, false)) {
                    throw new ClassCastException("The type defined in " + ann.value().getName() + " is not assignale from property " + property.getName() + " declared in " + property.getDeclaringClass());
                }
                try {
                    Constructor<Converter<?>> ctr = ann.value().getConstructor(new Class[0]);
                    if (!ctr.isAccessible()) {
                        ctr.setAccessible(true);
                    }
                    return ctr.newInstance(new Object[0]);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (SecurityException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    public static final class FileConverter
    implements Converter<File> {
        public static final FileConverter instance = new FileConverter();

        private FileConverter() {
        }

        @Override
        public void serialize(File object, ObjectWriter writer, Context ctx) {
            writer.writeValue(object.getPath());
        }

        @Override
        public File deserialize(ObjectReader reader, Context ctx) {
            return new File(reader.valueAsString());
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    public static class CalendarConverter
    implements Converter<Calendar> {
        private final DateConverter dateConverter;

        CalendarConverter(DateConverter dateConverter) {
            this.dateConverter = dateConverter;
        }

        @Override
        public void serialize(Calendar object, ObjectWriter writer, Context ctx) {
            this.dateConverter.serialize(object.getTime(), writer, ctx);
        }

        @Override
        public Calendar deserialize(ObjectReader reader, Context ctx) {
            GregorianCalendar cal = null;
            if (ValueType.NULL != reader.getValueType()) {
                cal = new GregorianCalendar();
                cal.setTime(this.dateConverter.deserialize(reader, ctx));
            }
            return cal;
        }
    }

    public static final class CalendarConverterFactory
    implements Factory<Converter<Calendar>> {
        private final CalendarConverter calendarConverter;

        public CalendarConverterFactory(DateConverter dateConverter) {
            this.calendarConverter = new CalendarConverter(dateConverter);
        }

        @Override
        public Converter<Calendar> create(Type type, Genson genson) {
            if (!Calendar.class.isAssignableFrom(TypeUtil.getRawClass(type))) {
                throw new IllegalStateException("CalendarConverterFactory create method can be called only for Calendar type and subtypes.");
            }
            return this.calendarConverter;
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    public static class UUIDConverter
    implements Converter<UUID> {
        public static final UUIDConverter instance = new UUIDConverter();

        private UUIDConverter() {
        }

        @Override
        public void serialize(UUID object, ObjectWriter writer, Context ctx) {
            writer.writeValue(object.toString());
        }

        @Override
        public UUID deserialize(ObjectReader reader, Context ctx) {
            return UUID.fromString(reader.valueAsString());
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    public static class TimestampConverter
    implements Converter<Timestamp> {
        public static final TimestampConverter instance = new TimestampConverter();

        private TimestampConverter() {
        }

        @Override
        public Timestamp deserialize(ObjectReader reader, Context ctx) {
            return Timestamp.valueOf(reader.valueAsString());
        }

        @Override
        public void serialize(Timestamp object, ObjectWriter writer, Context ctx) {
            writer.writeValue(object.toString());
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    public static class BigIntegerConverter
    implements Converter<BigInteger> {
        public static final BigIntegerConverter instance = new BigIntegerConverter();

        private BigIntegerConverter() {
        }

        @Override
        public BigInteger deserialize(ObjectReader reader, Context ctx) {
            return new BigInteger(reader.valueAsString());
        }

        @Override
        public void serialize(BigInteger object, ObjectWriter writer, Context ctx) {
            writer.writeValue(object);
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    public static class BigDecimalConverter
    implements Converter<BigDecimal> {
        public static final BigDecimalConverter instance = new BigDecimalConverter();

        private BigDecimalConverter() {
        }

        @Override
        public BigDecimal deserialize(ObjectReader reader, Context ctx) {
            return new BigDecimal(reader.valueAsString());
        }

        @Override
        public void serialize(BigDecimal object, ObjectWriter writer, Context ctx) {
            writer.writeValue(object);
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    public static class URIConverter
    implements Converter<URI> {
        public static final URIConverter instance = new URIConverter();

        private URIConverter() {
        }

        @Override
        public void serialize(URI object, ObjectWriter writer, Context ctx) {
            writer.writeUnsafeValue(object.toString());
        }

        @Override
        public URI deserialize(ObjectReader reader, Context ctx) {
            return URI.create(reader.valueAsString());
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    public static class URLConverter
    implements Converter<URL> {
        public static final URLConverter instance = new URLConverter();

        private URLConverter() {
        }

        @Override
        public URL deserialize(ObjectReader reader, Context ctx) {
            try {
                return new URL(reader.valueAsString());
            }
            catch (MalformedURLException e) {
                throw new JsonBindingException("Can not deserializer <" + reader.valueAsString() + "> to URL.");
            }
        }

        @Override
        public void serialize(URL object, ObjectWriter writer, Context ctx) {
            writer.writeValue(object.toExternalForm());
        }
    }

    public static final class EnumConverterFactory
    implements Factory<Converter<? extends Enum<?>>> {
        public static final EnumConverterFactory instance = new EnumConverterFactory();

        private EnumConverterFactory() {
        }

        @Override
        public Converter<Enum<?>> create(Type type, Genson genson) {
            Class<?> rawClass = TypeUtil.getRawClass(type);
            return rawClass.isEnum() || Enum.class.isAssignableFrom(rawClass) ? new EnumConverter(rawClass) : null;
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    public static class EnumConverter<T extends Enum<T>>
    implements Converter<T> {
        private final Class<T> eClass;

        public EnumConverter(Class<T> eClass) {
            this.eClass = eClass;
        }

        @Override
        public void serialize(T obj, ObjectWriter writer, Context ctx) {
            writer.writeUnsafeValue(((Enum)obj).name());
        }

        @Override
        public T deserialize(ObjectReader reader, Context ctx) {
            return Enum.valueOf(this.eClass, reader.valueAsString());
        }
    }

    public static final class UntypedConverterFactory
    implements Factory<Converter<Object>> {
        public static final UntypedConverterFactory instance = new UntypedConverterFactory();

        private UntypedConverterFactory() {
        }

        @Override
        public Converter<Object> create(Type type, Genson genson) {
            if (TypeUtil.match(type, Object.class, true)) {
                return UntypedConverter.instance;
            }
            return null;
        }

        private static final class UntypedConverter
        implements Converter<Object> {
            static final UntypedConverter instance = new UntypedConverter();

            private UntypedConverter() {
            }

            @Override
            public Object deserialize(ObjectReader reader, Context ctx) {
                return ctx.genson.deserialize(GenericType.of(reader.getValueType().toClass()), reader, ctx);
            }

            @Override
            public void serialize(Object obj, ObjectWriter writer, Context ctx) {
                if (Object.class.equals(obj.getClass())) {
                    throw new UnsupportedOperationException("Serialization of type Object is not supported by default serializers.");
                }
                ctx.genson.serialize(obj, obj.getClass(), writer, ctx);
            }
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    public static class DateConverter
    implements Converter<Date> {
        private DateFormat dateFormat;
        private final boolean asTimeInMillis;

        public DateConverter() {
            this(SimpleDateFormat.getDateTimeInstance(), true);
        }

        public DateConverter(DateFormat dateFormat, boolean asTimeInMillis) {
            if (dateFormat == null) {
                dateFormat = SimpleDateFormat.getDateTimeInstance();
            }
            this.dateFormat = dateFormat;
            this.asTimeInMillis = asTimeInMillis;
        }

        @Override
        public void serialize(Date obj, ObjectWriter writer, Context ctx) {
            if (this.asTimeInMillis) {
                writer.writeValue(obj.getTime());
            } else {
                writer.writeUnsafeValue(this.format(obj));
            }
        }

        protected synchronized String format(Date date) {
            return this.dateFormat.format(date);
        }

        @Override
        public Date deserialize(ObjectReader reader, Context ctx) {
            try {
                ValueType valueType = reader.getValueType();
                if (valueType == ValueType.INTEGER) {
                    return new Date(reader.valueAsLong());
                }
                if (valueType == ValueType.STRING) {
                    return this.read(reader.valueAsString());
                }
                throw new JsonBindingException(String.format("Can not deserialize type %s to Date, only numeric and string accepted.", new Object[]{valueType}));
            }
            catch (ParseException e) {
                throw new JsonBindingException("Could not parse date " + reader.valueAsString(), e);
            }
        }

        protected synchronized Date read(String dateString) throws ParseException {
            return this.dateFormat.parse(dateString);
        }
    }

    public static class DateContextualFactory
    implements ContextualFactory {
        public Converter create(BeanProperty property, Genson genson) {
            JsonDateFormat ann = property.getAnnotation(JsonDateFormat.class);
            if (ann != null) {
                DateFormat dateFormat;
                Locale locale = ann.lang().isEmpty() ? Locale.getDefault() : new Locale(ann.lang());
                DateFormat dateFormat2 = dateFormat = ann.value() != null && !ann.value().isEmpty() ? new SimpleDateFormat(ann.value(), locale) : SimpleDateFormat.getInstance();
                if (Date.class.isAssignableFrom(property.getRawClass())) {
                    return new DateConverter(dateFormat, ann.asTimeInMillis());
                }
                if (Calendar.class.isAssignableFrom(property.getRawClass())) {
                    return new CalendarConverter(new DateConverter(dateFormat, ann.asTimeInMillis()));
                }
            }
            return null;
        }
    }

    public static final class MapConverterFactory
    implements Factory<Converter<? extends Map<?, ?>>> {
        public static final MapConverterFactory instance = new MapConverterFactory();

        private MapConverterFactory() {
        }

        @Override
        public Converter<? extends Map<?, ?>> create(Type type, Genson genson) {
            Type expandedType = type;
            if (TypeUtil.getRawClass(type).getTypeParameters().length == 0) {
                expandedType = TypeUtil.expandType(TypeUtil.lookupGenericType(Map.class, TypeUtil.getRawClass(type)), type);
            }
            Type keyType = TypeUtil.typeOf(0, expandedType);
            Type valueType = TypeUtil.typeOf(1, expandedType);
            Class<?> keyRawClass = TypeUtil.getRawClass(keyType);
            KeyAdapter<?> keyAdapter = MapConverterFactory.keyAdapter(keyRawClass);
            if (keyAdapter != null) {
                return this.createConverter(TypeUtil.getRawClass(type), keyAdapter, genson.provideConverter(valueType));
            }
            return new ComplexMapConverter(genson.provideConverter(keyType), genson.provideConverter(valueType));
        }

        public static KeyAdapter<?> keyAdapter(Class<?> keyRawClass) {
            if (Object.class.equals(keyRawClass)) {
                return KeyAdapter.runtimeAdapter;
            }
            if (String.class.equals(keyRawClass)) {
                return KeyAdapter.strAdapter;
            }
            if (Integer.TYPE.equals(keyRawClass) || Integer.class.equals(keyRawClass)) {
                return KeyAdapter.intAdapter;
            }
            if (Double.TYPE.equals(keyRawClass) || Double.class.equals(keyRawClass)) {
                return KeyAdapter.doubleAdapter;
            }
            if (Long.TYPE.equals(keyRawClass) || Long.class.equals(keyRawClass)) {
                return KeyAdapter.longAdapter;
            }
            if (Float.TYPE.equals(keyRawClass) || Float.class.equals(keyRawClass)) {
                return KeyAdapter.floatAdapter;
            }
            if (Short.TYPE.equals(keyRawClass) || Short.class.equals(keyRawClass)) {
                return KeyAdapter.shortAdapter;
            }
            return null;
        }

        private <K, V> MapConverter<K, V> createConverter(Class<?> typeOfMap, KeyAdapter<K> keyAdapter, Converter<V> valueConverter) {
            if (Properties.class.equals(typeOfMap)) {
                return new PropertiesConverter((KeyAdapter)keyAdapter, (Converter)valueConverter);
            }
            if (Hashtable.class.equals(typeOfMap)) {
                return new HashTableConverter<K, V>(keyAdapter, valueConverter);
            }
            if (TreeMap.class.equals(typeOfMap)) {
                return new TreeMapConverter<K, V>(keyAdapter, valueConverter);
            }
            if (LinkedHashMap.class.equals(typeOfMap)) {
                return new LinkedHashMapConverter<K, V>(keyAdapter, valueConverter);
            }
            return new HashMapConverter<K, V>(keyAdapter, valueConverter);
        }
    }

    @HandleClassMetadata
    public static class ComplexMapConverter<K, V>
    implements Converter<Map<K, V>> {
        private final Converter<K> keyConverter;
        private final Converter<V> valueConverter;

        private ComplexMapConverter(Converter<K> keyConverter, Converter<V> valueConverter) {
            this.keyConverter = keyConverter;
            this.valueConverter = valueConverter;
        }

        @Override
        public void serialize(Map<K, V> object, ObjectWriter writer, Context ctx) throws Exception {
            writer.beginArray();
            for (Map.Entry<K, V> entry : object.entrySet()) {
                writer.beginObject().writeName("key");
                this.keyConverter.serialize(entry.getKey(), writer, ctx);
                writer.writeName("value");
                this.valueConverter.serialize(entry.getValue(), writer, ctx);
                writer.endObject();
            }
            writer.endArray();
        }

        @Override
        public Map<K, V> deserialize(ObjectReader reader, Context ctx) throws Exception {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            reader.beginArray();
            while (reader.hasNext()) {
                reader.next();
                reader.beginObject();
                Object key = null;
                Object value = null;
                while (reader.hasNext()) {
                    reader.next();
                    if ("key".equals(reader.name())) {
                        key = this.keyConverter.deserialize(reader, ctx);
                        continue;
                    }
                    if (!"value".equals(reader.name())) continue;
                    value = this.valueConverter.deserialize(reader, ctx);
                }
                map.put(key, value);
                reader.endObject();
            }
            reader.endArray();
            return map;
        }
    }

    public static abstract class KeyAdapter<K> {
        public static final KeyAdapter<Object> runtimeAdapter = new KeyAdapter<Object>(){

            @Override
            public Object adapt(String str) {
                return str;
            }

            @Override
            public String adapt(Object key) {
                return key.toString();
            }
        };
        public static final KeyAdapter<String> strAdapter = new KeyAdapter<String>(){

            @Override
            public String adapt(String key) {
                return key;
            }
        };
        public static final KeyAdapter<Short> shortAdapter = new KeyAdapter<Short>(){

            @Override
            public Short adapt(String str) {
                return Short.parseShort(str);
            }

            @Override
            public String adapt(Short key) {
                return key.toString();
            }
        };
        public static final KeyAdapter<Integer> intAdapter = new KeyAdapter<Integer>(){

            @Override
            public Integer adapt(String str) {
                return Integer.parseInt(str);
            }

            @Override
            public String adapt(Integer key) {
                return key.toString();
            }
        };
        public static final KeyAdapter<Long> longAdapter = new KeyAdapter<Long>(){

            @Override
            public Long adapt(String str) {
                return Long.parseLong(str);
            }

            @Override
            public String adapt(Long key) {
                return key.toString();
            }
        };
        public static final KeyAdapter<Float> floatAdapter = new KeyAdapter<Float>(){

            @Override
            public Float adapt(String str) {
                return Float.valueOf(Float.parseFloat(str));
            }

            @Override
            public String adapt(Float key) {
                return key.toString();
            }
        };
        public static final KeyAdapter<Double> doubleAdapter = new KeyAdapter<Double>(){

            @Override
            public Double adapt(String str) {
                return Double.parseDouble(str);
            }

            @Override
            public String adapt(Double key) {
                return key.toString();
            }
        };

        public abstract K adapt(String var1);

        public abstract String adapt(K var1);
    }

    public static final class LinkedHashMapConverter<K, V>
    extends MapConverter<K, V> {
        public LinkedHashMapConverter(KeyAdapter<K> keyAdapter, Converter<V> valueConverter) {
            super(keyAdapter, valueConverter);
        }

        @Override
        protected Map<K, V> create() {
            return new LinkedHashMap();
        }
    }

    public static final class TreeMapConverter<K, V>
    extends MapConverter<K, V> {
        public TreeMapConverter(KeyAdapter<K> keyAdapter, Converter<V> valueConverter) {
            super(keyAdapter, valueConverter);
        }

        @Override
        public void serialize(Map<K, V> obj, ObjectWriter writer, Context ctx) throws Exception {
            TreeMap treeMap = (TreeMap)obj;
            if (((TreeMap)obj).comparator() != null) {
                throw new UnsupportedOperationException("Serialization and deserialization of TreeMap with Comparator is not supported. You need to implement a custom Converter to handle it.");
            }
            super.serialize(obj, writer, ctx);
        }

        @Override
        protected Map<K, V> create() {
            return new TreeMap();
        }
    }

    public static final class PropertiesConverter
    extends MapConverter {
        public PropertiesConverter(KeyAdapter keyAdapter, Converter valueConverter) {
            super(keyAdapter, valueConverter);
        }

        protected Map create() {
            return new Properties();
        }
    }

    public static final class HashTableConverter<K, V>
    extends MapConverter<K, V> {
        public HashTableConverter(KeyAdapter<K> keyAdapter, Converter<V> valueConverter) {
            super(keyAdapter, valueConverter);
        }

        @Override
        protected Map<K, V> create() {
            return new Hashtable();
        }
    }

    public static final class HashMapConverter<K, V>
    extends MapConverter<K, V> {
        public HashMapConverter(KeyAdapter<K> keyAdapter, Converter<V> valueConverter) {
            super(keyAdapter, valueConverter);
        }

        @Override
        protected Map<K, V> create() {
            return new HashMap();
        }
    }

    @HandleClassMetadata
    public static abstract class MapConverter<K, V>
    implements Converter<Map<K, V>> {
        private final Converter<V> valueConverter;
        private final KeyAdapter<K> keyAdapter;

        public MapConverter(KeyAdapter<K> keyAdapter, Converter<V> valueConverter) {
            this.keyAdapter = keyAdapter;
            this.valueConverter = valueConverter;
        }

        @Override
        public Map<K, V> deserialize(ObjectReader reader, Context ctx) throws Exception {
            reader.beginObject();
            Map<K, V> map = this.create();
            while (reader.hasNext()) {
                reader.next();
                map.put(this.keyAdapter.adapt(reader.name()), this.valueConverter.deserialize(reader, ctx));
            }
            reader.endObject();
            return map;
        }

        @Override
        public void serialize(Map<K, V> obj, ObjectWriter writer, Context ctx) throws Exception {
            writer.beginObject();
            for (Map.Entry<K, V> entry : obj.entrySet()) {
                writer.writeName(this.keyAdapter.adapt(entry.getKey()));
                this.valueConverter.serialize(entry.getValue(), writer, ctx);
            }
            writer.endObject();
        }

        protected abstract Map<K, V> create();
    }

    public static final class PrimitiveConverterFactory
    implements Factory<Converter<?>> {
        public static final PrimitiveConverterFactory instance = new PrimitiveConverterFactory();

        private PrimitiveConverterFactory() {
        }

        @Override
        public Converter<?> create(Type type, Genson genson) {
            Class<?> rawClass = TypeUtil.getRawClass(type);
            if (rawClass.isPrimitive()) {
                if (rawClass.equals(Boolean.TYPE)) {
                    return booleanConverter.instance;
                }
                if (rawClass.equals(Integer.TYPE)) {
                    return intConverter.instance;
                }
                if (rawClass.equals(Double.TYPE)) {
                    return doubleConverter.instance;
                }
                if (rawClass.equals(Long.TYPE)) {
                    return longConverter.instance;
                }
                if (rawClass.equals(Short.TYPE)) {
                    return ShortConverter.instance;
                }
                if (rawClass.equals(Float.TYPE)) {
                    return FloatConverter.instance;
                }
                if (rawClass.equals(Character.TYPE)) {
                    return CharConverter.instance;
                }
                if (rawClass.equals(Byte.TYPE)) {
                    return ByteConverter.instance;
                }
            }
            return null;
        }

        @HandleClassMetadata
        @HandleNull
        @HandleBeanView
        public static final class longConverter
        implements Converter<Long> {
            public static final longConverter instance = new longConverter();

            private longConverter() {
            }

            @Override
            public void serialize(Long obj, ObjectWriter writer, Context ctx) {
                writer.writeValue(obj);
            }

            @Override
            public Long deserialize(ObjectReader reader, Context ctx) {
                return reader.valueAsLong();
            }
        }

        @HandleClassMetadata
        @HandleNull
        @HandleBeanView
        public static final class doubleConverter
        implements Converter<Double> {
            public static final doubleConverter instance = new doubleConverter();

            private doubleConverter() {
            }

            @Override
            public void serialize(Double obj, ObjectWriter writer, Context ctx) {
                writer.writeValue(obj);
            }

            @Override
            public Double deserialize(ObjectReader reader, Context ctx) {
                return reader.valueAsDouble();
            }
        }

        @HandleClassMetadata
        @HandleNull
        @HandleBeanView
        public static final class intConverter
        implements Converter<Integer> {
            public static final intConverter instance = new intConverter();

            private intConverter() {
            }

            @Override
            public void serialize(Integer obj, ObjectWriter writer, Context ctx) {
                writer.writeValue(obj);
            }

            @Override
            public Integer deserialize(ObjectReader reader, Context ctx) {
                return reader.valueAsInt();
            }
        }

        @HandleClassMetadata
        @HandleNull
        @HandleBeanView
        public static final class booleanConverter
        implements Converter<Boolean> {
            public static final booleanConverter instance = new booleanConverter();

            private booleanConverter() {
            }

            @Override
            public void serialize(Boolean obj, ObjectWriter writer, Context ctx) {
                writer.writeValue(obj);
            }

            @Override
            public Boolean deserialize(ObjectReader reader, Context ctx) {
                return reader.valueAsBoolean();
            }
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    public static final class ByteConverter
    implements Converter<Byte> {
        public static final ByteConverter instance = new ByteConverter();

        private ByteConverter() {
        }

        @Override
        public void serialize(Byte obj, ObjectWriter writer, Context ctx) {
            writer.writeValue(obj.byteValue());
        }

        @Override
        public Byte deserialize(ObjectReader reader, Context ctx) {
            return (byte)reader.valueAsInt();
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    public static final class CharConverter
    implements Converter<Character> {
        public static final CharConverter instance = new CharConverter();

        private CharConverter() {
        }

        @Override
        public void serialize(Character obj, ObjectWriter writer, Context ctx) {
            writer.writeValue(obj.toString());
        }

        @Override
        public Character deserialize(ObjectReader reader, Context ctx) {
            String str = reader.valueAsString();
            if (str.length() > 1) {
                throw new JsonBindingException("Could not convert a string with length greater than 1 to a single char.");
            }
            return Character.valueOf(str.charAt(0));
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    public static final class NumberConverter
    implements Converter<Number> {
        public static final NumberConverter instance = new NumberConverter();

        private NumberConverter() {
        }

        @Override
        public Number deserialize(ObjectReader reader, Context ctx) {
            ValueType vt = reader.getValueType();
            if (ValueType.INTEGER.equals((Object)vt)) {
                return reader.valueAsInt();
            }
            if (ValueType.DOUBLE.equals((Object)vt)) {
                return reader.valueAsDouble();
            }
            String value = reader.valueAsString();
            return "".equals(value) ? (Number)null : (Number)this.parse(value, vt);
        }

        @Override
        public void serialize(Number obj, ObjectWriter writer, Context ctx) {
            writer.writeValue(obj);
        }

        private Number parse(String value, ValueType valueType) {
            try {
                if (value.indexOf(46) >= 0) {
                    return Double.parseDouble(value);
                }
                long longValue = Long.parseLong(value);
                if (longValue <= Integer.MAX_VALUE && longValue >= Integer.MIN_VALUE) {
                    return (int)longValue;
                }
                return Long.parseLong(value);
            }
            catch (NumberFormatException nfe) {
                throw new JsonBindingException("Could not convert input value " + value + " of type " + valueType.toClass() + " to a Number type.", nfe);
            }
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    public static final class FloatConverter
    implements Converter<Float> {
        public static final FloatConverter instance = new FloatConverter();

        private FloatConverter() {
        }

        @Override
        public Float deserialize(ObjectReader reader, Context ctx) {
            if (ValueType.STRING.equals((Object)reader.getValueType())) {
                String value = reader.valueAsString();
                return "".equals(value) ? null : Float.valueOf(Float.parseFloat(value));
            }
            return Float.valueOf(reader.valueAsFloat());
        }

        @Override
        public void serialize(Float obj, ObjectWriter writer, Context ctx) {
            writer.writeValue(obj.floatValue());
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    public static final class DoubleConverter
    implements Converter<Double> {
        public static final DoubleConverter instance = new DoubleConverter();

        private DoubleConverter() {
        }

        @Override
        public Double deserialize(ObjectReader reader, Context ctx) {
            if (ValueType.STRING.equals((Object)reader.getValueType())) {
                String value = reader.valueAsString();
                return "".equals(value) ? null : Double.valueOf(Double.parseDouble(value));
            }
            return reader.valueAsDouble();
        }

        @Override
        public void serialize(Double obj, ObjectWriter writer, Context ctx) {
            writer.writeValue(obj);
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    public static final class ShortConverter
    implements Converter<Short> {
        public static final ShortConverter instance = new ShortConverter();

        private ShortConverter() {
        }

        @Override
        public Short deserialize(ObjectReader reader, Context ctx) {
            if (ValueType.STRING.equals((Object)reader.getValueType())) {
                String value = reader.valueAsString();
                return "".equals(value) ? null : Short.valueOf(Short.parseShort(value));
            }
            return reader.valueAsShort();
        }

        @Override
        public void serialize(Short obj, ObjectWriter writer, Context ctx) {
            writer.writeValue(obj);
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    public static final class LongConverter
    implements Converter<Long> {
        public static final LongConverter instance = new LongConverter();

        private LongConverter() {
        }

        @Override
        public Long deserialize(ObjectReader reader, Context ctx) {
            if (ValueType.STRING.equals((Object)reader.getValueType())) {
                String value = reader.valueAsString();
                return "".equals(value) ? null : Long.valueOf(Long.parseLong(value));
            }
            return reader.valueAsLong();
        }

        @Override
        public void serialize(Long obj, ObjectWriter writer, Context ctx) {
            writer.writeValue(obj);
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    public static final class IntegerConverter
    implements Converter<Integer> {
        public static final IntegerConverter instance = new IntegerConverter();

        private IntegerConverter() {
        }

        @Override
        public void serialize(Integer obj, ObjectWriter writer, Context ctx) {
            writer.writeValue(obj);
        }

        @Override
        public Integer deserialize(ObjectReader reader, Context ctx) {
            if (ValueType.STRING.equals((Object)reader.getValueType())) {
                String value = reader.valueAsString();
                return "".equals(value) ? null : Integer.valueOf(value);
            }
            return reader.valueAsInt();
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    public static final class BooleanConverter
    implements Converter<Boolean> {
        public static final BooleanConverter instance = new BooleanConverter();

        private BooleanConverter() {
        }

        @Override
        public void serialize(Boolean obj, ObjectWriter writer, Context ctx) {
            writer.writeValue(obj);
        }

        @Override
        public Boolean deserialize(ObjectReader reader, Context ctx) {
            if (ValueType.STRING.equals((Object)reader.getValueType())) {
                String value = reader.valueAsString();
                return "".equals(value) ? null : Boolean.valueOf(value);
            }
            return reader.valueAsBoolean();
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    public static final class StringConverter
    implements Converter<String> {
        public static final StringConverter instance = new StringConverter();

        private StringConverter() {
        }

        @Override
        public void serialize(String value, ObjectWriter writer, Context ctx) {
            writer.writeValue(value);
        }

        @Override
        public String deserialize(ObjectReader reader, Context ctx) {
            return reader.valueAsString();
        }
    }

    public static final class ArrayConverterFactory
    implements Factory<Converter<Object>> {
        public static final ArrayConverterFactory instance = new ArrayConverterFactory();

        private ArrayConverterFactory() {
        }

        @Override
        public Converter<Object> create(Type forType, Genson genson) {
            if (forType instanceof GenericArrayType || forType instanceof Class && ((Class)forType).isArray()) {
                if (Byte.TYPE.equals(TypeUtil.getCollectionType(forType))) {
                    return ByteArrayConverter.instance;
                }
                Converter elementConverter = genson.provideConverter(TypeUtil.getCollectionType(forType));
                return new ArrayConverter(TypeUtil.getRawClass(TypeUtil.getCollectionType(forType)), elementConverter);
            }
            return null;
        }
    }

    @HandleClassMetadata
    public static class ByteArrayAsIntArrayConverter
    implements Converter<byte[]> {
        public static final ByteArrayAsIntArrayConverter instance = new ByteArrayAsIntArrayConverter();

        private ByteArrayAsIntArrayConverter() {
        }

        @Override
        public void serialize(byte[] object, ObjectWriter writer, Context ctx) throws Exception {
            writer.beginArray();
            for (int i = 0; i < object.length; ++i) {
                writer.writeValue(object[i]);
            }
            writer.endArray();
        }

        @Override
        public byte[] deserialize(ObjectReader reader, Context ctx) throws Exception {
            byte[] array = new byte[256];
            reader.beginArray();
            int i = 0;
            while (reader.hasNext()) {
                reader.next();
                Operations.expandArray(array, i, 2.0);
                array[i] = (byte)reader.valueAsInt();
                ++i;
            }
            reader.endArray();
            return Operations.truncateArray(array, i);
        }
    }

    @HandleClassMetadata
    public static final class ByteArrayConverter
    implements Converter<byte[]> {
        public static final ByteArrayConverter instance = new ByteArrayConverter();

        private ByteArrayConverter() {
        }

        @Override
        public void serialize(byte[] object, ObjectWriter writer, Context ctx) {
            writer.writeValue(object);
        }

        @Override
        public byte[] deserialize(ObjectReader reader, Context ctx) {
            return reader.valueAsByteArray();
        }
    }

    @HandleClassMetadata
    public static class ArrayConverter<E>
    implements Converter<Object> {
        private final Class<E> eClass;
        private final Converter<E> elementConverter;

        public ArrayConverter(Class<E> eClass, Converter<E> elementConverter) {
            this.eClass = eClass;
            this.elementConverter = elementConverter;
        }

        @Override
        public void serialize(Object array, ObjectWriter writer, Context ctx) throws Exception {
            writer.beginArray();
            int len = Array.getLength(array);
            for (int i = 0; i < len; ++i) {
                Object e = Array.get(array, i);
                this.elementConverter.serialize(e, writer, ctx);
            }
            writer.endArray();
        }

        @Override
        public Object deserialize(ObjectReader reader, Context ctx) throws Exception {
            reader.beginArray();
            int size = 10;
            Object array = Array.newInstance(this.eClass, size);
            int idx = 0;
            while (reader.hasNext()) {
                reader.next();
                if (idx >= size) {
                    size = size * 2 + 1;
                    array = this.expandArray(array, idx, size);
                }
                Array.set(array, idx++, this.elementConverter.deserialize(reader, ctx));
            }
            reader.endArray();
            if (idx < size) {
                array = this.expandArray(array, idx, idx);
            }
            return array;
        }

        private Object expandArray(Object array, int len, int size) {
            Object tmpArray = Array.newInstance(this.eClass, size);
            System.arraycopy(array, 0, tmpArray, 0, len);
            return tmpArray;
        }
    }

    public static final class CollectionConverterFactory
    implements Factory<Converter<Collection<?>>> {
        public static final CollectionConverterFactory instance = new CollectionConverterFactory();

        private CollectionConverterFactory() {
        }

        @Override
        public Converter<Collection<?>> create(Type forType, Genson genson) {
            Converter elementConverter = genson.provideConverter(TypeUtil.getCollectionType(forType));
            Class<?> parameterRawClass = TypeUtil.getRawClass(TypeUtil.getCollectionType(forType));
            Class<?> rawClass = TypeUtil.getRawClass(forType);
            if (EnumSet.class.isAssignableFrom(rawClass) && parameterRawClass.isEnum()) {
                return new EnumSetConverter(parameterRawClass, elementConverter);
            }
            if (LinkedHashSet.class.isAssignableFrom(rawClass)) {
                return new LinkedHashSetConverter(parameterRawClass, elementConverter);
            }
            if (TreeSet.class.isAssignableFrom(rawClass)) {
                return new TreeSetConverter(parameterRawClass, elementConverter);
            }
            if (Set.class.isAssignableFrom(rawClass)) {
                return new SetConverter(parameterRawClass, elementConverter);
            }
            if (LinkedList.class.isAssignableFrom(rawClass)) {
                return new LinkedListConverter(parameterRawClass, elementConverter);
            }
            if (ArrayDeque.class.isAssignableFrom(rawClass)) {
                return new ArrayDequeConverter(parameterRawClass, elementConverter);
            }
            if (PriorityQueue.class.isAssignableFrom(rawClass)) {
                return new PriorityQueueConverter(parameterRawClass, elementConverter);
            }
            return new CollectionConverter(parameterRawClass, elementConverter);
        }
    }

    public static final class SingleValueAsListFactory
    implements Factory<Converter<Collection<?>>> {
        public static final SingleValueAsListFactory instance = new SingleValueAsListFactory();
        Factory<Converter<Collection<?>>> defaultFactory = CollectionConverterFactory.instance;

        private SingleValueAsListFactory() {
        }

        @Override
        public Converter<Collection<?>> create(Type type, Genson genson) {
            final CollectionConverter defaultConverter = (CollectionConverter)this.defaultFactory.create(type, genson);
            return new Converter<Collection<?>>(){

                @Override
                public void serialize(Collection object, ObjectWriter writer, Context ctx) throws Exception {
                    defaultConverter.serialize(object, writer, ctx);
                }

                @Override
                public Collection deserialize(ObjectReader reader, Context ctx) throws Exception {
                    ValueType vt = reader.getValueType();
                    if (vt != ValueType.ARRAY && vt != ValueType.NULL) {
                        Object object = defaultConverter.getElementConverter().deserialize(reader, ctx);
                        Collection result = defaultConverter.create();
                        result.add(object);
                        return result;
                    }
                    return defaultConverter.deserialize(reader, ctx);
                }
            };
        }
    }

    @HandleClassMetadata
    public static class CollectionConverter<E>
    implements Converter<Collection<E>> {
        private final Class<E> eClass;
        private final Converter<E> elementConverter;

        public CollectionConverter(Class<E> eClass, Converter<E> elementConverter) {
            this.eClass = eClass;
            this.elementConverter = elementConverter;
        }

        @Override
        public Collection<E> deserialize(ObjectReader reader, Context ctx) throws Exception {
            reader.beginArray();
            Collection<E> col = this.create();
            while (reader.hasNext()) {
                reader.next();
                E e = this.elementConverter.deserialize(reader, ctx);
                col.add(e);
            }
            reader.endArray();
            return col;
        }

        @Override
        public void serialize(Collection<E> array, ObjectWriter writer, Context ctx) throws Exception {
            writer.beginArray();
            for (E e : array) {
                this.elementConverter.serialize(e, writer, ctx);
            }
            writer.endArray();
        }

        public Converter<E> getElementConverter() {
            return this.elementConverter;
        }

        protected Collection<E> create() {
            return new ArrayList();
        }
    }

    @HandleClassMetadata
    public static class EnumSetConverter<E>
    extends CollectionConverter<E> {
        private final Class<E> eClass;

        public EnumSetConverter(Class<E> eClass, Converter<E> elementConverter) {
            super(eClass, elementConverter);
            this.eClass = eClass;
        }

        @Override
        protected Collection<E> create() {
            return EnumSet.noneOf(this.eClass);
        }
    }

    @HandleClassMetadata
    public static class PriorityQueueConverter<E>
    extends CollectionConverter<E> {
        public PriorityQueueConverter(Class<E> eClass, Converter<E> elementConverter) {
            super(eClass, elementConverter);
        }

        @Override
        public void serialize(Collection<E> array, ObjectWriter writer, Context ctx) throws Exception {
            PriorityQueue queue = (PriorityQueue)array;
            if (queue.comparator() != null) {
                throw new UnsupportedOperationException("Serialization and deserialization of PriorityQueue with Comparator is not supported. You need to implement a custom Converter to handle it.");
            }
            super.serialize(array, writer, ctx);
        }

        @Override
        protected Collection<E> create() {
            return new PriorityQueue();
        }
    }

    @HandleClassMetadata
    public static class ArrayDequeConverter<E>
    extends CollectionConverter<E> {
        public ArrayDequeConverter(Class<E> eClass, Converter<E> elementConverter) {
            super(eClass, elementConverter);
        }

        @Override
        protected Collection<E> create() {
            return new ArrayDeque();
        }
    }

    @HandleClassMetadata
    public static class LinkedHashSetConverter<E>
    extends CollectionConverter<E> {
        public LinkedHashSetConverter(Class<E> eClass, Converter<E> elementConverter) {
            super(eClass, elementConverter);
        }

        @Override
        protected Collection<E> create() {
            return new LinkedHashSet();
        }
    }

    @HandleClassMetadata
    public static class TreeSetConverter<E>
    extends CollectionConverter<E> {
        public TreeSetConverter(Class<E> eClass, Converter<E> elementConverter) {
            super(eClass, elementConverter);
        }

        @Override
        public void serialize(Collection<E> array, ObjectWriter writer, Context ctx) throws Exception {
            TreeSet treeSet = (TreeSet)array;
            if (treeSet.comparator() != null) {
                throw new UnsupportedOperationException("Serialization and deserialization of TreeSet with Comparator is not supported. You need to implement a custom Converter to handle it.");
            }
            super.serialize(array, writer, ctx);
        }

        @Override
        protected Collection<E> create() {
            return new TreeSet();
        }
    }

    @HandleClassMetadata
    public static class LinkedListConverter<E>
    extends CollectionConverter<E> {
        public LinkedListConverter(Class<E> eClass, Converter<E> elementConverter) {
            super(eClass, elementConverter);
        }

        @Override
        protected Collection<E> create() {
            return new LinkedList();
        }
    }

    @HandleClassMetadata
    public static class SetConverter<E>
    extends CollectionConverter<E> {
        public SetConverter(Class<E> eClass, Converter<E> elementConverter) {
            super(eClass, elementConverter);
        }

        @Override
        protected Collection<E> create() {
            return new HashSet();
        }
    }
}

