/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.spring;

import com.owlike.genson.Context;
import com.owlike.genson.GenericType;
import com.owlike.genson.Genson;
import com.owlike.genson.ThreadLocalHolder;
import com.owlike.genson.annotation.WithBeanView;
import com.owlike.genson.stream.ObjectWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class GensonMessageConverter
extends AbstractHttpMessageConverter<Object> {
    private final Genson genson;
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    public GensonMessageConverter() {
        this(new Genson.Builder().setHtmlSafe(true).setSkipNull(true).setWithBeanViewConverter(true).create());
    }

    public GensonMessageConverter(Genson genson) {
        super(new MediaType("application", "json", DEFAULT_CHARSET));
        this.genson = genson;
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        MethodParameter mp = ThreadLocalHolder.get("__GENSON$method_param", MethodParameter.class);
        WithBeanView ann = null;
        Type type = clazz;
        if (mp != null) {
            ann = (WithBeanView)mp.getMethodAnnotation(WithBeanView.class);
            type = mp.getGenericParameterType();
        }
        GenericType<Object> genericType = GenericType.of(type);
        if (ann != null) {
            return this.genson.deserialize(genericType, this.genson.createReader(inputMessage.getBody()), new Context(this.genson, Arrays.asList(ann.views())));
        }
        return this.genson.deserialize(genericType, this.genson.createReader(inputMessage.getBody()), new Context(this.genson));
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    protected void writeInternal(Object t, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        WithBeanView ann;
        ObjectWriter writer = this.genson.createWriter(outputMessage.getBody());
        MethodParameter mp = ThreadLocalHolder.get("__GENSON$return_param", MethodParameter.class);
        WithBeanView withBeanView = ann = mp != null ? (WithBeanView)mp.getMethodAnnotation(WithBeanView.class) : null;
        if (ann != null) {
            this.genson.serialize(t, writer, ann.views());
        } else {
            this.genson.serialize(t, writer, new Class[0]);
        }
        writer.flush();
    }
}

