/*
 * Decompiled with CFR 0.152.
 */
package com.owen.focus;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import com.owen.focus.AbsFocusBorder;
import java.util.HashMap;
import java.util.Map;

class AnimatorHelper {
    private AbsFocusBorder mFocusBorder;
    private Map<Object, Animator> mCache = new HashMap<Object, Animator>();

    public AnimatorHelper(AbsFocusBorder border) {
        this.mFocusBorder = border;
    }

    private AnimatorSet getAnimatorSet(Object tag) {
        AnimatorSet anim = new AnimatorSet();
        return anim;
    }

    private ObjectAnimator getAnimatorsOfFloat(Object tag) {
        ObjectAnimator anim;
        if (!this.mCache.containsKey(tag)) {
            anim = ObjectAnimator.ofFloat((Object)this, (String)"dd", (float[])new float[]{1.0f});
            this.mCache.put(tag, (Animator)anim);
        } else {
            anim = (ObjectAnimator)this.mCache.get(tag);
        }
        return anim;
    }

    private ObjectAnimator getAnimatorsOfInt(Object tag) {
        ObjectAnimator anim;
        if (!this.mCache.containsKey(tag)) {
            anim = ObjectAnimator.ofInt((Object)this, (String)"dd", (int[])new int[]{1});
            this.mCache.put(tag, (Animator)anim);
        } else {
            anim = (ObjectAnimator)this.mCache.get(tag);
        }
        return anim;
    }

    public ObjectAnimator ofFloat(Object tag, Object target, String propertyName, float ... values) {
        ObjectAnimator anim = this.getAnimatorsOfFloat(tag);
        anim.setTarget(target);
        anim.setPropertyName(propertyName);
        anim.setFloatValues(values);
        return anim;
    }

    public ObjectAnimator ofInt(Object tag, Object target, String propertyName, int ... values) {
        ObjectAnimator anim = this.getAnimatorsOfInt(tag);
        anim.setTarget(target);
        anim.setPropertyName(propertyName);
        anim.setIntValues(values);
        return anim;
    }

    AnimatorSet getBorderAnimatorWithScale(View focusView, AbsFocusBorder.Options options, float x, float y, int width, int height, long duration, long startDelay) {
        AnimatorSet set = this.getAnimatorSet("BorderAnimator2");
        set.playTogether(new Animator[]{this.ofFloat("mTranslationXAnimator2", this.mFocusBorder, "translationX", x), this.ofFloat("mTranslationYAnimator2", this.mFocusBorder, "translationY", y), this.ofInt("mWidthAnimator2", this.mFocusBorder, "width", width), this.ofInt("mHeightAnimator2", this.mFocusBorder, "height", height), this.ofFloat("mScaleXAnimator2", focusView, "scaleX", options.scaleX), this.ofFloat("mScaleYAnimator2", focusView, "scaleY", options.scaleY)});
        set.setDuration(duration);
        set.setStartDelay(startDelay);
        return set;
    }

    AnimatorSet getBorderAnimator(float x, float y, int width, int height, long duration) {
        AnimatorSet set = this.getAnimatorSet("BorderAnimator");
        set.playTogether(new Animator[]{this.ofFloat("mTranslationXAnimator", this.mFocusBorder, "translationX", x), this.ofFloat("mTranslationYAnimator", this.mFocusBorder, "translationY", y), this.ofInt("mWidthAnimator", this.mFocusBorder, "width", width), this.ofInt("mHeightAnimator", this.mFocusBorder, "height", height)});
        set.setDuration(duration);
        return set;
    }

    Animator getShimmerAndTitleAnimator(AbsFocusBorder.Options options, boolean isReAnim) {
        AnimatorSet set = this.getAnimatorSet("ShimmerAndTitleAnimator");
        if (!TextUtils.isEmpty((CharSequence)this.mFocusBorder.mTitleView.getText())) {
            ObjectAnimator mTitleTranslationYAnimator = this.ofFloat("TitleTranslationYAnimator", this.mFocusBorder.mTitleView, "translationY", this.mFocusBorder.mTitleView.getTranslationY(), 0.0f).setDuration(this.mFocusBorder.mBuilder.mTitleAnimDuration / (long)(isReAnim ? 2 : 1));
            ObjectAnimator mTitleAlphaAnimator = this.ofFloat("TitleAlphaAnimator", this.mFocusBorder.mTitleView, "alpha", this.mFocusBorder.mTitleView.getAlpha(), 1.0f).setDuration(this.mFocusBorder.mBuilder.mTitleAnimDuration / (long)(isReAnim ? 2 : 1));
            set.playTogether(new Animator[]{mTitleTranslationYAnimator, mTitleAlphaAnimator});
        }
        if (this.mFocusBorder.mBuilder.mRunShimmerAnim) {
            set.playTogether(new Animator[]{this.getShimmerAnimator()});
        }
        if (!isReAnim) {
            if (this.mFocusBorder.mBuilder.mAnimMode == AbsFocusBorder.Mode.TOGETHER) {
                set.setStartDelay(300L);
            } else if (this.mFocusBorder.mBuilder.mAnimMode == AbsFocusBorder.Mode.NOLL) {
                set.setStartDelay(200L);
            } else {
                set.setStartDelay(100L);
            }
        }
        return set;
    }

    private ObjectAnimator getShimmerAnimator() {
        ObjectAnimator mShimmerAnimator = this.ofFloat("ShimmerAnimator", this.mFocusBorder, "shimmerTranslate", -1.0f, 1.0f);
        mShimmerAnimator.end();
        mShimmerAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        mShimmerAnimator.setDuration(this.mFocusBorder.mBuilder.mShimmerDuration);
        mShimmerAnimator.setStartDelay(400L);
        mShimmerAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                AnimatorHelper.this.mFocusBorder.setShimmerAnimating(true);
            }

            public void onAnimationEnd(Animator animation) {
                AnimatorHelper.this.mFocusBorder.setShimmerAnimating(false);
            }
        });
        return mShimmerAnimator;
    }

    ObjectAnimator getBreathingLampAnimator() {
        ObjectAnimator mBreathingLampAnimator = this.ofFloat("BreathingLampAnimator", this.mFocusBorder.getBorderView(), "alpha", 1.0f, 0.22f, 1.0f);
        mBreathingLampAnimator.setDuration(this.mFocusBorder.mBuilder.mBreathingDuration);
        mBreathingLampAnimator.setStartDelay(400L);
        mBreathingLampAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        mBreathingLampAnimator.setRepeatCount(-1);
        return mBreathingLampAnimator;
    }
}

