/*
 * Decompiled with CFR 0.152.
 */
package com.owen.focus;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.owen.focus.AbsFocusBorder;
import com.owen.focus.ColorFocusBorder;
import com.owen.focus.DrawableFocusBorder;

public interface FocusBorder {
    public void setVisible(boolean var1);

    public void setVisible(boolean var1, boolean var2);

    public boolean isVisible();

    public View getView();

    public void onFocus(@NonNull View var1, @Nullable Options var2);

    public void boundGlobalFocusListener(@NonNull OnFocusCallback var1);

    public void unBoundGlobalFocusListener();

    public static class OptionsFactory {
        public static Options get() {
            return OptionsFactory.get(1.0f, 1.0f);
        }

        public static Options get(float scaleX, float scaleY) {
            return OptionsFactory.get(scaleX, scaleY, null);
        }

        public static Options get(float scaleX, float scaleY, String title) {
            return AbsFocusBorder.Options.get(scaleX, scaleY, title);
        }

        public static Options get(float scaleX, float scaleY, float roundRadius) {
            return OptionsFactory.get(scaleX, scaleY, roundRadius, null);
        }

        public static Options get(float scaleX, float scaleY, float roundRadius, String title) {
            return ColorFocusBorder.Options.get(scaleX, scaleY, roundRadius, title);
        }
    }

    public static class Builder {
        public final ColorFocusBorder.Builder asColor() {
            return new ColorFocusBorder.Builder();
        }

        public final DrawableFocusBorder.Builder asDrawable() {
            return new DrawableFocusBorder.Builder();
        }
    }

    public static abstract class Options {
    }

    public static interface OnFocusCallback {
        @Nullable
        public Options onFocus(View var1, View var2);
    }
}

