/*
 * Decompiled with CFR 0.152.
 */
package com.owen.focus;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.owen.focus.FocusBorder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class AbsFocusBorder
extends FrameLayout
implements FocusBorder,
ViewTreeObserver.OnGlobalFocusChangeListener {
    private static final long DEFAULT_ANIM_DURATION_TIME = 300L;
    private static final long DEFAULT_TITLE_ANIM_DURATION_TIME = 400L;
    private static final long DEFAULT_SHIMMER_DURATION_TIME = 1000L;
    private static final long DEFAULT_BREATHING_DURATION_TIME = 3000L;
    protected Builder mBuilder;
    protected RectF mFrameRectF = new RectF();
    protected RectF mPaddingRectF = new RectF();
    protected RectF mTempRectF = new RectF();
    private LinearGradient mShimmerLinearGradient;
    private Matrix mShimmerGradientMatrix;
    private Paint mShimmerPaint;
    private float mShimmerTranslate = 0.0f;
    private boolean mShimmerAnimating = false;
    private boolean mReAnim = false;
    private ObjectAnimator mTranslationXAnimator;
    private ObjectAnimator mTranslationYAnimator;
    private ObjectAnimator mWidthAnimator;
    private ObjectAnimator mHeightAnimator;
    private ObjectAnimator mShimmerAnimator;
    private ObjectAnimator mTitleTranslationYAnimator;
    private ObjectAnimator mTitleAlphaAnimator;
    private ObjectAnimator mBreathingLampAnimator;
    private AnimatorSet mAnimatorSet;
    private RecyclerViewScrollListener mRecyclerViewScrollListener;
    private WeakReference<RecyclerView> mWeakRecyclerView;
    private WeakReference<View> mOldFocusView;
    private FocusBorder.OnFocusCallback mOnFocusCallback;
    private boolean mIsVisible = false;
    private float mScaleX;
    private float mScaleY;
    private TextView mTitleView;

    protected AbsFocusBorder(Context context, Builder builder) {
        super(context);
        this.setWillNotDraw(false);
        this.mBuilder = builder;
        this.setLayerType(1, null);
        this.setVisibility(0);
        this.mShimmerPaint = new Paint();
        this.mShimmerGradientMatrix = new Matrix();
        this.initTitleView();
    }

    private void initTitleView() {
        if (null == this.mTitleView) {
            this.mTitleView = new TextView(this.getContext());
            this.mTitleView.setSingleLine();
            this.mTitleView.setEllipsize(TextUtils.TruncateAt.MARQUEE);
            this.mTitleView.setSelected(true);
            this.mTitleView.setLayerType(1, null);
            this.mTitleView.setTextSize(this.mBuilder.mTitleTextSize);
            this.mTitleView.setTextColor(this.mBuilder.mTitleTextColor);
            this.mTitleView.setBackgroundResource(this.mBuilder.mTitleBackgroundRes);
            this.mTitleView.setText((CharSequence)" ");
            if (null != this.mBuilder.mTitlePaddingRect) {
                this.mTitleView.setPadding(this.mBuilder.mTitlePaddingRect.left, this.mBuilder.mTitlePaddingRect.top, this.mBuilder.mTitlePaddingRect.right, this.mBuilder.mTitlePaddingRect.bottom);
            }
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
            params.gravity = 81;
            if (null != this.mBuilder.mTitleMarginRect) {
                params.bottomMargin += this.mBuilder.mTitleMarginRect.bottom;
            }
            this.addView((View)this.mTitleView, (ViewGroup.LayoutParams)params);
        }
    }

    public boolean isInEditMode() {
        return true;
    }

    protected void onDrawShimmer(Canvas canvas) {
        if (this.mShimmerAnimating) {
            canvas.save();
            this.mTempRectF.set(this.mFrameRectF);
            this.mTempRectF.intersect(this.mBuilder.mPaddingOffsetRectF);
            float shimmerTranslateX = this.mTempRectF.width() * this.mShimmerTranslate;
            float shimmerTranslateY = this.mTempRectF.height() * this.mShimmerTranslate;
            this.mShimmerGradientMatrix.setTranslate(shimmerTranslateX, shimmerTranslateY);
            this.mShimmerLinearGradient.setLocalMatrix(this.mShimmerGradientMatrix);
            canvas.drawRoundRect(this.mTempRectF, this.getRoundRadius(), this.getRoundRadius(), this.mShimmerPaint);
            canvas.restore();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw || h != oldh) {
            this.mFrameRectF.set(this.mPaddingRectF.left, this.mPaddingRectF.top, (float)w - this.mPaddingRectF.right, (float)h - this.mPaddingRectF.bottom);
            if (null != this.mTitleView) {
                int maxWidth = (int)(this.mFrameRectF.width() - this.mBuilder.mPaddingOffsetRectF.left - this.mBuilder.mPaddingOffsetRectF.right);
                this.mTitleView.setMaxWidth(maxWidth - (null != this.mBuilder.mTitleMarginRect ? this.mBuilder.mTitleMarginRect.left + this.mBuilder.mTitleMarginRect.right : 0));
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.onDrawShimmer(canvas);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mBuilder.mTitleMarginBottomAutoAlignBorder) {
            ((FrameLayout.LayoutParams)this.mTitleView.getLayoutParams()).bottomMargin += (int)(this.mPaddingRectF.bottom + this.mBuilder.mPaddingOffsetRectF.bottom);
        }
    }

    protected void onDetachedFromWindow() {
        this.unBoundGlobalFocusListener();
        super.onDetachedFromWindow();
    }

    private void setShimmerAnimating(boolean shimmerAnimating) {
        this.mShimmerAnimating = shimmerAnimating;
        if (this.mShimmerAnimating) {
            this.mTempRectF.set(this.mFrameRectF);
            this.mTempRectF.left += this.mBuilder.mPaddingOffsetRectF.left;
            this.mTempRectF.top += this.mBuilder.mPaddingOffsetRectF.top;
            this.mTempRectF.right -= this.mBuilder.mPaddingOffsetRectF.right;
            this.mTempRectF.bottom -= this.mBuilder.mPaddingOffsetRectF.bottom;
            this.mShimmerLinearGradient = new LinearGradient(0.0f, 0.0f, this.mTempRectF.width(), this.mTempRectF.height(), new int[]{0xFFFFFF, 0x1AFFFFFF, this.mBuilder.mShimmerColor, 0x1AFFFFFF, 0xFFFFFF}, new float[]{0.0f, 0.2f, 0.5f, 0.8f, 1.0f}, Shader.TileMode.CLAMP);
            this.mShimmerPaint.setShader((Shader)this.mShimmerLinearGradient);
        }
    }

    protected void setShimmerTranslate(float shimmerTranslate) {
        if (this.mBuilder.mRunShimmerAnim && this.mShimmerTranslate != shimmerTranslate) {
            this.mShimmerTranslate = shimmerTranslate;
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    protected float getShimmerTranslate() {
        return this.mShimmerTranslate;
    }

    protected void setWidth(int width) {
        if (this.getLayoutParams().width != width) {
            this.getLayoutParams().width = width;
            this.requestLayout();
        }
    }

    protected void setHeight(int height) {
        if (this.getLayoutParams().height != height) {
            this.getLayoutParams().height = height;
            this.requestLayout();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.mIsVisible != visible) {
            this.mIsVisible = visible;
            if (null != this.mAnimatorSet) {
                this.mAnimatorSet.cancel();
            }
            this.animate().alpha(visible ? 1.0f : 0.0f).setDuration(this.mBuilder.mAnimDuration).start();
            if (!visible && null != this.mOldFocusView && null != this.mOldFocusView.get()) {
                this.runFocusScaleAnimation((View)this.mOldFocusView.get(), 1.0f, 1.0f);
                this.mOldFocusView.clear();
                this.mOldFocusView = null;
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.mIsVisible;
    }

    private void registerScrollListener(RecyclerView recyclerView) {
        if (null != this.mWeakRecyclerView && this.mWeakRecyclerView.get() == recyclerView) {
            return;
        }
        if (null == this.mRecyclerViewScrollListener) {
            this.mRecyclerViewScrollListener = new RecyclerViewScrollListener(this);
        }
        if (null != this.mWeakRecyclerView && null != this.mWeakRecyclerView.get()) {
            ((RecyclerView)this.mWeakRecyclerView.get()).removeOnScrollListener((RecyclerView.OnScrollListener)this.mRecyclerViewScrollListener);
            this.mWeakRecyclerView.clear();
        }
        recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this.mRecyclerViewScrollListener);
        recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.mRecyclerViewScrollListener);
        this.mWeakRecyclerView = new WeakReference<RecyclerView>(recyclerView);
    }

    protected Rect findLocationWithView(View view) {
        return this.findOffsetDescendantRectToMyCoords(view);
    }

    protected Rect findOffsetDescendantRectToMyCoords(View descendant) {
        ViewGroup root = (ViewGroup)this.getParent();
        Rect rect = new Rect();
        this.mReAnim = false;
        if (descendant == root) {
            return rect;
        }
        View srcDescendant = descendant;
        ViewParent theParent = descendant.getParent();
        while (theParent instanceof View && theParent != root) {
            rect.offset(descendant.getLeft() - descendant.getScrollX(), descendant.getTop() - descendant.getScrollY());
            if (theParent instanceof RecyclerView) {
                RecyclerView rv = (RecyclerView)theParent;
                this.registerScrollListener(rv);
                Object tag = rv.getTag();
                if (tag instanceof Point) {
                    Point point = (Point)tag;
                    rect.offset(-point.x, -point.y);
                }
                if (null == tag && rv.getScrollState() != 0 && (this.mRecyclerViewScrollListener.mScrolledX != 0 || this.mRecyclerViewScrollListener.mScrolledY != 0)) {
                    this.mReAnim = true;
                }
            }
            descendant = (View)theParent;
            theParent = descendant.getParent();
        }
        if (theParent == root) {
            rect.offset(descendant.getLeft() - descendant.getScrollX(), descendant.getTop() - descendant.getScrollY());
        }
        rect.right = rect.left + srcDescendant.getMeasuredWidth();
        rect.bottom = rect.top + srcDescendant.getMeasuredHeight();
        return rect;
    }

    public View getOldFocusView() {
        return null != this.mOldFocusView ? (View)this.mOldFocusView.get() : null;
    }

    @Override
    public void onFocus(@NonNull View focusView, @Nullable FocusBorder.Options options) {
        View oldFocus = this.getOldFocusView();
        if (null != oldFocus) {
            this.runFocusScaleAnimation(oldFocus, 1.0f, 1.0f);
            this.mOldFocusView.clear();
        }
        if (options instanceof Options) {
            this.restoreFocusBorder(oldFocus, focusView, (Options)options);
            this.setVisible(true);
            this.runFocusAnimation(focusView, (Options)options);
            this.mOldFocusView = new WeakReference<View>(focusView);
        }
    }

    private void restoreFocusBorder(@Nullable View oldFocus, @NonNull View newFocus, @Nullable Options options) {
        if (null == oldFocus) {
            float paddingWidth = this.mPaddingRectF.left + this.mPaddingRectF.right + this.mBuilder.mPaddingOffsetRectF.left + this.mBuilder.mPaddingOffsetRectF.right;
            float paddingHeight = this.mPaddingRectF.top + this.mPaddingRectF.bottom + this.mBuilder.mPaddingOffsetRectF.top + this.mBuilder.mPaddingOffsetRectF.bottom;
            Rect toRect = this.findLocationWithView(newFocus);
            toRect.inset((int)(-paddingWidth / 2.0f), (int)(-paddingHeight / 2.0f));
            this.setWidth(toRect.width());
            this.setHeight(toRect.height());
            this.setTranslationX(toRect.left);
            this.setTranslationY(toRect.top);
        }
    }

    @Override
    public void boundGlobalFocusListener(@NonNull FocusBorder.OnFocusCallback callback) {
        this.mOnFocusCallback = callback;
        this.getViewTreeObserver().addOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)this);
    }

    @Override
    public void unBoundGlobalFocusListener() {
        if (null != this.mOnFocusCallback) {
            this.mOnFocusCallback = null;
            this.getViewTreeObserver().removeOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)this);
        }
    }

    public void onGlobalFocusChanged(View oldFocus, View newFocus) {
        Options options;
        Options options2 = options = null != this.mOnFocusCallback ? (Options)this.mOnFocusCallback.onFocus(oldFocus, newFocus) : null;
        if (null != options) {
            this.onFocus(newFocus, options);
        }
    }

    private void runFocusAnimation(View focusView, Options options) {
        this.mScaleX = options.scaleX;
        this.mScaleY = options.scaleY;
        this.runFocusScaleAnimation(focusView, this.mScaleX, this.mScaleY);
        this.runBorderAnimation(focusView, options);
    }

    protected void runBorderAnimation(View focusView, Options options) {
        if (null == focusView) {
            return;
        }
        if (null != this.mAnimatorSet) {
            this.mAnimatorSet.cancel();
        }
        this.getBorderView().setAlpha(1.0f);
        this.mTitleView.setAlpha(0.0f);
        this.mTitleView.setText((CharSequence)options.title);
        this.mTitleView.setTranslationY((float)this.mTitleView.getHeight());
        this.createBorderAnimation(focusView, options);
        this.mAnimatorSet.start();
    }

    protected void runFocusScaleAnimation(@Nullable View oldOrNewFocusView, float scaleX, float scaleY) {
        if (null == oldOrNewFocusView) {
            return;
        }
        oldOrNewFocusView.animate().scaleX(scaleX).scaleY(scaleY).setDuration(this.mBuilder.mAnimDuration).start();
    }

    protected void createBorderAnimation(View focusView, Options options) {
        float paddingWidth = this.mPaddingRectF.left + this.mPaddingRectF.right + this.mBuilder.mPaddingOffsetRectF.left + this.mBuilder.mPaddingOffsetRectF.right;
        float paddingHeight = this.mPaddingRectF.top + this.mPaddingRectF.bottom + this.mBuilder.mPaddingOffsetRectF.top + this.mBuilder.mPaddingOffsetRectF.bottom;
        int offsetWidth = (int)((float)focusView.getMeasuredWidth() * (options.scaleX - 1.0f) + paddingWidth);
        int offsetHeight = (int)((float)focusView.getMeasuredHeight() * (options.scaleY - 1.0f) + paddingHeight);
        Rect fromRect = this.findLocationWithView((View)this);
        Rect toRect = this.findLocationWithView(focusView);
        toRect.inset(-offsetWidth / 2, -offsetHeight / 2);
        int newWidth = toRect.width();
        int newHeight = toRect.height();
        int newX = toRect.left - fromRect.left;
        int newY = toRect.top - fromRect.top;
        ArrayList<Object> together = new ArrayList<Object>();
        List<Animator> appendTogether = this.getTogetherAnimators(newX, newY, newWidth, newHeight, options);
        together.add(this.getTranslationXAnimator(newX));
        together.add(this.getTranslationYAnimator(newY));
        together.add(this.getWidthAnimator(newWidth));
        together.add(this.getHeightAnimator(newHeight));
        if (null != appendTogether && !appendTogether.isEmpty()) {
            together.addAll(appendTogether);
        }
        ArrayList<Object> sequentially = new ArrayList<Object>();
        List<Animator> appendSequentially = this.getSequentiallyAnimators(newX, newY, newWidth, newHeight, options);
        sequentially.add(this.getShimmerAndTitleAnimator(options));
        if (null != appendSequentially && !appendSequentially.isEmpty()) {
            sequentially.addAll(appendSequentially);
        }
        if (this.mBuilder.mRunBreathingAnim) {
            sequentially.add(this.getBreathingLampAnimator());
        }
        this.mAnimatorSet = new AnimatorSet();
        this.mAnimatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator(1.0f));
        this.mAnimatorSet.playTogether(together);
        this.mAnimatorSet.playSequentially(sequentially);
    }

    private Animator getShimmerAndTitleAnimator(Options options) {
        AnimatorSet set = new AnimatorSet();
        if (!TextUtils.isEmpty((CharSequence)this.mTitleView.getText())) {
            if (null == this.mTitleTranslationYAnimator) {
                this.mTitleTranslationYAnimator = ObjectAnimator.ofFloat((Object)this.mTitleView, (String)"translationY", (float[])new float[]{this.mTitleView.getHeight(), 0.0f}).setDuration(this.mBuilder.mTitleAnimDuration);
            } else {
                this.mTitleTranslationYAnimator.setFloatValues(new float[]{this.mTitleView.getHeight(), 0.0f});
            }
            if (null == this.mTitleAlphaAnimator) {
                this.mTitleAlphaAnimator = ObjectAnimator.ofFloat((Object)this.mTitleView, (String)"alpha", (float[])new float[]{0.0f, 1.0f}).setDuration(this.mBuilder.mTitleAnimDuration);
            }
            set.playTogether(new Animator[]{this.mTitleTranslationYAnimator, this.mTitleAlphaAnimator});
        }
        if (this.mBuilder.mRunShimmerAnim) {
            set.playTogether(new Animator[]{this.getShimmerAnimator()});
        }
        set.setStartDelay(400L);
        return set;
    }

    private ObjectAnimator getTranslationXAnimator(float x) {
        if (null == this.mTranslationXAnimator) {
            this.mTranslationXAnimator = ObjectAnimator.ofFloat((Object)this, (String)"translationX", (float[])new float[]{x}).setDuration(this.mBuilder.mAnimDuration);
        } else {
            this.mTranslationXAnimator.setFloatValues(new float[]{x});
        }
        return this.mTranslationXAnimator;
    }

    private ObjectAnimator getTranslationYAnimator(float y) {
        if (null == this.mTranslationYAnimator) {
            this.mTranslationYAnimator = ObjectAnimator.ofFloat((Object)this, (String)"translationY", (float[])new float[]{y}).setDuration(this.mBuilder.mAnimDuration);
        } else {
            this.mTranslationYAnimator.setFloatValues(new float[]{y});
        }
        return this.mTranslationYAnimator;
    }

    private ObjectAnimator getHeightAnimator(int height) {
        if (null == this.mHeightAnimator) {
            this.mHeightAnimator = ObjectAnimator.ofInt((Object)this, (String)"height", (int[])new int[]{this.getMeasuredHeight(), height}).setDuration(this.mBuilder.mAnimDuration);
        } else {
            this.mHeightAnimator.setIntValues(new int[]{this.getMeasuredHeight(), height});
        }
        return this.mHeightAnimator;
    }

    private ObjectAnimator getWidthAnimator(int width) {
        if (null == this.mWidthAnimator) {
            this.mWidthAnimator = ObjectAnimator.ofInt((Object)this, (String)"width", (int[])new int[]{this.getMeasuredWidth(), width}).setDuration(this.mBuilder.mAnimDuration);
        } else {
            this.mWidthAnimator.setIntValues(new int[]{this.getMeasuredWidth(), width});
        }
        return this.mWidthAnimator;
    }

    private ObjectAnimator getShimmerAnimator() {
        if (null == this.mShimmerAnimator) {
            this.mShimmerAnimator = ObjectAnimator.ofFloat((Object)this, (String)"shimmerTranslate", (float[])new float[]{-1.0f, 1.0f});
            this.mShimmerAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.mShimmerAnimator.setDuration(this.mBuilder.mShimmerDuration);
            this.mShimmerAnimator.setStartDelay(400L);
            this.mShimmerAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    AbsFocusBorder.this.setShimmerAnimating(true);
                }

                public void onAnimationEnd(Animator animation) {
                    AbsFocusBorder.this.setShimmerAnimating(false);
                }
            });
        }
        return this.mShimmerAnimator;
    }

    private ObjectAnimator getBreathingLampAnimator() {
        if (null == this.mBreathingLampAnimator) {
            this.mBreathingLampAnimator = ObjectAnimator.ofFloat((Object)this.getBorderView(), (String)"alpha", (float[])new float[]{1.0f, 0.22f, 1.0f});
            this.mBreathingLampAnimator.setDuration(this.mBuilder.mBreathingDuration);
            this.mBreathingLampAnimator.setStartDelay(400L);
            this.mBreathingLampAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
            this.mBreathingLampAnimator.setRepeatCount(-1);
        }
        return this.mBreathingLampAnimator;
    }

    @NonNull
    public abstract View getBorderView();

    abstract float getRoundRadius();

    abstract List<Animator> getTogetherAnimators(float var1, float var2, int var3, int var4, Options var5);

    abstract List<Animator> getSequentiallyAnimators(float var1, float var2, int var3, int var4, Options var5);

    public static abstract class Builder {
        protected int mShimmerColor = 0x66FFFFFF;
        protected boolean mRunShimmerAnim = true;
        protected boolean mRunBreathingAnim = true;
        protected long mAnimDuration = 300L;
        protected long mShimmerDuration = 1000L;
        protected long mBreathingDuration = 3000L;
        protected RectF mPaddingOffsetRectF = new RectF();
        protected Rect mTitlePaddingRect;
        protected Rect mTitleMarginRect;
        protected boolean mTitleMarginBottomAutoAlignBorder;
        protected float mTitleTextSize = 20.0f;
        protected int mTitleTextColor = 0x66FFFFFF;
        protected int mTitleBackgroundRes;
        protected long mTitleAnimDuration = 400L;

        public Builder titlePadding(int left, int top, int right, int bottom) {
            this.mTitlePaddingRect = new Rect(left, top, right, bottom);
            return this;
        }

        public Builder titlePadding(int padding) {
            return this.titlePadding(padding, padding, padding, padding);
        }

        public Builder titleMargin(int left, int top, int right, int bottom) {
            this.mTitleMarginRect = new Rect(left, top, right, bottom);
            return this;
        }

        public Builder titleMargin(int margin) {
            return this.titleMargin(margin, margin, margin, margin);
        }

        public Builder titleMarginBottomAutoAlignBorder() {
            this.mTitleMarginBottomAutoAlignBorder = true;
            return this;
        }

        public Builder titleTextSize(float size) {
            this.mTitleTextSize = size;
            return this;
        }

        public Builder titleTextColor(@ColorInt int color) {
            this.mTitleTextColor = color;
            return this;
        }

        public Builder titleTextColor(@ColorRes int colorRes, Context context) {
            if (Build.VERSION.SDK_INT >= 23) {
                this.shimmerColor(context.getColor(colorRes));
            } else {
                this.titleTextColor(context.getResources().getColor(colorRes));
            }
            return this;
        }

        public Builder titleBackgroundRes(@DrawableRes int drawableRes) {
            this.mTitleBackgroundRes = drawableRes;
            return this;
        }

        public Builder titleAnimDuration(long duration) {
            this.mTitleAnimDuration = duration;
            return this;
        }

        public Builder breathingDuration(long duration) {
            this.mBreathingDuration = duration;
            return this;
        }

        public Builder noBreathing() {
            this.mRunBreathingAnim = false;
            return this;
        }

        public Builder shimmerColor(@ColorInt int color) {
            this.mShimmerColor = color;
            return this;
        }

        public Builder shimmerColorRes(@ColorRes int colorId, Context context) {
            if (Build.VERSION.SDK_INT >= 23) {
                this.shimmerColor(context.getColor(colorId));
            } else {
                this.shimmerColor(context.getResources().getColor(colorId));
            }
            return this;
        }

        public Builder shimmerDuration(long duration) {
            this.mShimmerDuration = duration;
            return this;
        }

        public Builder noShimmer() {
            this.mRunShimmerAnim = false;
            return this;
        }

        public Builder animDuration(long duration) {
            this.mAnimDuration = duration;
            return this;
        }

        public Builder padding(float padding) {
            return this.padding(padding, padding, padding, padding);
        }

        public Builder padding(float left, float top, float right, float bottom) {
            this.mPaddingOffsetRectF.left = left;
            this.mPaddingOffsetRectF.top = top;
            this.mPaddingOffsetRectF.right = right;
            this.mPaddingOffsetRectF.bottom = bottom;
            return this;
        }

        public FocusBorder build(Fragment fragment) {
            if (null != fragment.getActivity()) {
                return this.build(fragment.getActivity());
            }
            return this.build((ViewGroup)fragment.getView());
        }

        public FocusBorder build(android.support.v4.app.Fragment fragment) {
            if (null != fragment.getActivity()) {
                return this.build((Activity)fragment.getActivity());
            }
            return this.build((ViewGroup)fragment.getView());
        }

        public abstract FocusBorder build(Activity var1);

        public abstract FocusBorder build(ViewGroup var1);
    }

    public static class Options
    extends FocusBorder.Options {
        protected float scaleX = 1.0f;
        protected float scaleY = 1.0f;
        protected String title;

        Options() {
        }

        public static Options get(float scaleX, float scaleY) {
            return Options.get(scaleX, scaleY, null);
        }

        public static Options get(float scaleX, float scaleY, String title) {
            OptionsHolder.INSTANCE.scaleX = scaleX;
            OptionsHolder.INSTANCE.scaleY = scaleY;
            OptionsHolder.INSTANCE.title = title;
            return OptionsHolder.INSTANCE;
        }

        public boolean isScale() {
            return this.scaleX != 1.0f || this.scaleY != 1.0f;
        }

        private static class OptionsHolder {
            private static final Options INSTANCE = new Options();

            private OptionsHolder() {
            }
        }
    }

    private static class RecyclerViewScrollListener
    extends RecyclerView.OnScrollListener {
        private WeakReference<AbsFocusBorder> mFocusBorder;
        private int mScrolledX = 0;
        private int mScrolledY = 0;

        public RecyclerViewScrollListener(AbsFocusBorder border) {
            this.mFocusBorder = new WeakReference<AbsFocusBorder>(border);
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            this.mScrolledX = Math.abs(dx) == 1 ? 0 : dx;
            this.mScrolledY = Math.abs(dy) == 1 ? 0 : dy;
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            if (newState == 0) {
                AbsFocusBorder border = (AbsFocusBorder)this.mFocusBorder.get();
                View focused = recyclerView.getFocusedChild();
                if (null != border && null != focused && (border.mReAnim || this.mScrolledX != 0 || this.mScrolledY != 0)) {
                    border.runBorderAnimation(focused, Options.get(border.mScaleX, border.mScaleY));
                }
                this.mScrolledY = 0;
                this.mScrolledX = 0;
            }
        }
    }
}

