/*
 * Decompiled with CFR 0.152.
 */
package com.owen.focus;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.v4.view.ViewCompat;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import com.owen.focus.AbsFocusBorder;
import com.owen.focus.FocusBorder;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class ColorFocusBorder
extends AbsFocusBorder {
    private Paint mShadowPaint;
    private Paint mBorderPaint;
    private int mShadowColor;
    private float mShadowWidth;
    private int mBorderColor;
    private float mBorderWidth;
    private float mRoundRadius = 0.0f;
    private ObjectAnimator mRoundRadiusAnimator;

    private ColorFocusBorder(Context context, RectF paddingOffsetRectF, Builder builder) {
        super(context, paddingOffsetRectF, builder);
        this.mShadowColor = builder.mShadowColor;
        this.mShadowWidth = builder.mShadowWidth;
        this.mBorderColor = builder.mBorderColor;
        this.mBorderWidth = builder.mBorderWidth;
        float padding = this.mShadowWidth + this.mBorderWidth;
        this.mPaddingRectF.set(padding, padding, padding, padding);
        this.initPaint();
    }

    private void initPaint() {
        this.mShadowPaint = new Paint();
        this.mShadowPaint.setColor(this.mShadowColor);
        this.mShadowPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(this.mShadowWidth, BlurMaskFilter.Blur.OUTER));
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setColor(this.mBorderColor);
        this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(0.5f, BlurMaskFilter.Blur.NORMAL));
    }

    protected void setRoundRadius(float roundRadius) {
        if (this.mRoundRadius != roundRadius) {
            this.mRoundRadius = roundRadius;
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    @Override
    public float getRoundRadius() {
        return this.mRoundRadius;
    }

    @Override
    List<Animator> getTogetherAnimators(float newX, float newY, int newWidth, int newHeight, AbsFocusBorder.Options options) {
        if (options instanceof Options) {
            Options rawOptions = (Options)options;
            ArrayList<Animator> animators = new ArrayList<Animator>();
            animators.add((Animator)this.getRoundRadiusAnimator(rawOptions.roundRadius));
            return animators;
        }
        return null;
    }

    @Override
    List<Animator> getSequentiallyAnimators(float newX, float newY, int newWidth, int newHeight, AbsFocusBorder.Options options) {
        return null;
    }

    private ObjectAnimator getRoundRadiusAnimator(float roundRadius) {
        if (null == this.mRoundRadiusAnimator) {
            this.mRoundRadiusAnimator = ObjectAnimator.ofFloat((Object)this, (String)"roundRadius", (float[])new float[]{this.getRoundRadius(), roundRadius});
        } else {
            this.mRoundRadiusAnimator.setFloatValues(new float[]{this.getRoundRadius(), roundRadius});
        }
        return this.mRoundRadiusAnimator;
    }

    private void onDrawShadow(Canvas canvas) {
        if (this.mShadowWidth > 0.0f) {
            canvas.save();
            if (this.mRoundRadius > 0.0f) {
                canvas.clipRect(0, 0, this.getWidth(), this.getHeight());
                this.mTempRectF.set(this.mFrameRectF);
                this.mTempRectF.inset(this.mRoundRadius / 2.0f, this.mRoundRadius / 2.0f);
                canvas.clipRect(this.mTempRectF, Region.Op.DIFFERENCE);
            }
            canvas.drawRoundRect(this.mFrameRectF, this.mRoundRadius, this.mRoundRadius, this.mShadowPaint);
            canvas.restore();
        }
    }

    private void onDrawBorder(Canvas canvas) {
        if (this.mBorderWidth > 0.0f) {
            canvas.save();
            this.mTempRectF.set(this.mFrameRectF);
            canvas.drawRoundRect(this.mTempRectF, this.mRoundRadius, this.mRoundRadius, this.mBorderPaint);
            canvas.restore();
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        this.onDrawShadow(canvas);
        this.onDrawBorder(canvas);
        super.onDraw(canvas);
    }

    public static final class Builder
    extends AbsFocusBorder.Builder {
        private int mShadowColor = 0;
        private int mShadowColorRes = 0;
        private float mShadowWidth = 0.0f;
        private int mShadowWidthUnit = -1;
        private float mShadowWidthSrc = 0.0f;
        private int mBorderColor = 0;
        private int mBorderColorRes = 0;
        private float mBorderWidth = 0.0f;
        private int mBorderWidthUnit = -1;
        private float mBorderWidthSrc = 0.0f;

        public Builder shadowColor(@ColorInt int color) {
            this.mShadowColor = color;
            return this;
        }

        public Builder shadowColorRes(@ColorRes int colorRes) {
            this.mShadowColorRes = colorRes;
            return this;
        }

        public Builder shadowWidth(float pxWidth) {
            this.mShadowWidth = pxWidth;
            return this;
        }

        public Builder shadowWidth(int unit, float width) {
            this.mShadowWidthUnit = unit;
            this.mShadowWidthSrc = width;
            return this;
        }

        public Builder borderColor(@ColorInt int color) {
            this.mBorderColor = color;
            return this;
        }

        public Builder borderColorRes(@ColorRes int colorRes) {
            this.mBorderColorRes = colorRes;
            return this;
        }

        public Builder borderWidth(float pxWidth) {
            this.mBorderWidth = pxWidth;
            return this;
        }

        public Builder borderWidth(int unit, float width) {
            this.mBorderWidthUnit = unit;
            this.mBorderWidthSrc = width;
            return this;
        }

        @Override
        public FocusBorder build(Activity activity) {
            if (null == activity) {
                throw new NullPointerException("The activity cannot be null");
            }
            ViewGroup parent = (ViewGroup)activity.findViewById(0x1020002);
            return this.build(parent);
        }

        @Override
        public FocusBorder build(ViewGroup parent) {
            if (null == parent) {
                throw new NullPointerException("The FocusBorder parent cannot be null");
            }
            if (this.mBorderWidthUnit >= 0 && this.mBorderWidthSrc > 0.0f) {
                this.mBorderWidth = TypedValue.applyDimension((int)this.mBorderWidthUnit, (float)this.mBorderWidthSrc, (DisplayMetrics)parent.getResources().getDisplayMetrics());
            }
            if (this.mShadowWidthUnit >= 0 && this.mShadowWidthSrc > 0.0f) {
                this.mShadowWidth = TypedValue.applyDimension((int)this.mShadowWidthUnit, (float)this.mShadowWidthSrc, (DisplayMetrics)parent.getResources().getDisplayMetrics());
            }
            if (this.mBorderColorRes > 0) {
                this.mBorderColor = Build.VERSION.SDK_INT >= 23 ? parent.getResources().getColor(this.mBorderColorRes, parent.getContext().getTheme()) : parent.getResources().getColor(this.mBorderColorRes);
            }
            if (this.mShadowColorRes > 0) {
                this.mShadowColor = Build.VERSION.SDK_INT >= 23 ? parent.getResources().getColor(this.mShadowColorRes, parent.getContext().getTheme()) : parent.getResources().getColor(this.mShadowColorRes);
            }
            ColorFocusBorder borderView = new ColorFocusBorder(parent.getContext(), this.mPaddingOffsetRectF, this);
            ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(1, 1);
            parent.addView((View)borderView, lp);
            return borderView;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Unit {
    }

    public static class Options
    extends AbsFocusBorder.Options {
        private float roundRadius = 0.0f;

        Options() {
        }

        public static Options get(float scaleX, float scaleY, float roundRadius) {
            OptionsHolder.INSTANCE.scaleX = scaleX;
            OptionsHolder.INSTANCE.scaleY = scaleY;
            OptionsHolder.INSTANCE.roundRadius = roundRadius;
            return OptionsHolder.INSTANCE;
        }

        private static class OptionsHolder {
            private static final Options INSTANCE = new Options();

            private OptionsHolder() {
            }
        }
    }
}

