/*
 * Decompiled with CFR 0.152.
 */
package com.outbrain.swinfra.config.provider.impl;

import com.outbrain.swinfra.config.provider.ConfigurationProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathPropertiesFileBasedConfigurationProvider
implements ConfigurationProvider {
    private static final Logger log = LoggerFactory.getLogger(ClasspathPropertiesFileBasedConfigurationProvider.class);
    private final Properties properties = new Properties();

    public ClasspathPropertiesFileBasedConfigurationProvider(String resourceFilePath) throws IOException {
        if (null == resourceFilePath) {
            throw new IllegalArgumentException("Configuration file path must be provided");
        }
        log.info("loading resource {}", (Object)resourceFilePath);
        InputStream configFileStream = this.getClass().getClassLoader().getResourceAsStream(resourceFilePath);
        if (null == configFileStream) {
            throw new IllegalArgumentException("Configuration file doesn't exist - " + resourceFilePath);
        }
        this.properties.load(configFileStream);
    }

    @Override
    public Map<Object, Object> getConfiguration() {
        return Collections.unmodifiableMap(this.properties);
    }
}

