/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.strategy;

import android.media.MediaFormat;
import androidx.annotation.NonNull;
import com.otaliastudios.transcoder.common.TrackStatus;
import com.otaliastudios.transcoder.internal.utils.BitRates;
import com.otaliastudios.transcoder.strategy.TrackStrategy;
import java.util.List;

public class DefaultAudioStrategy
implements TrackStrategy {
    public static final int CHANNELS_AS_INPUT = -1;
    public static final int SAMPLE_RATE_AS_INPUT = -1;
    public static final long BITRATE_UNKNOWN = Long.MIN_VALUE;
    private Options options;

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public DefaultAudioStrategy(@NonNull Options options) {
        this.options = options;
    }

    @Override
    @NonNull
    public TrackStatus createOutputFormat(@NonNull List<MediaFormat> inputFormats, @NonNull MediaFormat outputFormat) {
        int outputSampleRate;
        int outputChannels = this.options.targetChannels == -1 ? this.getInputChannelCount(inputFormats) : this.options.targetChannels;
        int n = outputSampleRate = this.options.targetSampleRate == -1 ? this.getInputSampleRate(inputFormats) : this.options.targetSampleRate;
        long outputBitRate = inputFormats.size() == 1 && this.options.targetChannels == -1 && this.options.targetSampleRate == -1 && this.options.targetBitRate == Long.MIN_VALUE && inputFormats.get(0).containsKey("bitrate") ? (long)inputFormats.get(0).getInteger("bitrate") : (this.options.targetBitRate == Long.MIN_VALUE ? BitRates.estimateAudioBitRate(outputChannels, outputSampleRate) : this.options.targetBitRate);
        outputFormat.setString("mime", this.options.targetMimeType);
        outputFormat.setInteger("sample-rate", outputSampleRate);
        outputFormat.setInteger("channel-count", outputChannels);
        outputFormat.setInteger("bitrate", (int)outputBitRate);
        if ("audio/mp4a-latm".equalsIgnoreCase(this.options.targetMimeType)) {
            outputFormat.setInteger("aac-profile", 2);
        }
        return TrackStatus.COMPRESSING;
    }

    private int getInputChannelCount(@NonNull List<MediaFormat> formats) {
        int count = 0;
        for (MediaFormat format : formats) {
            count = Math.max(count, format.getInteger("channel-count"));
        }
        return count;
    }

    private int getInputSampleRate(@NonNull List<MediaFormat> formats) {
        int minRate = Integer.MAX_VALUE;
        for (MediaFormat format : formats) {
            minRate = Math.min(minRate, format.getInteger("sample-rate"));
        }
        return minRate;
    }

    public static class Builder {
        private int targetChannels = -1;
        private int targetSampleRate = -1;
        private long targetBitRate = Long.MIN_VALUE;
        private String targetMimeType = "audio/mp4a-latm";

        @NonNull
        public Builder channels(int channels) {
            this.targetChannels = channels;
            return this;
        }

        @NonNull
        public Builder sampleRate(int sampleRate) {
            this.targetSampleRate = sampleRate;
            return this;
        }

        @NonNull
        public Builder bitRate(long bitRate) {
            this.targetBitRate = bitRate;
            return this;
        }

        @NonNull
        public Builder mimeType(@NonNull String mimeType) {
            this.targetMimeType = mimeType;
            return this;
        }

        @NonNull
        public Options options() {
            Options options = new Options();
            options.targetChannels = this.targetChannels;
            options.targetSampleRate = this.targetSampleRate;
            options.targetMimeType = this.targetMimeType;
            options.targetBitRate = this.targetBitRate;
            return options;
        }

        @NonNull
        public DefaultAudioStrategy build() {
            return new DefaultAudioStrategy(this.options());
        }
    }

    public static class Options {
        private int targetChannels;
        private int targetSampleRate;
        private long targetBitRate;
        private String targetMimeType;

        private Options() {
        }
    }
}

