/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.resize;

import androidx.annotation.NonNull;
import com.otaliastudios.transcoder.common.Size;
import com.otaliastudios.transcoder.resize.Resizer;

public class AtMostResizer
implements Resizer {
    private final int atMostMinor;
    private final int atMostMajor;

    public AtMostResizer(int atMost) {
        this.atMostMinor = atMost;
        this.atMostMajor = Integer.MAX_VALUE;
    }

    public AtMostResizer(int atMostMinor, int atMostMajor) {
        this.atMostMinor = atMostMinor;
        this.atMostMajor = atMostMajor;
    }

    @Override
    @NonNull
    public Size getOutputSize(@NonNull Size inputSize) {
        int outMinor;
        int outMajor;
        if (inputSize.getMinor() <= this.atMostMinor && inputSize.getMajor() <= this.atMostMajor) {
            return inputSize;
        }
        float minorScale = (float)inputSize.getMinor() / (float)this.atMostMinor;
        float maiorScale = (float)inputSize.getMajor() / (float)this.atMostMajor;
        float inputRatio = (float)inputSize.getMinor() / (float)inputSize.getMajor();
        if (maiorScale >= minorScale) {
            outMajor = this.atMostMajor;
            outMinor = (int)((float)outMajor * inputRatio);
        } else {
            outMinor = this.atMostMinor;
            outMajor = (int)((float)outMinor / inputRatio);
        }
        if (outMinor % 2 != 0) {
            --outMinor;
        }
        if (outMajor % 2 != 0) {
            --outMajor;
        }
        return new Size(outMinor, outMajor);
    }
}

