/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.video;

import android.media.MediaFormat;
import android.view.Surface;
import com.otaliastudios.transcoder.internal.codec.DecoderChannel;
import com.otaliastudios.transcoder.internal.codec.DecoderData;
import com.otaliastudios.transcoder.internal.pipeline.Channel;
import com.otaliastudios.transcoder.internal.pipeline.State;
import com.otaliastudios.transcoder.internal.pipeline.Step;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.video.FrameDrawer;
import com.otaliastudios.transcoder.internal.video.FrameDropper;
import com.otaliastudios.transcoder.internal.video.FrameDropperKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00012\u00020\u0003B'\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\nH\u0016J\b\u0010!\u001a\u00020\u001cH\u0016J$\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020%2\u0006\u0010&\u001a\u00020\fH\u0016R\u0014\u0010\u000e\u001a\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/otaliastudios/transcoder/internal/video/VideoRenderer;", "Lcom/otaliastudios/transcoder/internal/pipeline/Step;", "Lcom/otaliastudios/transcoder/internal/codec/DecoderData;", "Lcom/otaliastudios/transcoder/internal/codec/DecoderChannel;", "", "Lcom/otaliastudios/transcoder/internal/pipeline/Channel;", "sourceRotation", "", "extraRotation", "targetFormat", "Landroid/media/MediaFormat;", "flipY", "", "(IILandroid/media/MediaFormat;Z)V", "channel", "getChannel", "()Lcom/otaliastudios/transcoder/internal/video/VideoRenderer;", "frameDrawer", "Lcom/otaliastudios/transcoder/internal/video/FrameDrawer;", "getFrameDrawer", "()Lcom/otaliastudios/transcoder/internal/video/FrameDrawer;", "frameDrawer$delegate", "Lkotlin/Lazy;", "frameDropper", "Lcom/otaliastudios/transcoder/internal/video/FrameDropper;", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "handleRawFormat", "", "rawFormat", "handleSourceFormat", "Landroid/view/Surface;", "sourceFormat", "release", "step", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "state", "Lcom/otaliastudios/transcoder/internal/pipeline/State$Ok;", "fresh", "lib_release"})
public final class VideoRenderer
implements Step<DecoderData, DecoderChannel, Long, Channel>,
DecoderChannel {
    private final int sourceRotation;
    private final int extraRotation;
    @NotNull
    private final MediaFormat targetFormat;
    @NotNull
    private final Logger log;
    @NotNull
    private final VideoRenderer channel;
    @NotNull
    private final Lazy frameDrawer$delegate;
    private FrameDropper frameDropper;

    public VideoRenderer(int sourceRotation, int extraRotation, @NotNull MediaFormat targetFormat, boolean flipY) {
        Intrinsics.checkNotNullParameter((Object)targetFormat, (String)"targetFormat");
        this.sourceRotation = sourceRotation;
        this.extraRotation = extraRotation;
        this.targetFormat = targetFormat;
        this.log = new Logger("VideoRenderer");
        this.channel = this;
        this.frameDrawer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FrameDrawer>(flipY){
            final /* synthetic */ boolean $flipY;
            {
                this.$flipY = $flipY;
                super(0);
            }

            @NotNull
            public final FrameDrawer invoke() {
                FrameDrawer drawer = new FrameDrawer();
                drawer.setFlipY(this.$flipY);
                return drawer;
            }
        }));
        int width = this.targetFormat.getInteger("width");
        int height = this.targetFormat.getInteger("height");
        boolean flip = this.extraRotation % 180 != 0;
        this.log.e("FrameDrawerEncoder: size=" + width + '-' + height + ", flipping=" + flip);
        this.targetFormat.setInteger("width", flip ? height : width);
        this.targetFormat.setInteger("height", flip ? width : height);
    }

    public /* synthetic */ VideoRenderer(int n, int n2, MediaFormat mediaFormat, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            bl = false;
        }
        this(n, n2, mediaFormat, bl);
    }

    @Override
    @NotNull
    public VideoRenderer getChannel() {
        return this.channel;
    }

    private final FrameDrawer getFrameDrawer() {
        Lazy lazy = this.frameDrawer$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (FrameDrawer)lazy.getValue();
    }

    @Override
    @NotNull
    public Surface handleSourceFormat(@NotNull MediaFormat sourceFormat) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)sourceFormat, (String)"sourceFormat");
        this.log.i("handleSourceFormat(" + sourceFormat + ')');
        Object object3 = this;
        boolean bl = false;
        try {
            object2 = Result.Companion;
            Object $this$handleSourceFormat_u24lambda_u2d0 = object3;
            boolean bl2 = false;
            $this$handleSourceFormat_u24lambda_u2d0 = sourceFormat.getInteger("rotation-degrees");
            bl2 = false;
            object2 = Result.constructor-impl((Object)$this$handleSourceFormat_u24lambda_u2d0);
        }
        catch (Throwable $this$handleSourceFormat_u24lambda_u2d0) {
            Result.Companion bl2 = Result.Companion;
            boolean bl3 = false;
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$handleSourceFormat_u24lambda_u2d0));
        }
        object3 = object2;
        bl = false;
        boolean bl4 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
        if (throwable == null) {
            object = object3;
        } else {
            Throwable it = throwable;
            boolean bl5 = false;
            object = 0;
        }
        int sourceRotation = ((Number)object).intValue();
        if (sourceRotation != this.sourceRotation) {
            object3 = "Unexpected difference in rotation. DataSource=" + this.sourceRotation + ", MediaFormat=" + sourceRotation;
            bl = false;
            throw (Throwable)new IllegalStateException(object3.toString());
        }
        sourceFormat.setInteger("rotation-degrees", 0);
        int rotation = (sourceRotation + this.extraRotation) % 360;
        this.getFrameDrawer().setRotation(rotation);
        boolean flip = rotation % 180 != 0;
        float sourceWidth = sourceFormat.getInteger("width");
        float sourceHeight = sourceFormat.getInteger("height");
        float sourceRatio = sourceWidth / sourceHeight;
        float targetWidth = flip ? this.targetFormat.getInteger("height") : this.targetFormat.getInteger("width");
        float targetHeight = flip ? this.targetFormat.getInteger("width") : this.targetFormat.getInteger("height");
        float targetRatio = targetWidth / targetHeight;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        if (sourceRatio > targetRatio) {
            scaleX = sourceRatio / targetRatio;
        } else if (sourceRatio < targetRatio) {
            scaleY = targetRatio / sourceRatio;
        }
        this.getFrameDrawer().setScale(scaleX, scaleY);
        this.frameDropper = FrameDropperKt.FrameDropper(sourceFormat.getInteger("frame-rate"), this.targetFormat.getInteger("frame-rate"));
        Surface surface = this.getFrameDrawer().getSurface();
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"frameDrawer.surface");
        return surface;
    }

    @Override
    public void handleRawFormat(@NotNull MediaFormat rawFormat) {
        Intrinsics.checkNotNullParameter((Object)rawFormat, (String)"rawFormat");
    }

    @Override
    @NotNull
    public State<Long> step(@NotNull State.Ok<DecoderData> state, boolean fresh) {
        State state2;
        Intrinsics.checkNotNullParameter(state, (String)"state");
        if (state instanceof State.Eos) {
            state.getValue().getRelease().invoke((Object)false);
            state2 = new State.Eos<Long>(0L);
        } else {
            FrameDropper frameDropper;
            FrameDropper frameDropper2 = this.frameDropper;
            if (frameDropper2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"frameDropper");
                frameDropper = null;
            } else {
                frameDropper = frameDropper2;
            }
            if (frameDropper.shouldRender(state.getValue().getTimeUs())) {
                state.getValue().getRelease().invoke((Object)true);
                this.getFrameDrawer().drawFrame();
                state2 = new State.Ok<Long>(state.getValue().getTimeUs());
            } else {
                state.getValue().getRelease().invoke((Object)false);
                state2 = State.Wait.INSTANCE;
            }
        }
        return state2;
    }

    @Override
    public void release() {
        this.getFrameDrawer().release();
    }

    @Override
    public void initialize(@NotNull Channel next) {
        Step.DefaultImpls.initialize(this, next);
    }
}

