/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.utils;

import com.otaliastudios.transcoder.common.TrackType;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0002\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002J\u000f\u0010\u0012\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u00a6\u0002\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H&J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0096\u0002J\u000f\u0010\u001b\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0003\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0005\u00a8\u0006\u001c"}, d2={"Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "T", "", "audio", "getAudio", "()Ljava/lang/Object;", "hasAudio", "", "getHasAudio", "()Z", "hasVideo", "getHasVideo", "size", "", "getSize", "()I", "video", "getVideo", "audioOrNull", "get", "type", "Lcom/otaliastudios/transcoder/common/TrackType;", "(Lcom/otaliastudios/transcoder/common/TrackType;)Ljava/lang/Object;", "getOrNull", "has", "iterator", "", "videoOrNull", "lib_release"})
public interface TrackMap<T>
extends Iterable<T>,
KMappedMarker {
    public T get(@NotNull TrackType var1);

    public T getVideo();

    public T getAudio();

    public boolean has(@NotNull TrackType var1);

    public boolean getHasVideo();

    public boolean getHasAudio();

    @Nullable
    public T getOrNull(@NotNull TrackType var1);

    @Nullable
    public T videoOrNull();

    @Nullable
    public T audioOrNull();

    public int getSize();

    @Override
    @NotNull
    public Iterator<T> iterator();

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static <T> T getVideo(@NotNull TrackMap<T> this_) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            return this_.get(TrackType.VIDEO);
        }

        public static <T> T getAudio(@NotNull TrackMap<T> this_) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            return this_.get(TrackType.AUDIO);
        }

        public static <T> boolean getHasVideo(@NotNull TrackMap<T> this_) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            return this_.has(TrackType.VIDEO);
        }

        public static <T> boolean getHasAudio(@NotNull TrackMap<T> this_) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            return this_.has(TrackType.AUDIO);
        }

        @Nullable
        public static <T> T getOrNull(@NotNull TrackMap<T> this_, @NotNull TrackType type) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return this_.has(type) ? (T)this_.get(type) : null;
        }

        @Nullable
        public static <T> T videoOrNull(@NotNull TrackMap<T> this_) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            return this_.getOrNull(TrackType.VIDEO);
        }

        @Nullable
        public static <T> T audioOrNull(@NotNull TrackMap<T> this_) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            return this_.getOrNull(TrackType.AUDIO);
        }

        public static <T> int getSize(@NotNull TrackMap<T> this_) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            Object[] objectArray = new Object[]{this_.videoOrNull(), this_.audioOrNull()};
            return CollectionsKt.listOfNotNull((Object[])objectArray).size();
        }

        @NotNull
        public static <T> Iterator<T> iterator(@NotNull TrackMap<T> this_) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            Object[] objectArray = new Object[]{this_.videoOrNull(), this_.audioOrNull()};
            return CollectionsKt.listOfNotNull((Object[])objectArray).iterator();
        }
    }
}

