/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.utils;

import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.utils.MutableTrackMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u0012\b\u0010\u0004\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\bH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00018\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/otaliastudios/transcoder/internal/utils/DefaultTrackMap;", "T", "Lcom/otaliastudios/transcoder/internal/utils/MutableTrackMap;", "video", "audio", "(Ljava/lang/Object;Ljava/lang/Object;)V", "map", "", "Lcom/otaliastudios/transcoder/common/TrackType;", "get", "type", "(Lcom/otaliastudios/transcoder/common/TrackType;)Ljava/lang/Object;", "has", "", "set", "", "value", "(Lcom/otaliastudios/transcoder/common/TrackType;Ljava/lang/Object;)V", "lib_release"})
final class DefaultTrackMap<T>
implements MutableTrackMap<T> {
    @NotNull
    private final Map<TrackType, T> map;

    public DefaultTrackMap(@Nullable T video, @Nullable T audio) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)TrackType.VIDEO), video), TuplesKt.to((Object)((Object)TrackType.AUDIO), audio)};
        this.map = MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @Override
    public T get(@NotNull TrackType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        T t = this.map.get((Object)type);
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (t == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return t;
    }

    @Override
    public boolean has(@NotNull TrackType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.map.get((Object)type) != null;
    }

    @Override
    public void set(@NotNull TrackType type, @Nullable T value) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Map<TrackType, T> map = this.map;
        boolean bl = false;
        map.put(type, value);
    }

    @Override
    @Nullable
    public T audioOrNull() {
        return MutableTrackMap.DefaultImpls.audioOrNull(this);
    }

    @Override
    @Nullable
    public T getOrNull(@NotNull TrackType type) {
        return MutableTrackMap.DefaultImpls.getOrNull(this, type);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return MutableTrackMap.DefaultImpls.iterator(this);
    }

    @Override
    public void reset(@Nullable T video, @Nullable T audio) {
        MutableTrackMap.DefaultImpls.reset(this, video, audio);
    }

    @Override
    @Nullable
    public T videoOrNull() {
        return MutableTrackMap.DefaultImpls.videoOrNull(this);
    }

    @Override
    public boolean getHasAudio() {
        return MutableTrackMap.DefaultImpls.getHasAudio(this);
    }

    @Override
    public boolean getHasVideo() {
        return MutableTrackMap.DefaultImpls.getHasVideo(this);
    }

    @Override
    public int getSize() {
        return MutableTrackMap.DefaultImpls.getSize(this);
    }

    @Override
    public T getAudio() {
        return MutableTrackMap.DefaultImpls.getAudio(this);
    }

    @Override
    public void setAudio(T value) {
        MutableTrackMap.DefaultImpls.setAudio(this, value);
    }

    @Override
    public T getVideo() {
        return MutableTrackMap.DefaultImpls.getVideo(this);
    }

    @Override
    public void setVideo(T value) {
        MutableTrackMap.DefaultImpls.setVideo(this, value);
    }
}

