/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.thumbnails;

import android.os.Handler;
import androidx.annotation.NonNull;
import com.otaliastudios.transcoder.ThumbnailerListener;
import com.otaliastudios.transcoder.ThumbnailerOptions;
import com.otaliastudios.transcoder.thumbnail.Thumbnail;
import java.util.ArrayList;
import java.util.List;

class ThumbnailsDispatcher {
    private final Handler mHandler;
    private final ThumbnailerListener mListener;
    private final List<Thumbnail> mResults = new ArrayList<Thumbnail>();

    ThumbnailsDispatcher(@NonNull ThumbnailerOptions options) {
        this.mHandler = options.getListenerHandler();
        this.mListener = options.getListener();
    }

    void dispatchCancel() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                ThumbnailsDispatcher.this.mListener.onThumbnailsCanceled();
            }
        });
    }

    void dispatchCompletion() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                ThumbnailsDispatcher.this.mListener.onThumbnailsCompleted(ThumbnailsDispatcher.this.mResults);
            }
        });
    }

    void dispatchFailure(final @NonNull Throwable exception) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                ThumbnailsDispatcher.this.mListener.onThumbnailsFailed(exception);
            }
        });
    }

    void dispatchThumbnail(final @NonNull Thumbnail thumbnail) {
        this.mResults.add(thumbnail);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                ThumbnailsDispatcher.this.mListener.onThumbnail(thumbnail);
            }
        });
    }
}

