/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.pipeline;

import android.media.MediaFormat;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.Codecs;
import com.otaliastudios.transcoder.internal.audio.AudioEngine;
import com.otaliastudios.transcoder.internal.codec.Decoder;
import com.otaliastudios.transcoder.internal.codec.DecoderTimer;
import com.otaliastudios.transcoder.internal.codec.Encoder;
import com.otaliastudios.transcoder.internal.data.Bridge;
import com.otaliastudios.transcoder.internal.data.Reader;
import com.otaliastudios.transcoder.internal.data.ReaderTimer;
import com.otaliastudios.transcoder.internal.data.Writer;
import com.otaliastudios.transcoder.internal.pipeline.Channel;
import com.otaliastudios.transcoder.internal.pipeline.Pipeline;
import com.otaliastudios.transcoder.internal.pipeline.PipelineKt;
import com.otaliastudios.transcoder.internal.pipeline.Step;
import com.otaliastudios.transcoder.internal.video.VideoPublisher;
import com.otaliastudios.transcoder.internal.video.VideoRenderer;
import com.otaliastudios.transcoder.resample.AudioResampler;
import com.otaliastudios.transcoder.sink.DataSink;
import com.otaliastudios.transcoder.source.DataSource;
import com.otaliastudios.transcoder.stretch.AudioStretcher;
import com.otaliastudios.transcoder.time.TimeInterpolator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u001a@\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\b\u0010\u0010\u001a\u00020\u0001H\u0000\u001a(\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001aP\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a8\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0018"}, d2={"AudioPipeline", "Lcom/otaliastudios/transcoder/internal/pipeline/Pipeline;", "source", "Lcom/otaliastudios/transcoder/source/DataSource;", "sink", "Lcom/otaliastudios/transcoder/sink/DataSink;", "interpolator", "Lcom/otaliastudios/transcoder/time/TimeInterpolator;", "format", "Landroid/media/MediaFormat;", "codecs", "Lcom/otaliastudios/transcoder/internal/Codecs;", "audioStretcher", "Lcom/otaliastudios/transcoder/stretch/AudioStretcher;", "audioResampler", "Lcom/otaliastudios/transcoder/resample/AudioResampler;", "EmptyPipeline", "PassThroughPipeline", "track", "Lcom/otaliastudios/transcoder/common/TrackType;", "RegularPipeline", "videoRotation", "", "VideoPipeline", "lib_release"})
public final class PipelinesKt {
    @NotNull
    public static final Pipeline EmptyPipeline() {
        return Pipeline.Companion.build$lib_release$default(Pipeline.Companion, "Empty", null, 2, null);
    }

    @NotNull
    public static final Pipeline PassThroughPipeline(@NotNull TrackType track, @NotNull DataSource source2, @NotNull DataSink sink2, @NotNull TimeInterpolator interpolator2) {
        Intrinsics.checkNotNullParameter((Object)((Object)track), (String)"track");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)interpolator2, (String)"interpolator");
        return Pipeline.Companion.build$lib_release("PassThrough(" + (Object)((Object)track) + ')', (Function0)new Function0<Pipeline.Builder<?, Channel>>(source2, track, interpolator2, sink2){
            final /* synthetic */ DataSource $source;
            final /* synthetic */ TrackType $track;
            final /* synthetic */ TimeInterpolator $interpolator;
            final /* synthetic */ DataSink $sink;
            {
                this.$source = $source;
                this.$track = $track;
                this.$interpolator = $interpolator;
                this.$sink = $sink;
                super(0);
            }

            @NotNull
            public final Pipeline.Builder<?, Channel> invoke() {
                Pipeline.Builder<NewData, NewChannel> builder = PipelineKt.plus(new Reader(this.$source, this.$track), new ReaderTimer(this.$track, this.$interpolator));
                MediaFormat mediaFormat = this.$source.getTrackFormat(this.$track);
                Intrinsics.checkNotNull((Object)mediaFormat);
                MediaFormat mediaFormat2 = mediaFormat;
                Intrinsics.checkNotNullExpressionValue((Object)mediaFormat2, (String)"source.getTrackFormat(track)!!");
                return builder.plus(new Bridge(mediaFormat2)).plus(new Writer(this.$sink, this.$track));
            }
        });
    }

    @NotNull
    public static final Pipeline RegularPipeline(@NotNull TrackType track, @NotNull DataSource source2, @NotNull DataSink sink2, @NotNull TimeInterpolator interpolator2, @NotNull MediaFormat format, @NotNull Codecs codecs, int videoRotation, @NotNull AudioStretcher audioStretcher, @NotNull AudioResampler audioResampler) {
        Pipeline pipeline;
        Intrinsics.checkNotNullParameter((Object)((Object)track), (String)"track");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)interpolator2, (String)"interpolator");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)codecs, (String)"codecs");
        Intrinsics.checkNotNullParameter((Object)audioStretcher, (String)"audioStretcher");
        Intrinsics.checkNotNullParameter((Object)audioResampler, (String)"audioResampler");
        TrackType trackType = track;
        int n = WhenMappings.$EnumSwitchMapping$0[trackType.ordinal()];
        switch (n) {
            case 1: {
                pipeline = PipelinesKt.VideoPipeline(source2, sink2, interpolator2, format, codecs, videoRotation);
                break;
            }
            case 2: {
                pipeline = PipelinesKt.AudioPipeline(source2, sink2, interpolator2, format, codecs, audioStretcher, audioResampler);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pipeline;
    }

    private static final Pipeline VideoPipeline(DataSource source2, DataSink sink2, TimeInterpolator interpolator2, MediaFormat format, Codecs codecs, int videoRotation) {
        return Pipeline.Companion.build$lib_release("Video", (Function0)new Function0<Pipeline.Builder<?, Channel>>(source2, interpolator2, videoRotation, format, codecs, sink2){
            final /* synthetic */ DataSource $source;
            final /* synthetic */ TimeInterpolator $interpolator;
            final /* synthetic */ int $videoRotation;
            final /* synthetic */ MediaFormat $format;
            final /* synthetic */ Codecs $codecs;
            final /* synthetic */ DataSink $sink;
            {
                this.$source = $source;
                this.$interpolator = $interpolator;
                this.$videoRotation = $videoRotation;
                this.$format = $format;
                this.$codecs = $codecs;
                this.$sink = $sink;
                super(0);
            }

            @NotNull
            public final Pipeline.Builder<?, Channel> invoke() {
                Step step2 = new Reader(this.$source, TrackType.VIDEO);
                MediaFormat mediaFormat = this.$source.getTrackFormat(TrackType.VIDEO);
                Intrinsics.checkNotNull((Object)mediaFormat);
                MediaFormat mediaFormat2 = mediaFormat;
                Intrinsics.checkNotNullExpressionValue((Object)mediaFormat2, (String)"source.getTrackFormat(TrackType.VIDEO)!!");
                return PipelineKt.plus(step2, new Decoder(mediaFormat2, true)).plus(new DecoderTimer(TrackType.VIDEO, this.$interpolator)).plus(new VideoRenderer(this.$source.getOrientation(), this.$videoRotation, this.$format, false, 8, null)).plus(new VideoPublisher()).plus(new Encoder(this.$codecs, TrackType.VIDEO)).plus(new Writer(this.$sink, TrackType.VIDEO));
            }
        });
    }

    private static final Pipeline AudioPipeline(DataSource source2, DataSink sink2, TimeInterpolator interpolator2, MediaFormat format, Codecs codecs, AudioStretcher audioStretcher, AudioResampler audioResampler) {
        return Pipeline.Companion.build$lib_release("Audio", (Function0)new Function0<Pipeline.Builder<?, Channel>>(source2, interpolator2, audioStretcher, audioResampler, format, codecs, sink2){
            final /* synthetic */ DataSource $source;
            final /* synthetic */ TimeInterpolator $interpolator;
            final /* synthetic */ AudioStretcher $audioStretcher;
            final /* synthetic */ AudioResampler $audioResampler;
            final /* synthetic */ MediaFormat $format;
            final /* synthetic */ Codecs $codecs;
            final /* synthetic */ DataSink $sink;
            {
                this.$source = $source;
                this.$interpolator = $interpolator;
                this.$audioStretcher = $audioStretcher;
                this.$audioResampler = $audioResampler;
                this.$format = $format;
                this.$codecs = $codecs;
                this.$sink = $sink;
                super(0);
            }

            @NotNull
            public final Pipeline.Builder<?, Channel> invoke() {
                Step step2 = new Reader(this.$source, TrackType.AUDIO);
                MediaFormat mediaFormat = this.$source.getTrackFormat(TrackType.AUDIO);
                Intrinsics.checkNotNull((Object)mediaFormat);
                MediaFormat mediaFormat2 = mediaFormat;
                Intrinsics.checkNotNullExpressionValue((Object)mediaFormat2, (String)"source.getTrackFormat(TrackType.AUDIO)!!");
                return PipelineKt.plus(step2, new Decoder(mediaFormat2, true)).plus(new DecoderTimer(TrackType.AUDIO, this.$interpolator)).plus(new AudioEngine(this.$audioStretcher, this.$audioResampler, this.$format)).plus(new Encoder(this.$codecs, TrackType.AUDIO)).plus(new Writer(this.$sink, TrackType.AUDIO));
            }
        });
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrackType.values().length];
            nArray[TrackType.VIDEO.ordinal()] = 1;
            nArray[TrackType.AUDIO.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

