/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.pipeline;

import com.otaliastudios.transcoder.internal.pipeline.Channel;
import com.otaliastudios.transcoder.internal.pipeline.Pipeline;
import com.otaliastudios.transcoder.internal.pipeline.State;
import com.otaliastudios.transcoder.internal.pipeline.Step;
import com.otaliastudios.transcoder.internal.pipeline.StepKt;
import com.otaliastudios.transcoder.internal.utils.Logger;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aB9\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012(\u0010\u0004\u001a$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u0005\u00a2\u0006\u0002\u0010\tJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011JJ\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\"\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0012R0\u0010\u0004\u001a$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/otaliastudios/transcoder/internal/pipeline/Pipeline;", "", "name", "", "chain", "", "Lcom/otaliastudios/transcoder/internal/pipeline/Step;", "Lcom/otaliastudios/transcoder/internal/pipeline/Channel;", "Lcom/otaliastudios/transcoder/internal/pipeline/AnyStep;", "(Ljava/lang/String;Ljava/util/List;)V", "headIndex", "", "headState", "Lcom/otaliastudios/transcoder/internal/pipeline/State$Ok;", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "execute", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "", "executeStep", "previous", "step", "fresh", "", "release", "Builder", "Companion", "lib_release"})
public final class Pipeline {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Step<Object, Channel, Object, Channel>> chain;
    @NotNull
    private final Logger log;
    @NotNull
    private State.Ok<Object> headState;
    private int headIndex;

    private Pipeline(String name, List<? extends Step<Object, Channel, Object, Channel>> chain) {
        this.chain = chain;
        this.log = new Logger("Pipeline(" + name + ')');
        this.headState = new State.Ok<Unit>(Unit.INSTANCE);
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)CollectionsKt.zipWithNext((Iterable)this.chain));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair $dstr$first$next = (Pair)element$iv;
            boolean bl = false;
            Step first = (Step)$dstr$first$next.component1();
            Step next = (Step)$dstr$first$next.component2();
            first.initialize(next.getChannel());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final State<Unit> execute() {
        this.log.v("execute(): starting. head=" + this.headIndex + " steps=" + this.chain.size() + " remaining=" + (this.chain.size() - this.headIndex));
        int head = this.headIndex;
        State.Ok<Object> state = null;
        state = this.headState;
        Iterable $this$forEachIndexed$iv = this.chain;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void step2;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Step step3 = (Step)item$iv;
            int index = n;
            boolean bl2 = false;
            if (index < head) continue;
            boolean fresh = head == 0 || index != head;
            State.Ok<Object> ok = this.executeStep(state, (Step<Object, Channel, Object, Channel>)step2, fresh);
            if (ok == null) {
                Pipeline pipeline = this;
                boolean bl3 = false;
                boolean bl4 = false;
                Pipeline $this$execute_u24lambda_u2d2_u24lambda_u2d1 = pipeline;
                boolean bl5 = false;
                $this$execute_u24lambda_u2d2_u24lambda_u2d1.log.v("execute(): step " + StepKt.getName(step2) + " (#" + index + '/' + $this$execute_u24lambda_u2d2_u24lambda_u2d1.chain.size() + ") is waiting. headState=" + $this$execute_u24lambda_u2d2_u24lambda_u2d1.headState + " headIndex=" + $this$execute_u24lambda_u2d2_u24lambda_u2d1.headIndex);
                return State.Wait.INSTANCE;
            }
            state = ok;
            if (!(state instanceof State.Eos)) continue;
            this.log.i("execute(): EOS from " + StepKt.getName(step2) + " (#" + index + '/' + this.chain.size() + ").");
            this.headState = state;
            this.headIndex = index + 1;
        }
        return this.chain.isEmpty() ? (State)new State.Eos<Unit>(Unit.INSTANCE) : (state instanceof State.Eos ? (State)new State.Eos<Unit>(Unit.INSTANCE) : (State)new State.Ok<Unit>(Unit.INSTANCE));
    }

    public final void release() {
        Iterable $this$forEach$iv = this.chain;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Step it = (Step)element$iv;
            boolean bl = false;
            it.release();
        }
    }

    private final State.Ok<Object> executeStep(State.Ok<Object> previous, Step<Object, Channel, Object, Channel> step2, boolean fresh) {
        State.Ok<Object> ok;
        State<Object> state = step2.step(previous, fresh);
        State<Object> state2 = state;
        if (state2 instanceof State.Ok) {
            ok = (State.Ok<Object>)state;
        } else if (state2 instanceof State.Retry) {
            ok = this.executeStep(previous, step2, false);
        } else if (state2 instanceof State.Wait) {
            ok = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return ok;
    }

    public /* synthetic */ Pipeline(String name, List chain, DefaultConstructorMarker $constructor_marker) {
        this(name, chain);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\b\u0002\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\n0\t0\bH\u0000\u00a2\u0006\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/otaliastudios/transcoder/internal/pipeline/Pipeline$Companion;", "", "()V", "build", "Lcom/otaliastudios/transcoder/internal/pipeline/Pipeline;", "name", "", "builder", "Lkotlin/Function0;", "Lcom/otaliastudios/transcoder/internal/pipeline/Pipeline$Builder;", "Lcom/otaliastudios/transcoder/internal/pipeline/Channel;", "build$lib_release", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pipeline build$lib_release(@NotNull String name, @NotNull Function0<? extends Builder<?, Channel>> builder) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(builder, (String)"builder");
            return new Pipeline(name, ((Builder)builder.invoke()).getSteps$lib_release(), null);
        }

        public static /* synthetic */ Pipeline build$lib_release$default(Companion companion, String string, Function0 function0, int n, Object object) {
            if ((n & 2) != 0) {
                function0 = build.1.INSTANCE;
            }
            return companion.build$lib_release(string, function0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0002B'\b\u0000\u0012\u001e\b\u0002\u0010\u0005\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u0006\u00a2\u0006\u0002\u0010\bJI\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u0000\"\b\b\u0002\u0010\f*\u00020\u0002\"\b\b\u0003\u0010\r*\u00020\u00042\u001e\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u0007H\u0086\u0002R*\u0010\u0005\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/otaliastudios/transcoder/internal/pipeline/Pipeline$Builder;", "D", "", "C", "Lcom/otaliastudios/transcoder/internal/pipeline/Channel;", "steps", "", "Lcom/otaliastudios/transcoder/internal/pipeline/Step;", "(Ljava/util/List;)V", "getSteps$lib_release", "()Ljava/util/List;", "plus", "NewData", "NewChannel", "step", "lib_release"})
    public static final class Builder<D, C extends Channel> {
        @NotNull
        private final List<Step<?, ?, ?, ?>> steps;

        public Builder(@NotNull List<? extends Step<?, ?, ?, ?>> steps) {
            Intrinsics.checkNotNullParameter(steps, (String)"steps");
            this.steps = steps;
        }

        public /* synthetic */ Builder(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                boolean bl = false;
                list = CollectionsKt.emptyList();
            }
            this(list);
        }

        @NotNull
        public final List<Step<?, ?, ?, ?>> getSteps$lib_release() {
            return this.steps;
        }

        @NotNull
        public final <NewData, NewChannel extends Channel> Builder<NewData, NewChannel> plus(@NotNull Step<D, C, NewData, NewChannel> step2) {
            Intrinsics.checkNotNullParameter(step2, (String)"step");
            return new Builder<D, C>(CollectionsKt.plus((Collection)this.steps, step2));
        }

        public Builder() {
            this(null, 1, null);
        }
    }
}

