/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.audio.remix;

import androidx.annotation.NonNull;
import com.otaliastudios.transcoder.internal.audio.remix.AudioRemixer;
import java.nio.ShortBuffer;

public class DownMixAudioRemixer
implements AudioRemixer {
    private static final int SIGNED_SHORT_LIMIT = 32768;
    private static final int UNSIGNED_SHORT_MAX = 65535;

    @Override
    public void remix(@NonNull ShortBuffer inputBuffer, @NonNull ShortBuffer outputBuffer) {
        int inRemaining = inputBuffer.remaining() / 2;
        int outSpace = outputBuffer.remaining();
        int samplesToBeProcessed = Math.min(inRemaining, outSpace);
        for (int i = 0; i < samplesToBeProcessed; ++i) {
            int a = inputBuffer.get() + 32768;
            int b = inputBuffer.get() + 32768;
            int m = a < 32768 || b < 32768 ? a * b / 32768 : 2 * (a + b) - a * b / 32768 - 65535;
            if (m == 65536) {
                m = 65535;
            }
            outputBuffer.put((short)(m - 32768));
        }
    }

    @Override
    public int getRemixedSize(int inputSize) {
        return inputSize / 2;
    }
}

