/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.audio;

import kotlin.Metadata;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\r\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u001a \u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u001a \u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u001a \u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u001a \u0010\u000f\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"BYTES_PER_SAMPLE_PER_CHANNEL", "", "MICROSECONDS_PER_SECOND", "", "bitRate", "sampleRate", "channels", "bytesToUs", "bytes", "samplesToBytes", "samples", "shortsToUs", "shorts", "usToBytes", "us", "usToShorts", "lib_release"})
public final class ConversionsKt {
    private static final int BYTES_PER_SAMPLE_PER_CHANNEL = 2;
    private static final long MICROSECONDS_PER_SECOND = 1000000L;

    public static final long bytesToUs(int bytes, int sampleRate, int channels) {
        int byteRatePerChannel = sampleRate * 2;
        int byteRate = byteRatePerChannel * channels;
        return 1000000L * (long)bytes / (long)byteRate;
    }

    public static final int bitRate(int sampleRate, int channels) {
        int byteRate = channels * sampleRate * 2;
        return byteRate * 8;
    }

    public static final int samplesToBytes(int samples, int channels) {
        int bytesPerSample = 2 * channels;
        return samples * bytesPerSample;
    }

    public static final int usToBytes(long us, int sampleRate, int channels) {
        int byteRatePerChannel = sampleRate * 2;
        int byteRate = byteRatePerChannel * channels;
        double d = (double)us * (double)byteRate / (double)1000000L;
        boolean bl = false;
        return (int)Math.ceil(d);
    }

    public static final long shortsToUs(int shorts, int sampleRate, int channels) {
        return ConversionsKt.bytesToUs(shorts * 2, sampleRate, channels);
    }

    public static final int usToShorts(long us, int sampleRate, int channels) {
        return ConversionsKt.usToBytes(us, sampleRate, channels) / 2;
    }
}

