/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.audio;

import com.otaliastudios.transcoder.internal.audio.Chunk;
import com.otaliastudios.transcoder.internal.audio.ConversionsKt;
import java.nio.ShortBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005Jf\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u0002H\n2K\u0010\f\u001aG\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u0002H\n0\r\u00a2\u0006\u0002\u0010\u0016J,\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aJ\u0006\u0010\u001b\u001a\u00020\u0018J\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/otaliastudios/transcoder/internal/audio/ChunkQueue;", "", "sampleRate", "", "channels", "(II)V", "queue", "Lkotlin/collections/ArrayDeque;", "Lcom/otaliastudios/transcoder/internal/audio/Chunk;", "drain", "T", "eos", "action", "Lkotlin/Function3;", "Ljava/nio/ShortBuffer;", "Lkotlin/ParameterName;", "name", "buffer", "", "timeUs", "", "timeStretch", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "enqueue", "", "release", "Lkotlin/Function0;", "enqueueEos", "isEmpty", "", "lib_release"})
public final class ChunkQueue {
    private final int sampleRate;
    private final int channels;
    @NotNull
    private final ArrayDeque<Chunk> queue;

    public ChunkQueue(int sampleRate, int channels) {
        this.sampleRate = sampleRate;
        this.channels = channels;
        this.queue = new ArrayDeque();
    }

    public final boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public final void enqueue(@NotNull ShortBuffer buffer, long timeUs, double timeStretch, @NotNull Function0<Unit> release) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(release, (String)"release");
        if (buffer.hasRemaining()) {
            this.queue.addLast((Object)new Chunk(buffer, timeUs, timeStretch, release));
        } else {
            release.invoke();
        }
    }

    public final void enqueueEos() {
        this.queue.addLast((Object)Chunk.Companion.getEos());
    }

    public final <T> T drain(T eos, @NotNull Function3<? super ShortBuffer, ? super Long, ? super Double, ? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Chunk head = (Chunk)this.queue.removeFirst();
        if (head == Chunk.Companion.getEos()) {
            return eos;
        }
        int size = head.getBuffer().remaining();
        int limit = head.getBuffer().limit();
        Object result2 = action.invoke((Object)head.getBuffer(), (Object)head.getTimeUs(), (Object)head.getTimeStretch());
        head.getBuffer().limit(limit);
        if (head.getBuffer().hasRemaining()) {
            int consumed = size - head.getBuffer().remaining();
            this.queue.addFirst((Object)Chunk.copy$default(head, null, ConversionsKt.shortsToUs(consumed, this.sampleRate, this.channels), 0.0, null, 13, null));
        } else {
            head.getRelease().invoke();
        }
        return (T)result2;
    }
}

