/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal;

import android.media.MediaFormat;
import com.otaliastudios.transcoder.common.TrackStatus;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.DataSources;
import com.otaliastudios.transcoder.internal.Segment;
import com.otaliastudios.transcoder.internal.Tracks;
import com.otaliastudios.transcoder.internal.pipeline.Pipeline;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.MutableTrackMap;
import com.otaliastudios.transcoder.internal.utils.TrackMapKt;
import com.otaliastudios.transcoder.source.DataSource;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012$\u0010\u0006\u001a \u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001c\u001a\u00020\bJ\u0006\u0010\u001e\u001a\u00020\u0018J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010 \u001a\u00020\tH\u0002R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R,\u0010\u0006\u001a \u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/otaliastudios/transcoder/internal/Segments;", "", "sources", "Lcom/otaliastudios/transcoder/internal/DataSources;", "tracks", "Lcom/otaliastudios/transcoder/internal/Tracks;", "factory", "Lkotlin/Function4;", "Lcom/otaliastudios/transcoder/common/TrackType;", "", "Lcom/otaliastudios/transcoder/common/TrackStatus;", "Landroid/media/MediaFormat;", "Lcom/otaliastudios/transcoder/internal/pipeline/Pipeline;", "(Lcom/otaliastudios/transcoder/internal/DataSources;Lcom/otaliastudios/transcoder/internal/Tracks;Lkotlin/jvm/functions/Function4;)V", "current", "Lcom/otaliastudios/transcoder/internal/utils/MutableTrackMap;", "Lcom/otaliastudios/transcoder/internal/Segment;", "currentIndex", "getCurrentIndex", "()Lcom/otaliastudios/transcoder/internal/utils/MutableTrackMap;", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "requestedIndex", "destroySegment", "", "segment", "hasNext", "", "type", "next", "release", "tryCreateSegment", "index", "lib_release"})
public final class Segments {
    @NotNull
    private final DataSources sources;
    @NotNull
    private final Tracks tracks;
    @NotNull
    private final Function4<TrackType, Integer, TrackStatus, MediaFormat, Pipeline> factory;
    @NotNull
    private final Logger log;
    @NotNull
    private final MutableTrackMap<Segment> current;
    @NotNull
    private final MutableTrackMap<Integer> currentIndex;
    @NotNull
    private final MutableTrackMap<Integer> requestedIndex;

    public Segments(@NotNull DataSources sources, @NotNull Tracks tracks, @NotNull Function4<? super TrackType, ? super Integer, ? super TrackStatus, ? super MediaFormat, Pipeline> factory) {
        Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)tracks, (String)"tracks");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        this.sources = sources;
        this.tracks = tracks;
        this.factory = factory;
        this.log = new Logger("Segments");
        this.current = TrackMapKt.mutableTrackMapOf(null, null);
        this.currentIndex = TrackMapKt.mutableTrackMapOf(-1, -1);
        this.requestedIndex = TrackMapKt.mutableTrackMapOf(0, 0);
    }

    @NotNull
    public final MutableTrackMap<Integer> getCurrentIndex() {
        return this.currentIndex;
    }

    public final boolean hasNext(@NotNull TrackType type) {
        Integer n;
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (!this.sources.has(type)) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder().append("hasNext(").append((Object)type).append("): segment=").append(this.current.getOrNull(type)).append(" lastIndex=").append((object = (List)this.sources.getOrNull(type)) == null ? null : Integer.valueOf(CollectionsKt.getLastIndex((List)object))).append(" canAdvance=");
        object = (Segment)this.current.getOrNull(type);
        this.log.v(stringBuilder.append(object == null ? null : Boolean.valueOf(((Segment)object).canAdvance())).toString());
        Segment segment = (Segment)this.current.getOrNull(type);
        if (segment == null) {
            return true;
        }
        Segment segment2 = segment;
        List list = (List)this.sources.getOrNull(type);
        Integer n2 = n = list == null ? null : Integer.valueOf(CollectionsKt.getLastIndex((List)list));
        if (n == null) {
            return false;
        }
        int lastIndex = n;
        return segment2.canAdvance() || segment2.getIndex() < lastIndex;
    }

    public final boolean hasNext() {
        return this.hasNext(TrackType.VIDEO) || this.hasNext(TrackType.AUDIO);
    }

    @Nullable
    public final Segment next(@NotNull TrackType type) {
        Segment segment;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        int currentIndex = ((Number)this.currentIndex.get(type)).intValue();
        int requestedIndex = ((Number)this.requestedIndex.get(type)).intValue();
        if (requestedIndex < currentIndex) {
            String string = "Requested index " + requestedIndex + " smaller than " + currentIndex + '.';
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (requestedIndex > currentIndex) {
            segment = this.tryCreateSegment(type, requestedIndex);
        } else if (((Segment)this.current.get(type)).canAdvance()) {
            segment = (Segment)this.current.get(type);
        } else {
            this.destroySegment((Segment)this.current.get(type));
            segment = this.next(type);
        }
        return segment;
    }

    public final void release() {
        Segment it;
        boolean bl;
        boolean bl2;
        Segment segment;
        Segment segment2 = (Segment)this.current.videoOrNull();
        if (segment2 != null) {
            segment = segment2;
            bl2 = false;
            bl = false;
            it = segment;
            boolean bl3 = false;
            this.destroySegment(it);
        }
        segment2 = (Segment)this.current.audioOrNull();
        if (segment2 != null) {
            segment = segment2;
            bl2 = false;
            bl = false;
            it = segment;
            boolean bl4 = false;
            this.destroySegment(it);
        }
    }

    private final Segment tryCreateSegment(TrackType type, int index) {
        int n;
        Object object;
        DataSource dataSource = (DataSource)CollectionsKt.getOrNull((List)this.sources.get(type), (int)index);
        if (dataSource == null) {
            return null;
        }
        DataSource source2 = dataSource;
        this.log.i("tryCreateSegment(" + (Object)((Object)type) + ", " + index + "): created!");
        if (this.tracks.getActive().has(type)) {
            TrackType trackType;
            source2.selectTrack(type);
            object = type;
            n = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
            switch (n) {
                case 1: {
                    trackType = TrackType.VIDEO;
                    break;
                }
                case 2: {
                    trackType = TrackType.AUDIO;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            TrackType other = trackType;
            if (this.tracks.getActive().has(other)) {
                boolean bl;
                block11: {
                    Iterable $this$any$iv = (Iterable)this.sources.get(other);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            DataSource it = (DataSource)element$iv;
                            boolean bl2 = false;
                            if (!(it == source2)) continue;
                            bl = true;
                            break block11;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    source2.selectTrack(other);
                }
            }
        }
        this.currentIndex.set(type, index);
        Pipeline pipeline = (Pipeline)this.factory.invoke((Object)type, (Object)index, (Object)this.tracks.getAll().get(type), (Object)this.tracks.getOutputFormats().get(type));
        object = new Segment(type, index, pipeline);
        n = 0;
        boolean bl = false;
        Object it = object;
        boolean bl3 = false;
        this.current.set(type, (Segment)it);
        return object;
    }

    private final void destroySegment(Segment segment) {
        segment.release();
        DataSource source2 = (DataSource)this.sources.get(segment.getType()).get(segment.getIndex());
        if (this.tracks.getActive().has(segment.getType())) {
            source2.releaseTrack(segment.getType());
        }
        this.requestedIndex.set(segment.getType(), segment.getIndex() + 1);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrackType.values().length];
            nArray[TrackType.AUDIO.ordinal()] = 1;
            nArray[TrackType.VIDEO.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

