/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal;

import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.pipeline.Pipeline;
import com.otaliastudios.transcoder.internal.pipeline.State;
import com.otaliastudios.transcoder.internal.utils.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/otaliastudios/transcoder/internal/Segment;", "", "type", "Lcom/otaliastudios/transcoder/common/TrackType;", "index", "", "pipeline", "Lcom/otaliastudios/transcoder/internal/pipeline/Pipeline;", "(Lcom/otaliastudios/transcoder/common/TrackType;ILcom/otaliastudios/transcoder/internal/pipeline/Pipeline;)V", "getIndex", "()I", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "state", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "", "getType", "()Lcom/otaliastudios/transcoder/common/TrackType;", "advance", "", "canAdvance", "release", "lib_release"})
public final class Segment {
    @NotNull
    private final TrackType type;
    private final int index;
    @NotNull
    private final Pipeline pipeline;
    @NotNull
    private final Logger log;
    @Nullable
    private State<Unit> state;

    public Segment(@NotNull TrackType type, int index, @NotNull Pipeline pipeline) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        this.type = type;
        this.index = index;
        this.pipeline = pipeline;
        this.log = new Logger("Segment(" + (Object)((Object)this.type) + ',' + this.index + ')');
    }

    @NotNull
    public final TrackType getType() {
        return this.type;
    }

    public final int getIndex() {
        return this.index;
    }

    public final boolean advance() {
        this.state = this.pipeline.execute();
        return this.state instanceof State.Ok;
    }

    public final boolean canAdvance() {
        this.log.v(Intrinsics.stringPlus((String)"canAdvance(): state=", this.state));
        return this.state == null || !(this.state instanceof State.Eos);
    }

    public final void release() {
        this.pipeline.release();
    }
}

