/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import com.otaliastudios.transcoder.Thumbnailer;
import com.otaliastudios.transcoder.ThumbnailerListener;
import com.otaliastudios.transcoder.resize.ExactResizer;
import com.otaliastudios.transcoder.resize.MultiResizer;
import com.otaliastudios.transcoder.resize.Resizer;
import com.otaliastudios.transcoder.source.DataSource;
import com.otaliastudios.transcoder.source.FileDescriptorDataSource;
import com.otaliastudios.transcoder.source.FilePathDataSource;
import com.otaliastudios.transcoder.source.UriDataSource;
import com.otaliastudios.transcoder.thumbnail.ThumbnailRequest;
import java.io.FileDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0001\u001bBA\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/otaliastudios/transcoder/ThumbnailerOptions;", "", "dataSources", "", "Lcom/otaliastudios/transcoder/source/DataSource;", "resizer", "Lcom/otaliastudios/transcoder/resize/Resizer;", "rotation", "", "thumbnailRequests", "Lcom/otaliastudios/transcoder/thumbnail/ThumbnailRequest;", "listener", "Lcom/otaliastudios/transcoder/ThumbnailerListener;", "listenerHandler", "Landroid/os/Handler;", "(Ljava/util/List;Lcom/otaliastudios/transcoder/resize/Resizer;ILjava/util/List;Lcom/otaliastudios/transcoder/ThumbnailerListener;Landroid/os/Handler;)V", "getDataSources", "()Ljava/util/List;", "getListener", "()Lcom/otaliastudios/transcoder/ThumbnailerListener;", "getListenerHandler", "()Landroid/os/Handler;", "getResizer", "()Lcom/otaliastudios/transcoder/resize/Resizer;", "getRotation", "()I", "getThumbnailRequests", "Builder", "lib_release"})
public final class ThumbnailerOptions {
    @NotNull
    private final List<DataSource> dataSources;
    @NotNull
    private final Resizer resizer;
    private final int rotation;
    @NotNull
    private final List<ThumbnailRequest> thumbnailRequests;
    @NotNull
    private final ThumbnailerListener listener;
    @NotNull
    private final Handler listenerHandler;

    public ThumbnailerOptions(@NotNull List<? extends DataSource> dataSources, @NotNull Resizer resizer, int rotation, @NotNull List<? extends ThumbnailRequest> thumbnailRequests, @NotNull ThumbnailerListener listener, @NotNull Handler listenerHandler) {
        Intrinsics.checkNotNullParameter(dataSources, (String)"dataSources");
        Intrinsics.checkNotNullParameter((Object)resizer, (String)"resizer");
        Intrinsics.checkNotNullParameter(thumbnailRequests, (String)"thumbnailRequests");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)listenerHandler, (String)"listenerHandler");
        this.dataSources = dataSources;
        this.resizer = resizer;
        this.rotation = rotation;
        this.thumbnailRequests = thumbnailRequests;
        this.listener = listener;
        this.listenerHandler = listenerHandler;
    }

    @NotNull
    public final List<DataSource> getDataSources() {
        return this.dataSources;
    }

    @NotNull
    public final Resizer getResizer() {
        return this.resizer;
    }

    public final int getRotation() {
        return this.rotation;
    }

    @NotNull
    public final List<ThumbnailRequest> getThumbnailRequests() {
        return this.thumbnailRequests;
    }

    @NotNull
    public final ThumbnailerListener getListener() {
        return this.listener;
    }

    @NotNull
    public final Handler getListenerHandler() {
        return this.listenerHandler;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0011J\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010#\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/otaliastudios/transcoder/ThumbnailerOptions$Builder;", "", "()V", "dataSources", "", "Lcom/otaliastudios/transcoder/source/DataSource;", "listener", "Lcom/otaliastudios/transcoder/ThumbnailerListener;", "listenerHandler", "Landroid/os/Handler;", "resizer", "Lcom/otaliastudios/transcoder/resize/MultiResizer;", "resizerSet", "", "rotation", "", "thumbnailRequests", "Lcom/otaliastudios/transcoder/thumbnail/ThumbnailRequest;", "addDataSource", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "dataSource", "fileDescriptor", "Ljava/io/FileDescriptor;", "filePath", "", "addResizer", "Lcom/otaliastudios/transcoder/resize/Resizer;", "addThumbnailRequest", "request", "build", "Lcom/otaliastudios/transcoder/ThumbnailerOptions;", "setListener", "setListenerHandler", "setRotation", "thumbnails", "Ljava/util/concurrent/Future;", "Ljava/lang/Void;", "lib_release"})
    public static final class Builder {
        @NotNull
        private final List<DataSource> dataSources;
        @NotNull
        private final List<ThumbnailRequest> thumbnailRequests;
        @NotNull
        private final MultiResizer resizer;
        private boolean resizerSet;
        private int rotation;
        @Nullable
        private ThumbnailerListener listener;
        @Nullable
        private Handler listenerHandler;

        public Builder() {
            boolean bl = false;
            this.dataSources = new ArrayList();
            bl = false;
            this.thumbnailRequests = new ArrayList();
            this.resizer = new MultiResizer();
        }

        @NotNull
        public final Builder addDataSource(@NotNull DataSource dataSource) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder it = builder;
            boolean bl3 = false;
            this.dataSources.add(dataSource);
            return builder;
        }

        @NotNull
        public final Builder addDataSource(@NotNull FileDescriptor fileDescriptor) {
            Intrinsics.checkNotNullParameter((Object)fileDescriptor, (String)"fileDescriptor");
            return this.addDataSource(new FileDescriptorDataSource(fileDescriptor));
        }

        @NotNull
        public final Builder addDataSource(@NotNull String filePath) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            return this.addDataSource(new FilePathDataSource(filePath));
        }

        @NotNull
        public final Builder addDataSource(@NotNull Context context, @NotNull Uri uri) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            return this.addDataSource(new UriDataSource(context, uri));
        }

        @NotNull
        public final Builder addResizer(@NotNull Resizer resizer) {
            Intrinsics.checkNotNullParameter((Object)resizer, (String)"resizer");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder it = builder;
            boolean bl3 = false;
            this.resizer.addResizer(resizer);
            this.resizerSet = true;
            return builder;
        }

        @NotNull
        public final Builder setRotation(int rotation) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder it = builder;
            boolean bl3 = false;
            this.rotation = rotation;
            return builder;
        }

        @NotNull
        public final Builder addThumbnailRequest(@NotNull ThumbnailRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder it = builder;
            boolean bl3 = false;
            this.thumbnailRequests.add(request);
            return builder;
        }

        @NotNull
        public final Builder setListenerHandler(@Nullable Handler listenerHandler) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder it = builder;
            boolean bl3 = false;
            this.listenerHandler = listenerHandler;
            return builder;
        }

        @NotNull
        public final Builder setListener(@NotNull ThumbnailerListener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder it = builder;
            boolean bl3 = false;
            this.listener = listener;
            return builder;
        }

        @NotNull
        public final ThumbnailerOptions build() {
            Handler handler;
            Collection collection = this.dataSources;
            boolean bl = false;
            boolean bl2 = !collection.isEmpty();
            bl = false;
            boolean bl3 = false;
            if (!bl2) {
                boolean bl4 = false;
                String string = "At least one data source is required!";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Collection collection2 = this.thumbnailRequests;
            bl = false;
            boolean bl5 = !collection2.isEmpty();
            bl = false;
            bl3 = false;
            if (!bl5) {
                boolean bl6 = false;
                String string = "At least one thumbnail request is required!";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            ThumbnailerListener thumbnailerListener = this.listener;
            bl3 = false;
            boolean bl7 = false;
            if (thumbnailerListener == null) {
                boolean bl8 = false;
                String string = "Listener can't be null.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            ThumbnailerListener listener = thumbnailerListener;
            Handler handler2 = this.listenerHandler;
            if (handler2 == null) {
                Looper looper = Looper.myLooper();
                Looper looper2 = looper == null ? Looper.getMainLooper() : looper;
                handler = new Handler(looper2);
            } else {
                handler = handler2;
            }
            Handler listenerHandler = handler;
            Resizer resizer = this.resizerSet ? (Resizer)this.resizer : (Resizer)new ExactResizer(320, 240);
            return new ThumbnailerOptions(CollectionsKt.toList((Iterable)this.dataSources), resizer, this.rotation, CollectionsKt.toList((Iterable)this.thumbnailRequests), listener, listenerHandler);
        }

        @NotNull
        public final Future<Void> thumbnails() {
            return Thumbnailer.Companion.getInstance().thumbnails(this.build());
        }
    }
}

