/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.time;

import androidx.annotation.NonNull;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.TrackMap;
import com.otaliastudios.transcoder.internal.utils.TrackMapKt;
import com.otaliastudios.transcoder.time.TimeInterpolator;

public class SpeedTimeInterpolator
implements TimeInterpolator {
    private static final Logger LOG = new Logger("SpeedTimeInterpolator");
    private final double mFactor;
    private final TrackMap<TrackData> mTrackData = TrackMapKt.trackMapOf(new TrackData(), new TrackData());

    public SpeedTimeInterpolator(float factor) {
        if (factor <= 0.0f) {
            throw new IllegalArgumentException("Invalid speed factor: " + factor);
        }
        this.mFactor = factor;
    }

    public float getFactor() {
        return (float)this.mFactor;
    }

    @Override
    public long interpolate(@NonNull TrackType type, long time) {
        TrackData data2 = this.mTrackData.get(type);
        if (data2.lastRealTime == Long.MIN_VALUE) {
            data2.lastRealTime = time;
            data2.lastCorrectedTime = time;
        } else {
            long realDelta = time - data2.lastRealTime;
            long correctedDelta = (long)((double)realDelta / this.mFactor);
            data2.lastRealTime = time;
            TrackData trackData = data2;
            trackData.lastCorrectedTime = trackData.lastCorrectedTime + correctedDelta;
        }
        LOG.v("Track:" + (Object)((Object)type) + " inputTime:" + time + " outputTime:" + data2.lastCorrectedTime);
        return data2.lastCorrectedTime;
    }

    private static class TrackData {
        private long lastRealTime = Long.MIN_VALUE;
        private long lastCorrectedTime = Long.MIN_VALUE;

        private TrackData() {
        }
    }
}

