/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.source;

import android.media.MediaExtractor;
import android.media.MediaMetadataRetriever;
import androidx.annotation.NonNull;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.source.DefaultDataSource;
import com.otaliastudios.transcoder.source.FileDescriptorDataSource;
import java.io.FileInputStream;
import java.io.IOException;

public class FilePathDataSource
extends DefaultDataSource {
    private static final Logger LOG = new Logger("FilePathDataSource");
    private FileDescriptorDataSource mDescriptorSource;
    private FileInputStream mStream;
    private final String mPath;

    public FilePathDataSource(@NonNull String path) {
        this.mPath = path;
    }

    @Override
    public void initialize() {
        try {
            this.mStream = new FileInputStream(this.mPath);
            this.mDescriptorSource = new FileDescriptorDataSource(this.mStream.getFD());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.initialize();
    }

    @Override
    public void deinitialize() {
        this.mDescriptorSource.deinitialize();
        try {
            this.mStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.deinitialize();
    }

    @Override
    protected void initializeExtractor(@NonNull MediaExtractor extractor) throws IOException {
        this.mDescriptorSource.initializeExtractor(extractor);
    }

    @Override
    protected void initializeRetriever(@NonNull MediaMetadataRetriever retriever) {
        this.mDescriptorSource.initializeRetriever(retriever);
    }
}

