/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.video;

import android.graphics.Bitmap;
import android.media.MediaFormat;
import android.opengl.EGL14;
import android.opengl.GLES20;
import com.otaliastudios.opengl.core.EglCore;
import com.otaliastudios.opengl.core.Egloo;
import com.otaliastudios.opengl.surface.EglOffscreenSurface;
import com.otaliastudios.transcoder.internal.pipeline.BaseStep;
import com.otaliastudios.transcoder.internal.pipeline.Channel;
import com.otaliastudios.transcoder.internal.pipeline.State;
import com.otaliastudios.transcoder.internal.utils.Logger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B=\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001c\u001a\u00020\fH\u0016J$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/otaliastudios/transcoder/internal/video/VideoSnapshots;", "Lcom/otaliastudios/transcoder/internal/pipeline/BaseStep;", "", "Lcom/otaliastudios/transcoder/internal/pipeline/Channel;", "format", "Landroid/media/MediaFormat;", "requests", "", "accuracyUs", "onSnapshot", "Lkotlin/Function2;", "Landroid/graphics/Bitmap;", "", "(Landroid/media/MediaFormat;Ljava/util/List;JLkotlin/jvm/functions/Function2;)V", "channel", "Lcom/otaliastudios/transcoder/internal/pipeline/Channel$Companion;", "getChannel", "()Lcom/otaliastudios/transcoder/internal/pipeline/Channel$Companion;", "core", "Lcom/otaliastudios/opengl/core/EglCore;", "height", "", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "", "surface", "Lcom/otaliastudios/opengl/surface/EglOffscreenSurface;", "width", "release", "step", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "state", "Lcom/otaliastudios/transcoder/internal/pipeline/State$Ok;", "fresh", "", "lib_release"})
public final class VideoSnapshots
extends BaseStep<Long, Channel, Long, Channel> {
    private final Logger log;
    @NotNull
    private final Channel.Companion channel;
    private final List<Long> requests;
    private final int width;
    private final int height;
    private final EglCore core;
    private final EglOffscreenSurface surface;
    private final long accuracyUs;
    private final Function2<Long, Bitmap, Unit> onSnapshot;

    @Override
    @NotNull
    public Channel.Companion getChannel() {
        return this.channel;
    }

    @Override
    @NotNull
    public State<Long> step(@NotNull State.Ok<Long> state, boolean fresh) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        if (this.requests.isEmpty()) {
            return state;
        }
        long expectedUs = ((Number)CollectionsKt.first(this.requests)).longValue();
        long l = expectedUs - ((Number)state.getValue()).longValue();
        boolean bl = false;
        long deltaUs = Math.abs(l);
        if (deltaUs < this.accuracyUs || state instanceof State.Eos && expectedUs > ((Number)state.getValue()).longValue()) {
            this.log.i("Request MATCHED! expectedUs=" + expectedUs + " actualUs=" + ((Number)state.getValue()).longValue() + " deltaUs=" + deltaUs);
            CollectionsKt.removeFirst(this.requests);
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.width * this.height * 4);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            GLES20.glReadPixels((int)0, (int)0, (int)this.width, (int)this.height, (int)6408, (int)5121, (Buffer)buffer);
            Egloo.checkGlError((String)"glReadPixels");
            buffer.rewind();
            Bitmap bitmap = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)buffer);
            Long l2 = state.getValue();
            Bitmap bitmap2 = bitmap;
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
            this.onSnapshot.invoke((Object)l2, (Object)bitmap2);
        } else {
            this.log.v("Request has high delta. expectedUs=" + expectedUs + " actualUs=" + ((Number)state.getValue()).longValue() + " deltaUs=" + deltaUs);
        }
        return state;
    }

    @Override
    public void release() {
        this.surface.release();
        this.core.release();
    }

    /*
     * WARNING - void declaration
     */
    public VideoSnapshots(@NotNull MediaFormat format, @NotNull List<Long> requests, long accuracyUs, @NotNull Function2<? super Long, ? super Bitmap, Unit> onSnapshot) {
        void it;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter(requests, (String)"requests");
        Intrinsics.checkNotNullParameter(onSnapshot, (String)"onSnapshot");
        this.accuracyUs = accuracyUs;
        this.onSnapshot = onSnapshot;
        this.log = new Logger("VideoSnapshots");
        this.channel = Channel.Companion;
        this.requests = CollectionsKt.toMutableList((Collection)requests);
        this.width = format.getInteger("width");
        this.height = format.getInteger("height");
        this.core = new EglCore(EGL14.EGL_NO_CONTEXT, 1);
        EglOffscreenSurface eglOffscreenSurface = new EglOffscreenSurface(this.core, this.width, this.height);
        boolean bl = false;
        boolean bl2 = false;
        EglOffscreenSurface eglOffscreenSurface2 = eglOffscreenSurface;
        VideoSnapshots videoSnapshots = this;
        boolean bl3 = false;
        it.makeCurrent();
        Unit unit = Unit.INSTANCE;
        videoSnapshots.surface = eglOffscreenSurface;
    }
}

