/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.video;

import android.graphics.SurfaceTexture;
import android.opengl.Matrix;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import com.otaliastudios.opengl.draw.GlDrawable;
import com.otaliastudios.opengl.draw.GlRect;
import com.otaliastudios.opengl.program.GlTextureProgram;
import com.otaliastudios.opengl.texture.GlTexture;
import com.otaliastudios.transcoder.internal.utils.Logger;

class FrameDrawer {
    private static final Logger LOG = new Logger("FrameDrawer");
    private static final long NEW_IMAGE_TIMEOUT_MILLIS = 10000L;
    private SurfaceTexture mSurfaceTexture;
    private Surface mSurface;
    private GlTextureProgram mProgram;
    private GlRect mDrawable;
    private float mScaleX = 1.0f;
    private float mScaleY = 1.0f;
    private int mRotation = 0;
    private boolean mFlipY = false;
    @GuardedBy(value="mFrameAvailableLock")
    private boolean mFrameAvailable;
    private final Object mFrameAvailableLock = new Object();

    public FrameDrawer() {
        GlTexture texture = new GlTexture();
        this.mProgram = new GlTextureProgram();
        this.mProgram.setTexture(texture);
        this.mDrawable = new GlRect();
        this.mSurfaceTexture = new SurfaceTexture(texture.getId());
        this.mSurfaceTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                LOG.v("New frame available");
                Object object = FrameDrawer.this.mFrameAvailableLock;
                synchronized (object) {
                    if (FrameDrawer.this.mFrameAvailable) {
                        throw new RuntimeException("mFrameAvailable already set, frame could be dropped");
                    }
                    FrameDrawer.this.mFrameAvailable = true;
                    FrameDrawer.this.mFrameAvailableLock.notifyAll();
                }
            }
        });
        this.mSurface = new Surface(this.mSurfaceTexture);
    }

    public void setScale(float scaleX, float scaleY) {
        this.mScaleX = scaleX;
        this.mScaleY = scaleY;
    }

    public void setRotation(int rotation) {
        this.mRotation = rotation;
    }

    public void setFlipY(boolean flipY) {
        this.mFlipY = flipY;
    }

    @NonNull
    public Surface getSurface() {
        return this.mSurface;
    }

    public void release() {
        this.mProgram.release();
        this.mSurface.release();
        this.mSurface = null;
        this.mSurfaceTexture = null;
        this.mDrawable = null;
        this.mProgram = null;
    }

    public void drawFrame() {
        this.awaitNewFrame();
        this.drawNewFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitNewFrame() {
        Object object = this.mFrameAvailableLock;
        synchronized (object) {
            while (!this.mFrameAvailable) {
                try {
                    this.mFrameAvailableLock.wait(10000L);
                    if (this.mFrameAvailable) continue;
                    throw new RuntimeException("Surface frame wait timed out");
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
            }
            this.mFrameAvailable = false;
        }
        this.mSurfaceTexture.updateTexImage();
    }

    private void drawNewFrame() {
        this.mSurfaceTexture.getTransformMatrix(this.mProgram.getTextureTransform());
        float glScaleX = 1.0f / this.mScaleX;
        float glScaleY = 1.0f / this.mScaleY;
        float glTranslX = (1.0f - glScaleX) / 2.0f;
        float glTranslY = (1.0f - glScaleY) / 2.0f;
        Matrix.translateM((float[])this.mProgram.getTextureTransform(), (int)0, (float)glTranslX, (float)glTranslY, (float)0.0f);
        Matrix.scaleM((float[])this.mProgram.getTextureTransform(), (int)0, (float)glScaleX, (float)glScaleY, (float)1.0f);
        Matrix.translateM((float[])this.mProgram.getTextureTransform(), (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
        Matrix.rotateM((float[])this.mProgram.getTextureTransform(), (int)0, (float)this.mRotation, (float)0.0f, (float)0.0f, (float)1.0f);
        if (this.mFlipY) {
            Matrix.scaleM((float[])this.mProgram.getTextureTransform(), (int)0, (float)1.0f, (float)-1.0f, (float)1.0f);
        }
        Matrix.translateM((float[])this.mProgram.getTextureTransform(), (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
        this.mProgram.draw((GlDrawable)this.mDrawable);
    }
}

