/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.utils;

import android.media.MediaCodec;
import android.media.MediaFormat;
import androidx.annotation.NonNull;
import com.otaliastudios.transcoder.common.TrackStatus;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.sink.DataSink;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\t\u0010\t\u001a\u00020\nH\u0096\u0001J\u0019\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0096\u0001J\u0011\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0001J\u001d\u0010\u0012\u001a\u00020\n2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0096\u0001J\u001d\u0010\u0017\u001a\u00020\n2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0096\u0001J\t\u0010\u001a\u001a\u00020\nH\u0096\u0001J \u0010\u001b\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/otaliastudios/transcoder/internal/utils/EosIgnoringDataSink;", "Lcom/otaliastudios/transcoder/sink/DataSink;", "sink", "ignore", "Lkotlin/Function0;", "", "(Lcom/otaliastudios/transcoder/sink/DataSink;Lkotlin/jvm/functions/Function0;)V", "info", "Landroid/media/MediaCodec$BufferInfo;", "release", "", "setLocation", "latitude", "", "longitude", "setOrientation", "orientation", "", "setTrackFormat", "type", "Lcom/otaliastudios/transcoder/common/TrackType;", "format", "Landroid/media/MediaFormat;", "setTrackStatus", "status", "Lcom/otaliastudios/transcoder/common/TrackStatus;", "stop", "writeTrack", "byteBuffer", "Ljava/nio/ByteBuffer;", "bufferInfo", "lib_release"})
final class EosIgnoringDataSink
implements DataSink {
    private final MediaCodec.BufferInfo info;
    private final DataSink sink;
    private final Function0<Boolean> ignore;

    @Override
    public void writeTrack(@NotNull TrackType type, @NotNull ByteBuffer byteBuffer, @NotNull MediaCodec.BufferInfo bufferInfo) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        Intrinsics.checkNotNullParameter((Object)bufferInfo, (String)"bufferInfo");
        if (((Boolean)this.ignore.invoke()).booleanValue()) {
            int flags = bufferInfo.flags & ~4;
            if (bufferInfo.size > 0 || flags != 0) {
                this.info.set(bufferInfo.offset, bufferInfo.size, bufferInfo.presentationTimeUs, flags);
                this.sink.writeTrack(type, byteBuffer, this.info);
            }
        } else {
            this.sink.writeTrack(type, byteBuffer, bufferInfo);
        }
    }

    public EosIgnoringDataSink(@NotNull DataSink sink2, @NotNull Function0<Boolean> ignore) {
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Intrinsics.checkNotNullParameter(ignore, (String)"ignore");
        this.sink = sink2;
        this.ignore = ignore;
        this.info = new MediaCodec.BufferInfo();
    }

    @Override
    public void release() {
        this.sink.release();
    }

    @Override
    public void setLocation(double latitude, double longitude) {
        this.sink.setLocation(latitude, longitude);
    }

    @Override
    public void setOrientation(int orientation) {
        this.sink.setOrientation(orientation);
    }

    @Override
    public void setTrackFormat(@NonNull @NotNull TrackType type, @NonNull @NotNull MediaFormat format) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.sink.setTrackFormat(type, format);
    }

    @Override
    public void setTrackStatus(@NonNull @NotNull TrackType type, @NonNull @NotNull TrackStatus status) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        this.sink.setTrackStatus(type, status);
    }

    @Override
    public void stop() {
        this.sink.stop();
    }
}

