/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.transcode;

import com.otaliastudios.transcoder.TranscoderOptions;
import com.otaliastudios.transcoder.internal.DataSources;
import com.otaliastudios.transcoder.internal.transcode.DefaultTranscodeEngine;
import com.otaliastudios.transcoder.internal.transcode.TranscodeDispatcher;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.TrackMap;
import com.otaliastudios.transcoder.internal.utils.TrackMapKt;
import com.otaliastudios.transcoder.resample.AudioResampler;
import com.otaliastudios.transcoder.sink.DataSink;
import com.otaliastudios.transcoder.strategy.TrackStrategy;
import com.otaliastudios.transcoder.stretch.AudioStretcher;
import com.otaliastudios.transcoder.time.TimeInterpolator;
import com.otaliastudios.transcoder.validator.Validator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b \u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&J\u001c\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u0007H&J\b\u0010\t\u001a\u00020\nH&\u00a8\u0006\f"}, d2={"Lcom/otaliastudios/transcoder/internal/transcode/TranscodeEngine;", "", "()V", "cleanup", "", "transcode", "progress", "Lkotlin/Function1;", "", "validate", "", "Companion", "lib_release"})
public abstract class TranscodeEngine {
    private static final Logger log;
    @NotNull
    public static final Companion Companion;

    public abstract boolean validate();

    public abstract void transcode(@NotNull Function1<? super Double, Unit> var1);

    public abstract void cleanup();

    static {
        Companion = new Companion(null);
        log = new Logger("TranscodeEngine");
    }

    @JvmStatic
    public static final void transcode(@NotNull TranscoderOptions options) {
        Companion.transcode(options);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/otaliastudios/transcoder/internal/transcode/TranscodeEngine$Companion;", "", "()V", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "transcode", "", "options", "Lcom/otaliastudios/transcoder/TranscoderOptions;", "isInterrupted", "", "", "lib_release"})
    public static final class Companion {
        private final boolean isInterrupted(Throwable $this$isInterrupted) {
            if ($this$isInterrupted instanceof InterruptedException) {
                return true;
            }
            if (Intrinsics.areEqual((Object)$this$isInterrupted, (Object)$this$isInterrupted.getCause())) {
                return false;
            }
            Throwable throwable = $this$isInterrupted.getCause();
            return throwable != null ? this.isInterrupted(throwable) : false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void transcode(@NotNull TranscoderOptions options) {
            block9: {
                Intrinsics.checkNotNullParameter((Object)options, (String)"options");
                log.i("transcode(): called...");
                TranscodeEngine engine = null;
                TranscodeDispatcher dispatcher = new TranscodeDispatcher(options);
                try {
                    DataSources dataSources = new DataSources(options);
                    DataSink dataSink = options.getDataSink();
                    Intrinsics.checkNotNullExpressionValue((Object)dataSink, (String)"options.dataSink");
                    TrackMap<TrackStrategy> trackMap = TrackMapKt.trackMapOf(options.getVideoTrackStrategy(), options.getAudioTrackStrategy());
                    Validator validator = options.getValidator();
                    Intrinsics.checkNotNullExpressionValue((Object)validator, (String)"options.validator");
                    int n = options.getVideoRotation();
                    TimeInterpolator timeInterpolator = options.getTimeInterpolator();
                    Intrinsics.checkNotNullExpressionValue((Object)timeInterpolator, (String)"options.timeInterpolator");
                    AudioStretcher audioStretcher = options.getAudioStretcher();
                    Intrinsics.checkNotNullExpressionValue((Object)audioStretcher, (String)"options.audioStretcher");
                    AudioResampler audioResampler = options.getAudioResampler();
                    Intrinsics.checkNotNullExpressionValue((Object)audioResampler, (String)"options.audioResampler");
                    AudioResampler audioResampler2 = audioResampler;
                    AudioStretcher audioStretcher2 = audioStretcher;
                    TimeInterpolator timeInterpolator2 = timeInterpolator;
                    engine = new DefaultTranscodeEngine(dataSources, dataSink, trackMap, validator, n, audioStretcher2, audioResampler2, timeInterpolator2);
                    if (!engine.validate()) {
                        dispatcher.dispatchSuccess(1);
                    } else {
                        engine.transcode((Function1<? super Double, Unit>)((Function1)new Function1<Double, Unit>(dispatcher){
                            final /* synthetic */ TranscodeDispatcher $dispatcher;

                            public final void invoke(double it) {
                                this.$dispatcher.dispatchProgress(it);
                            }
                            {
                                this.$dispatcher = transcodeDispatcher;
                                super(1);
                            }
                        }));
                        dispatcher.dispatchSuccess(0);
                    }
                    engine.cleanup();
                }
                catch (Exception e) {
                    if (this.isInterrupted(e)) {
                        log.i("Transcode canceled.", e);
                        dispatcher.dispatchCancel();
                        break block9;
                    }
                    log.e("Unexpected error while transcoding.", e);
                    dispatcher.dispatchFailure(e);
                    throw (Throwable)e;
                }
                finally {
                    TranscodeEngine transcodeEngine = engine;
                    if (transcodeEngine != null) {
                        transcodeEngine.cleanup();
                    }
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

