/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.data;

import android.media.MediaCodec;
import android.media.MediaFormat;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.data.WriterChannel;
import com.otaliastudios.transcoder.internal.data.WriterData;
import com.otaliastudios.transcoder.internal.pipeline.Channel;
import com.otaliastudios.transcoder.internal.pipeline.State;
import com.otaliastudios.transcoder.internal.pipeline.Step;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.sink.DataSink;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00012\u00020\u0003B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u000b\u001a\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/otaliastudios/transcoder/internal/data/Writer;", "Lcom/otaliastudios/transcoder/internal/pipeline/Step;", "Lcom/otaliastudios/transcoder/internal/data/WriterData;", "Lcom/otaliastudios/transcoder/internal/data/WriterChannel;", "", "Lcom/otaliastudios/transcoder/internal/pipeline/Channel;", "sink", "Lcom/otaliastudios/transcoder/sink/DataSink;", "track", "Lcom/otaliastudios/transcoder/common/TrackType;", "(Lcom/otaliastudios/transcoder/sink/DataSink;Lcom/otaliastudios/transcoder/common/TrackType;)V", "channel", "getChannel", "()Lcom/otaliastudios/transcoder/internal/data/Writer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "handleFormat", "format", "Landroid/media/MediaFormat;", "step", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "state", "Lcom/otaliastudios/transcoder/internal/pipeline/State$Ok;", "fresh", "", "lib_release"})
public final class Writer
implements Step<WriterData, WriterChannel, Unit, Channel>,
WriterChannel {
    @NotNull
    private final Writer channel;
    private final Logger log;
    private final MediaCodec.BufferInfo info;
    private final DataSink sink;
    private final TrackType track;

    @Override
    @NotNull
    public Writer getChannel() {
        return this.channel;
    }

    @Override
    public void handleFormat(@NotNull MediaFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.log.i("handleFormat(" + format + ')');
        this.sink.setTrackFormat(this.track, format);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public State<Unit> step(@NotNull State.Ok<WriterData> state, boolean fresh) {
        void timestamp;
        void buffer;
        Intrinsics.checkNotNullParameter(state, (String)"state");
        WriterData writerData = state.getValue();
        ByteBuffer byteBuffer = writerData.component1();
        long l = writerData.component2();
        int flags = writerData.component3();
        boolean eos = state instanceof State.Eos;
        this.info.set(buffer.position(), buffer.remaining(), (long)timestamp, eos ? flags & 4 : flags);
        this.sink.writeTrack(this.track, (ByteBuffer)buffer, this.info);
        state.getValue().getRelease().invoke();
        return eos ? (State)new State.Eos<Unit>(Unit.INSTANCE) : (State)new State.Ok<Unit>(Unit.INSTANCE);
    }

    public Writer(@NotNull DataSink sink2, @NotNull TrackType track) {
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)((Object)track), (String)"track");
        this.sink = sink2;
        this.track = track;
        this.channel = this;
        this.log = new Logger("Writer");
        this.info = new MediaCodec.BufferInfo();
    }

    @Override
    public void initialize(@NotNull Channel next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        Step.DefaultImpls.initialize(this, next);
    }

    @Override
    public void release() {
        Step.DefaultImpls.release(this);
    }
}

