/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.data;

import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.data.ReaderChannel;
import com.otaliastudios.transcoder.internal.data.ReaderData;
import com.otaliastudios.transcoder.internal.pipeline.BaseStep;
import com.otaliastudios.transcoder.internal.pipeline.Channel;
import com.otaliastudios.transcoder.internal.pipeline.State;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.source.DataSource;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0001B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ/\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\u001e\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00140\u0016H\u0082\bJ$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/otaliastudios/transcoder/internal/data/Reader;", "Lcom/otaliastudios/transcoder/internal/pipeline/BaseStep;", "", "Lcom/otaliastudios/transcoder/internal/pipeline/Channel;", "Lcom/otaliastudios/transcoder/internal/data/ReaderData;", "Lcom/otaliastudios/transcoder/internal/data/ReaderChannel;", "source", "Lcom/otaliastudios/transcoder/source/DataSource;", "track", "Lcom/otaliastudios/transcoder/common/TrackType;", "(Lcom/otaliastudios/transcoder/source/DataSource;Lcom/otaliastudios/transcoder/common/TrackType;)V", "channel", "Lcom/otaliastudios/transcoder/internal/pipeline/Channel$Companion;", "getChannel", "()Lcom/otaliastudios/transcoder/internal/pipeline/Channel$Companion;", "chunk", "Lcom/otaliastudios/transcoder/source/DataSource$Chunk;", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "nextBufferOrWait", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "action", "Lkotlin/Function2;", "Ljava/nio/ByteBuffer;", "", "step", "state", "Lcom/otaliastudios/transcoder/internal/pipeline/State$Ok;", "fresh", "", "lib_release"})
public final class Reader
extends BaseStep<Unit, Channel, ReaderData, ReaderChannel> {
    private final Logger log;
    @NotNull
    private final Channel.Companion channel;
    private final DataSource.Chunk chunk;
    private final DataSource source;
    private final TrackType track;

    @Override
    @NotNull
    public Channel.Companion getChannel() {
        return this.channel;
    }

    private final State<ReaderData> nextBufferOrWait(Function2<? super ByteBuffer, ? super Integer, ? extends State<ReaderData>> action) {
        int $i$f$nextBufferOrWait = 0;
        Pair<ByteBuffer, Integer> buffer = Reader.access$getNext$p(this).buffer();
        if (buffer == null) {
            this.log.v("Returning State.Wait because buffer is null.");
            return State.Wait.INSTANCE;
        }
        return (State)action.invoke(buffer.getFirst(), buffer.getSecond());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public State<ReaderData> step(@NotNull State.Ok<Unit> state, boolean fresh) {
        State state2;
        Intrinsics.checkNotNullParameter(state, (String)"state");
        if (this.source.isDrained()) {
            this.log.i("Source is drained! Returning Eos as soon as possible.");
            Reader this_$iv = this;
            boolean $i$f$nextBufferOrWait = false;
            Pair<ByteBuffer, Integer> buffer$iv = Reader.access$getNext$p(this_$iv).buffer();
            if (buffer$iv == null) {
                this_$iv.log.v("Returning State.Wait because buffer is null.");
                state2 = State.Wait.INSTANCE;
            } else {
                void id;
                int n = ((Number)buffer$iv.getSecond()).intValue();
                ByteBuffer byteBuffer = (ByteBuffer)buffer$iv.getFirst();
                boolean bl = false;
                byteBuffer.limit(0);
                this.chunk.buffer = byteBuffer;
                this.chunk.keyframe = false;
                this.chunk.render = true;
                state2 = new State.Eos<ReaderData>(new ReaderData(this.chunk, (int)id));
            }
        } else if (!this.source.canReadTrack(this.track)) {
            this.log.i("Returning State.Wait because source can't read " + (Object)((Object)this.track) + " right now.");
            state2 = State.Wait.INSTANCE;
        } else {
            Reader this_$iv = this;
            boolean $i$f$nextBufferOrWait = false;
            Pair<ByteBuffer, Integer> buffer$iv = Reader.access$getNext$p(this_$iv).buffer();
            if (buffer$iv == null) {
                this_$iv.log.v("Returning State.Wait because buffer is null.");
                state2 = State.Wait.INSTANCE;
            } else {
                int id = ((Number)buffer$iv.getSecond()).intValue();
                ByteBuffer byteBuffer = (ByteBuffer)buffer$iv.getFirst();
                boolean bl = false;
                this.chunk.buffer = byteBuffer;
                this.source.readTrack(this.chunk);
                state2 = new State.Ok<ReaderData>(new ReaderData(this.chunk, id));
            }
        }
        return state2;
    }

    public Reader(@NotNull DataSource source2, @NotNull TrackType track) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)((Object)track), (String)"track");
        this.source = source2;
        this.track = track;
        this.log = new Logger("Reader");
        this.channel = Channel.Companion;
        this.chunk = new DataSource.Chunk();
    }

    public static final /* synthetic */ ReaderChannel access$getNext$p(Reader $this) {
        return (ReaderChannel)$this.getNext();
    }
}

