/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.codec;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import com.otaliastudios.transcoder.common.TrackTypeKt;
import com.otaliastudios.transcoder.internal.codec.DecoderChannel;
import com.otaliastudios.transcoder.internal.codec.DecoderData;
import com.otaliastudios.transcoder.internal.codec.DecoderDropper;
import com.otaliastudios.transcoder.internal.data.ReaderChannel;
import com.otaliastudios.transcoder.internal.data.ReaderData;
import com.otaliastudios.transcoder.internal.media.MediaCodecBuffers;
import com.otaliastudios.transcoder.internal.pipeline.Channel;
import com.otaliastudios.transcoder.internal.pipeline.QueuedStep;
import com.otaliastudios.transcoder.internal.pipeline.State;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.TrackMap;
import com.otaliastudios.transcoder.internal.utils.TrackMapKt;
import com.otaliastudios.transcoder.source.DataSource;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u0000 62\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00012\u00020\u0003:\u00016B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010)\u001a\u0010\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u0017\u0018\u00010*H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040-H\u0014J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0002H\u0014J\u0010\u00101\u001a\u00020/2\u0006\u00100\u001a\u00020\u0002H\u0014J\u0010\u00102\u001a\u00020/2\u0006\u00103\u001a\u00020\u0005H\u0016J\b\u00104\u001a\u00020/H\u0002J\b\u00105\u001a\u00020/H\u0016R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00178B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR+\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00178B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\"\u0010\u001e\u001a\u0004\b \u0010\u001a\"\u0004\b!\u0010\u001cR\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/otaliastudios/transcoder/internal/codec/Decoder;", "Lcom/otaliastudios/transcoder/internal/pipeline/QueuedStep;", "Lcom/otaliastudios/transcoder/internal/data/ReaderData;", "Lcom/otaliastudios/transcoder/internal/data/ReaderChannel;", "Lcom/otaliastudios/transcoder/internal/codec/DecoderData;", "Lcom/otaliastudios/transcoder/internal/codec/DecoderChannel;", "format", "Landroid/media/MediaFormat;", "continuous", "", "(Landroid/media/MediaFormat;Z)V", "buffers", "Lcom/otaliastudios/transcoder/internal/media/MediaCodecBuffers;", "getBuffers", "()Lcom/otaliastudios/transcoder/internal/media/MediaCodecBuffers;", "buffers$delegate", "Lkotlin/Lazy;", "channel", "getChannel", "()Lcom/otaliastudios/transcoder/internal/codec/Decoder;", "codec", "Landroid/media/MediaCodec;", "<set-?>", "", "dequeuedInputs", "getDequeuedInputs", "()I", "setDequeuedInputs", "(I)V", "dequeuedInputs$delegate", "Lkotlin/properties/ReadWriteProperty;", "dequeuedOutputs", "getDequeuedOutputs", "setDequeuedOutputs", "dequeuedOutputs$delegate", "dropper", "Lcom/otaliastudios/transcoder/internal/codec/DecoderDropper;", "info", "Landroid/media/MediaCodec$BufferInfo;", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "buffer", "Lkotlin/Pair;", "Ljava/nio/ByteBuffer;", "drain", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "enqueue", "", "data", "enqueueEos", "initialize", "next", "printDequeued", "release", "Companion", "lib_release"})
public final class Decoder
extends QueuedStep<ReaderData, ReaderChannel, DecoderData, DecoderChannel>
implements ReaderChannel {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Logger log;
    @NotNull
    private final Decoder channel;
    private final MediaCodec codec;
    private final Lazy buffers$delegate;
    private MediaCodec.BufferInfo info;
    private final DecoderDropper dropper;
    private final ReadWriteProperty dequeuedInputs$delegate;
    private final ReadWriteProperty dequeuedOutputs$delegate;
    private final MediaFormat format;
    private static final TrackMap<AtomicInteger> ID;
    @NotNull
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(Decoder.class, "dequeuedInputs", "getDequeuedInputs()I", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(Decoder.class, "dequeuedOutputs", "getDequeuedOutputs()I", 0))};
        Companion = new Companion(null);
        ID = TrackMapKt.trackMapOf(new AtomicInteger(0), new AtomicInteger(0));
    }

    @Override
    @NotNull
    public Decoder getChannel() {
        return this.channel;
    }

    private final MediaCodecBuffers getBuffers() {
        Lazy lazy = this.buffers$delegate;
        Decoder decoder = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MediaCodecBuffers)lazy.getValue();
    }

    private final int getDequeuedInputs() {
        return ((Number)this.dequeuedInputs$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    private final void setDequeuedInputs(int n) {
        this.dequeuedInputs$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
    }

    private final int getDequeuedOutputs() {
        return ((Number)this.dequeuedOutputs$delegate.getValue((Object)this, $$delegatedProperties[1])).intValue();
    }

    private final void setDequeuedOutputs(int n) {
        this.dequeuedOutputs$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)n);
    }

    private final void printDequeued() {
    }

    @Override
    public void initialize(@NotNull DecoderChannel next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        super.initialize((Channel)next);
        this.log.i("initialize()");
        Surface surface = next.handleSourceFormat(this.format);
        this.codec.configure(this.format, surface, null, 0);
        this.codec.start();
    }

    @Override
    @Nullable
    public Pair<ByteBuffer, Integer> buffer() {
        Pair pair;
        int id = this.codec.dequeueInputBuffer(0L);
        if (id >= 0) {
            Decoder decoder = this;
            int n = decoder.getDequeuedInputs();
            decoder.setDequeuedInputs(n + 1);
            pair = TuplesKt.to((Object)this.getBuffers().getInputBuffer(id), (Object)id);
        } else {
            this.log.i("buffer() failed. dequeuedInputs=" + this.getDequeuedInputs() + " dequeuedOutputs=" + this.getDequeuedOutputs());
            pair = null;
        }
        return pair;
    }

    @Override
    protected void enqueueEos(@NotNull ReaderData data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.log.i("enqueueEos()!");
        Decoder decoder = this;
        int n = decoder.getDequeuedInputs();
        decoder.setDequeuedInputs(n + -1);
        int flag = 4;
        this.codec.queueInputBuffer(data2.getId(), 0, 0, 0L, flag);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void enqueue(@NotNull ReaderData data2) {
        void chunk;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Decoder decoder = this;
        int n = decoder.getDequeuedInputs();
        decoder.setDequeuedInputs(n + -1);
        ReaderData readerData = data2;
        DataSource.Chunk chunk2 = readerData.component1();
        int id = readerData.component2();
        int flag = chunk.keyframe ? 1 : 0;
        this.codec.queueInputBuffer(id, chunk.buffer.position(), chunk.buffer.remaining(), chunk.timeUs, flag);
        this.dropper.input(chunk.timeUs, chunk.render);
    }

    @Override
    @NotNull
    protected State<DecoderData> drain() {
        State state;
        int result2 = this.codec.dequeueOutputBuffer(this.info, 0L);
        switch (result2) {
            case -1: {
                this.log.i("drain(): got INFO_TRY_AGAIN_LATER, waiting.");
                state = State.Wait.INSTANCE;
                break;
            }
            case -2: {
                this.log.i("drain(): got INFO_OUTPUT_FORMAT_CHANGED, handling format and retrying. format=" + this.codec.getOutputFormat());
                DecoderChannel decoderChannel = (DecoderChannel)this.getNext();
                MediaFormat mediaFormat = this.codec.getOutputFormat();
                Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"codec.outputFormat");
                decoderChannel.handleRawFormat(mediaFormat);
                state = State.Retry.INSTANCE;
                break;
            }
            case -3: {
                this.log.i("drain(): got INFO_OUTPUT_BUFFERS_CHANGED, retrying.");
                this.getBuffers().onOutputBuffersChanged();
                state = State.Retry.INSTANCE;
                break;
            }
            default: {
                State state2;
                Long timeUs;
                boolean isEos = (this.info.flags & 4) != 0;
                Long l = timeUs = isEos ? Long.valueOf(0L) : this.dropper.output(this.info.presentationTimeUs);
                if (timeUs != null) {
                    Decoder decoder = this;
                    int n = decoder.getDequeuedOutputs();
                    decoder.setDequeuedOutputs(n + 1);
                    ByteBuffer byteBuffer = this.getBuffers().getOutputBuffer(result2);
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffers.getOutputBuffer(result)");
                    ByteBuffer buffer = byteBuffer;
                    DecoderData data2 = new DecoderData(buffer, timeUs, (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(this, result2){
                        final /* synthetic */ Decoder this$0;
                        final /* synthetic */ int $result;

                        public final void invoke(boolean it) {
                            Decoder.access$getCodec$p(this.this$0).releaseOutputBuffer(this.$result, it);
                            Decoder decoder = this.this$0;
                            int n = Decoder.access$getDequeuedOutputs$p(decoder);
                            Decoder.access$setDequeuedOutputs$p(decoder, n + -1);
                        }
                        {
                            this.this$0 = decoder;
                            this.$result = n;
                            super(1);
                        }
                    }));
                    state2 = isEos ? (State.Ok)new State.Eos<DecoderData>(data2) : new State.Ok(data2);
                } else {
                    this.codec.releaseOutputBuffer(result2, false);
                    state2 = State.Wait.INSTANCE;
                }
                State state3 = state2;
                boolean bl = false;
                boolean bl2 = false;
                State it = state3;
                boolean bl3 = false;
                this.log.v("drain(): returning " + it);
                state = state3;
            }
        }
        return state;
    }

    @Override
    public void release() {
        this.log.i("release(): releasing codec. dequeuedInputs=" + this.getDequeuedInputs() + " dequeuedOutputs=" + this.getDequeuedOutputs());
        this.codec.stop();
        this.codec.release();
    }

    public Decoder(@NotNull MediaFormat format, boolean continuous) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.format = format;
        this.log = new Logger("Decoder(" + (Object)((Object)TrackTypeKt.getTrackType(this.format)) + ',' + ID.get(TrackTypeKt.getTrackType(this.format)).getAndIncrement() + ')');
        this.channel = this;
        String string = this.format.getString("mime");
        Intrinsics.checkNotNull((Object)string);
        MediaCodec mediaCodec = MediaCodec.createDecoderByType((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)mediaCodec, (String)"createDecoderByType(form\u2026(MediaFormat.KEY_MIME)!!)");
        this.codec = mediaCodec;
        this.buffers$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MediaCodecBuffers>(this){
            final /* synthetic */ Decoder this$0;

            @NotNull
            public final MediaCodecBuffers invoke() {
                return new MediaCodecBuffers(Decoder.access$getCodec$p(this.this$0));
            }
            {
                this.this$0 = decoder;
                super(0);
            }
        }));
        this.info = new MediaCodec.BufferInfo();
        this.dropper = new DecoderDropper(continuous);
        Delegates delegates = Delegates.INSTANCE;
        Integer initialValue$iv = 0;
        boolean $i$f$observable = false;
        this.dequeuedInputs$delegate = (ReadWriteProperty)new ObservableProperty<Integer>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ Decoder this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = decoder;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                int n = ((Number)newValue).intValue();
                int n2 = ((Number)oldValue).intValue();
                KProperty $noName_0 = property;
                boolean bl = false;
                Decoder.access$printDequeued(this.this$0);
            }
        };
        Delegates this_$iv = Delegates.INSTANCE;
        initialValue$iv = 0;
        $i$f$observable = false;
        this.dequeuedOutputs$delegate = (ReadWriteProperty)new ObservableProperty<Integer>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ Decoder this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = decoder;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                int n = ((Number)newValue).intValue();
                int n2 = ((Number)oldValue).intValue();
                KProperty $noName_0 = property;
                boolean bl = false;
                Decoder.access$printDequeued(this.this$0);
            }
        };
    }

    public static final /* synthetic */ MediaCodec access$getCodec$p(Decoder $this) {
        return $this.codec;
    }

    public static final /* synthetic */ int access$getDequeuedOutputs$p(Decoder $this) {
        return $this.getDequeuedOutputs();
    }

    public static final /* synthetic */ void access$setDequeuedOutputs$p(Decoder $this, int n) {
        $this.setDequeuedOutputs(n);
    }

    public static final /* synthetic */ void access$printDequeued(Decoder $this) {
        $this.printDequeued();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/otaliastudios/transcoder/internal/codec/Decoder$Companion;", "", "()V", "ID", "Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "Ljava/util/concurrent/atomic/AtomicInteger;", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

