/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal;

import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.DataSources;
import com.otaliastudios.transcoder.internal.Tracks;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.TrackMap;
import com.otaliastudios.transcoder.source.DataSource;
import com.otaliastudios.transcoder.time.TimeInterpolator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\nJ%\u0010 \u001a\u0004\u0018\u00010\r2\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\r\u00a2\u0006\u0002\u0010!J\u001a\u0010\f\u001a\u00020\r*\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\b\u001a\u00020\nH\u0002J\u001a\u0010\u0016\u001a\u00020\r*\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\b\u001a\u00020\nH\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0010\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n0\u0012\u0012\u0004\u0012\u00020\u00030\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/otaliastudios/transcoder/internal/Timer;", "", "interpolator", "Lcom/otaliastudios/transcoder/time/TimeInterpolator;", "sources", "Lcom/otaliastudios/transcoder/internal/DataSources;", "tracks", "Lcom/otaliastudios/transcoder/internal/Tracks;", "current", "Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "", "(Lcom/otaliastudios/transcoder/time/TimeInterpolator;Lcom/otaliastudios/transcoder/internal/DataSources;Lcom/otaliastudios/transcoder/internal/Tracks;Lcom/otaliastudios/transcoder/internal/utils/TrackMap;)V", "durationUs", "", "getDurationUs", "()Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "interpolators", "", "Lkotlin/Pair;", "Lcom/otaliastudios/transcoder/common/TrackType;", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "positionUs", "getPositionUs", "progress", "", "getProgress", "totalDurationUs", "getTotalDurationUs", "()J", "type", "index", "localize", "(Lcom/otaliastudios/transcoder/common/TrackType;IJ)Ljava/lang/Long;", "", "Lcom/otaliastudios/transcoder/source/DataSource;", "lib_release"})
public final class Timer {
    private final Logger log;
    @NotNull
    private final TrackMap<Long> positionUs;
    @NotNull
    private final TrackMap<Long> durationUs;
    @NotNull
    private final TrackMap<Double> progress;
    private final Map<Pair<TrackType, Integer>, TimeInterpolator> interpolators;
    private final TimeInterpolator interpolator;
    private final DataSources sources;
    private final Tracks tracks;
    private final TrackMap<Integer> current;

    /*
     * WARNING - void declaration
     */
    private final long durationUs(List<? extends DataSource> $this$durationUs, int current) {
        void $this$foldIndexed$iv;
        Iterable iterable = $this$durationUs;
        long initial$iv = 0L;
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        long accumulator$iv = initial$iv;
        for (Object element$iv : $this$foldIndexed$iv) {
            void source2;
            void acc;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DataSource dataSource = (DataSource)element$iv;
            long l = accumulator$iv;
            int index = n;
            boolean bl2 = false;
            accumulator$iv = acc + (index < current ? source2.getPositionUs() : source2.getDurationUs());
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final long positionUs(List<? extends DataSource> $this$positionUs, int current) {
        void $this$foldIndexed$iv;
        Iterable iterable = $this$positionUs;
        long initial$iv = 0L;
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        long accumulator$iv = initial$iv;
        for (Object element$iv : $this$foldIndexed$iv) {
            void source2;
            void acc;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DataSource dataSource = (DataSource)element$iv;
            long l = accumulator$iv;
            int index = n;
            boolean bl2 = false;
            accumulator$iv = index <= current ? acc + source2.getPositionUs() : acc;
        }
        return accumulator$iv;
    }

    @NotNull
    public final TrackMap<Long> getPositionUs() {
        return this.positionUs;
    }

    @NotNull
    public final TrackMap<Long> getDurationUs() {
        return this.durationUs;
    }

    public final long getTotalDurationUs() {
        long video = this.tracks.getActive().getHasVideo() ? ((Number)this.durationUs.getVideo()).longValue() : Long.MAX_VALUE;
        long audio = this.tracks.getActive().getHasAudio() ? ((Number)this.durationUs.getAudio()).longValue() : Long.MAX_VALUE;
        boolean bl = false;
        return Math.min(video, audio);
    }

    @NotNull
    public final TrackMap<Double> getProgress() {
        return this.progress;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Long localize(@NotNull TrackType type, int index, long positionUs2) {
        void $this$filterIndexedTo$iv$iv;
        void $this$filterIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (!this.tracks.getActive().has(type)) {
            return null;
        }
        Iterable iterable = (Iterable)this.sources.get(type);
        Timer timer = this;
        boolean $i$f$filterIndexed = false;
        void var9_8 = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n = index$iv$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl2 = false;
            DataSource dataSource = (DataSource)element$iv$iv;
            int i = index$iv$iv;
            boolean bl3 = false;
            if (!(i < index)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        long behindUs = timer.durationUs(list, -1);
        long localizedUs = positionUs2 - behindUs;
        if (localizedUs < 0L) {
            return null;
        }
        if (localizedUs > ((DataSource)this.sources.get(type).get(index)).getDurationUs()) {
            return null;
        }
        return localizedUs;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TimeInterpolator interpolator(@NotNull TrackType type, int index) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Map<Pair<TrackType, Integer>, TimeInterpolator> map = this.interpolators;
        Pair key$iv = TuplesKt.to((Object)((Object)type), (Object)index);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            TimeInterpolator answer$iv = new TimeInterpolator(this, index, type){
                private long lastOut;
                private long firstIn;
                private final long firstOut;
                final /* synthetic */ Timer this$0;
                final /* synthetic */ int $index$inlined;
                final /* synthetic */ TrackType $type$inlined;
                {
                    long l;
                    this.this$0 = timer;
                    this.$index$inlined = n;
                    this.$type$inlined = trackType;
                    this.firstIn = Long.MAX_VALUE;
                    if (this.$index$inlined == 0) {
                        l = 0L;
                    } else {
                        V v = Timer.access$getInterpolators$p(this.this$0).get(TuplesKt.to((Object)((Object)this.$type$inlined), (Object)(this.$index$inlined - 1)));
                        Intrinsics.checkNotNull(v);
                        TimeInterpolator previous = (TimeInterpolator)v;
                        l = previous.interpolate(this.$type$inlined, Long.MAX_VALUE) + 10L;
                    }
                    this.firstOut = l;
                }

                public long interpolate(@NotNull TrackType type, long time) {
                    long l;
                    Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                    long l2 = time;
                    if (l2 == Long.MAX_VALUE) {
                        l = this.lastOut;
                    } else {
                        if (this.firstIn == Long.MAX_VALUE) {
                            this.firstIn = time;
                        }
                        this.lastOut = this.firstOut + (time - this.firstIn);
                        l = Timer.access$getInterpolator$p(this.this$0).interpolate(type, this.lastOut);
                    }
                    return l;
                }
            };
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (TimeInterpolator)object;
    }

    public Timer(@NotNull TimeInterpolator interpolator, @NotNull DataSources sources, @NotNull Tracks tracks, @NotNull TrackMap<Integer> current) {
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
        Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)tracks, (String)"tracks");
        Intrinsics.checkNotNullParameter(current, (String)"current");
        this.interpolator = interpolator;
        this.sources = sources;
        this.tracks = tracks;
        this.current = current;
        this.log = new Logger("Timer");
        this.positionUs = new TrackMap<Long>(this){
            final /* synthetic */ Timer this$0;

            public boolean has(@NotNull TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return true;
            }

            @NotNull
            public Long get(@NotNull TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return !Timer.access$getTracks$p(this.this$0).getActive().has(type) ? 0L : Timer.access$positionUs(this.this$0, (List)Timer.access$getSources$p(this.this$0).get(type), ((Number)Timer.access$getCurrent$p(this.this$0).get(type)).intValue());
            }
            {
                this.this$0 = this$0;
            }

            @NotNull
            public Long getVideo() {
                return TrackMap.DefaultImpls.getVideo(this);
            }

            @NotNull
            public Long getAudio() {
                return TrackMap.DefaultImpls.getAudio(this);
            }

            public boolean getHasVideo() {
                return TrackMap.DefaultImpls.getHasVideo(this);
            }

            public boolean getHasAudio() {
                return TrackMap.DefaultImpls.getHasAudio(this);
            }

            @Nullable
            public Long getOrNull(@NotNull TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return TrackMap.DefaultImpls.getOrNull(this, type);
            }

            @Nullable
            public Long videoOrNull() {
                return TrackMap.DefaultImpls.videoOrNull(this);
            }

            @Nullable
            public Long audioOrNull() {
                return TrackMap.DefaultImpls.audioOrNull(this);
            }

            public int getSize() {
                return TrackMap.DefaultImpls.getSize(this);
            }

            @NotNull
            public Iterator<Long> iterator() {
                return TrackMap.DefaultImpls.iterator(this);
            }
        };
        this.durationUs = new TrackMap<Long>(this){
            final /* synthetic */ Timer this$0;

            public boolean has(@NotNull TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return true;
            }

            @NotNull
            public Long get(@NotNull TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return !Timer.access$getTracks$p(this.this$0).getActive().has(type) ? 0L : Timer.access$durationUs(this.this$0, (List)Timer.access$getSources$p(this.this$0).get(type), ((Number)Timer.access$getCurrent$p(this.this$0).get(type)).intValue());
            }
            {
                this.this$0 = this$0;
            }

            @NotNull
            public Long getVideo() {
                return TrackMap.DefaultImpls.getVideo(this);
            }

            @NotNull
            public Long getAudio() {
                return TrackMap.DefaultImpls.getAudio(this);
            }

            public boolean getHasVideo() {
                return TrackMap.DefaultImpls.getHasVideo(this);
            }

            public boolean getHasAudio() {
                return TrackMap.DefaultImpls.getHasAudio(this);
            }

            @Nullable
            public Long getOrNull(@NotNull TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return TrackMap.DefaultImpls.getOrNull(this, type);
            }

            @Nullable
            public Long videoOrNull() {
                return TrackMap.DefaultImpls.videoOrNull(this);
            }

            @Nullable
            public Long audioOrNull() {
                return TrackMap.DefaultImpls.audioOrNull(this);
            }

            public int getSize() {
                return TrackMap.DefaultImpls.getSize(this);
            }

            @NotNull
            public Iterator<Long> iterator() {
                return TrackMap.DefaultImpls.iterator(this);
            }
        };
        this.progress = new TrackMap<Double>(this){
            final /* synthetic */ Timer this$0;

            public boolean has(@NotNull TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return true;
            }

            @NotNull
            public Double get(@NotNull TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                long read = ((Number)this.this$0.getPositionUs().get(type)).longValue();
                long total = ((Number)this.this$0.getDurationUs().get(type)).longValue();
                return total == 0L ? 0.0 : (double)read / (double)total;
            }
            {
                this.this$0 = this$0;
            }

            @NotNull
            public Double getVideo() {
                return TrackMap.DefaultImpls.getVideo(this);
            }

            @NotNull
            public Double getAudio() {
                return TrackMap.DefaultImpls.getAudio(this);
            }

            public boolean getHasVideo() {
                return TrackMap.DefaultImpls.getHasVideo(this);
            }

            public boolean getHasAudio() {
                return TrackMap.DefaultImpls.getHasAudio(this);
            }

            @Nullable
            public Double getOrNull(@NotNull TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return TrackMap.DefaultImpls.getOrNull(this, type);
            }

            @Nullable
            public Double videoOrNull() {
                return TrackMap.DefaultImpls.videoOrNull(this);
            }

            @Nullable
            public Double audioOrNull() {
                return TrackMap.DefaultImpls.audioOrNull(this);
            }

            public int getSize() {
                return TrackMap.DefaultImpls.getSize(this);
            }

            @NotNull
            public Iterator<Double> iterator() {
                return TrackMap.DefaultImpls.iterator(this);
            }
        };
        boolean bl = false;
        this.interpolators = new LinkedHashMap();
    }

    public static final /* synthetic */ TimeInterpolator access$getInterpolator$p(Timer $this) {
        return $this.interpolator;
    }

    public static final /* synthetic */ Map access$getInterpolators$p(Timer $this) {
        return $this.interpolators;
    }

    public static final /* synthetic */ Tracks access$getTracks$p(Timer $this) {
        return $this.tracks;
    }

    public static final /* synthetic */ long access$positionUs(Timer $this, List $this$access_u24positionUs, int current) {
        return $this.positionUs($this$access_u24positionUs, current);
    }

    public static final /* synthetic */ DataSources access$getSources$p(Timer $this) {
        return $this.sources;
    }

    public static final /* synthetic */ TrackMap access$getCurrent$p(Timer $this) {
        return $this.current;
    }

    public static final /* synthetic */ long access$durationUs(Timer $this, List $this$access_u24durationUs, int current) {
        return $this.durationUs($this$access_u24durationUs, current);
    }
}

