/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal;

import com.otaliastudios.transcoder.ThumbnailerOptions;
import com.otaliastudios.transcoder.TranscoderOptions;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.DataSources$WhenMappings;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.TrackMap;
import com.otaliastudios.transcoder.source.BlankAudioDataSource;
import com.otaliastudios.transcoder.source.DataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB#\b\u0002\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0002\u0010\u000bJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002J\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0014\u001a\u00020\u0015J\f\u0010\u0016\u001a\u00020\u0015*\u00020\u0003H\u0002J\u0012\u0010\u0016\u001a\u00020\u0015*\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J\f\u0010\u0017\u001a\u00020\u0015*\u00020\u0003H\u0002J\u0012\u0010\u0017\u001a\u00020\u0015*\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/otaliastudios/transcoder/internal/DataSources;", "Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "", "Lcom/otaliastudios/transcoder/source/DataSource;", "options", "Lcom/otaliastudios/transcoder/TranscoderOptions;", "(Lcom/otaliastudios/transcoder/TranscoderOptions;)V", "Lcom/otaliastudios/transcoder/ThumbnailerOptions;", "(Lcom/otaliastudios/transcoder/ThumbnailerOptions;)V", "videoSources", "audioSources", "(Ljava/util/List;Ljava/util/List;)V", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "all", "get", "type", "Lcom/otaliastudios/transcoder/common/TrackType;", "has", "", "release", "", "deinit", "init", "lib_release"})
public final class DataSources
implements TrackMap<List<? extends DataSource>> {
    private final Logger log;
    private final List<DataSource> videoSources;
    private final List<DataSource> audioSources;

    private final void init(DataSource $this$init) {
        if (!$this$init.isInitialized()) {
            $this$init.initialize();
        }
    }

    private final void deinit(DataSource $this$deinit) {
        if ($this$deinit.isInitialized()) {
            $this$deinit.deinitialize();
        }
    }

    private final void init(List<? extends DataSource> $this$init) {
        Iterable $this$forEach$iv = $this$init;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataSource it = (DataSource)element$iv;
            boolean bl = false;
            this.init(it);
        }
    }

    private final void deinit(List<? extends DataSource> $this$deinit) {
        Iterable $this$forEach$iv = $this$deinit;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataSource it = (DataSource)element$iv;
            boolean bl = false;
            this.deinit(it);
        }
    }

    @Override
    @NotNull
    public List<DataSource> get(@NotNull TrackType type) {
        List<DataSource> list;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        switch (DataSources$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                list = this.audioSources;
                break;
            }
            case 2: {
                list = this.videoSources;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    @Override
    public boolean has(@NotNull TrackType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Collection collection = (Collection)this.get(type);
        boolean bl = false;
        return !collection.isEmpty();
    }

    @NotNull
    public final List<DataSource> all() {
        return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)((Collection)this.getAudio()), (Iterable)((Iterable)this.getVideo())));
    }

    public final void release() {
        DataSource it;
        this.log.i("release(): releasing...");
        Iterable $this$forEach$iv = (Iterable)this.getVideo();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (DataSource)element$iv;
            boolean bl = false;
            this.deinit(it);
        }
        $this$forEach$iv = (Iterable)this.getAudio();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (DataSource)element$iv;
            boolean bl = false;
            this.deinit(it);
        }
        this.log.i("release(): released.");
    }

    /*
     * WARNING - void declaration
     */
    private DataSources(List<? extends DataSource> videoSources, List<? extends DataSource> audioSources) {
        List list;
        int n;
        List list2;
        DataSources $this$run;
        List it;
        int valid;
        int count$iv;
        int n2;
        this.log = new Logger("DataSources");
        this.init(videoSources);
        this.init(audioSources);
        DataSources dataSources = this;
        boolean bl = false;
        boolean bl2 = false;
        DataSources dataSources2 = dataSources;
        DataSources dataSources3 = this;
        boolean bl3 = false;
        Iterable $this$count$iv22 = videoSources;
        boolean $i$f$count2 = false;
        if ($this$count$iv22 instanceof Collection && ((Collection)$this$count$iv22).isEmpty()) {
            n2 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv22) {
                DataSource it22 = (DataSource)element$iv;
                boolean bl4 = false;
                if (!(it22.getTrackFormat(TrackType.VIDEO) != null)) continue;
                int it22 = ++count$iv;
                bl4 = false;
                if (it22 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int $this$count$iv22 = valid = n2;
        if ($this$count$iv22 == 0) {
            $i$f$count2 = false;
            List $i$f$count2 = CollectionsKt.emptyList();
            count$iv = 0;
            boolean bl5 = false;
            it = $i$f$count2;
            boolean bl6 = false;
            super.deinit(videoSources);
            list2 = $i$f$count2;
        } else {
            list2 = $this$count$iv22 == videoSources.size() ? videoSources : videoSources;
        }
        List list3 = list2;
        dataSources3.videoSources = list3;
        dataSources = this;
        bl = false;
        bl2 = false;
        $this$run = dataSources;
        dataSources3 = this;
        boolean bl7 = false;
        Iterable $this$count$iv = audioSources;
        boolean $i$f$count32 = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                DataSource it32 = (DataSource)element$iv;
                boolean bl8 = false;
                if (!(it32.getTrackFormat(TrackType.AUDIO) != null)) continue;
                int it32 = ++count$iv;
                boolean bl9 = false;
                if (it32 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n3 = valid = n;
        if (n3 == 0) {
            $i$f$count32 = false;
            List $i$f$count32 = CollectionsKt.emptyList();
            count$iv = 0;
            boolean bl10 = false;
            it = $i$f$count32;
            boolean bl11 = false;
            $this$run.deinit(audioSources);
            list = $i$f$count32;
        } else if (n3 == audioSources.size()) {
            list = audioSources;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = audioSources;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DataSource dataSource;
                void source2;
                DataSource dataSource2 = (DataSource)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl12 = false;
                if (source2.getTrackFormat(TrackType.AUDIO) != null) {
                    dataSource = source2;
                } else {
                    BlankAudioDataSource blankAudioDataSource = new BlankAudioDataSource(source2.getDurationUs());
                    boolean bl13 = false;
                    boolean bl14 = false;
                    BlankAudioDataSource it2 = blankAudioDataSource;
                    boolean bl15 = false;
                    $this$run.deinit((DataSource)source2);
                    dataSource = blankAudioDataSource;
                }
                void var25_45 = dataSource;
                collection.add(var25_45);
            }
            list = (List)destination$iv$iv;
        }
        dataSources3.audioSources = list3 = list;
    }

    public DataSources(@NotNull TranscoderOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        List<DataSource> list = options.getVideoDataSources();
        Intrinsics.checkNotNullExpressionValue(list, (String)"options.videoDataSources");
        List<DataSource> list2 = options.getAudioDataSources();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"options.audioDataSources");
        this(list, list2);
    }

    public DataSources(@NotNull ThumbnailerOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        boolean bl = false;
        this(options.getDataSources(), CollectionsKt.emptyList());
    }

    @Override
    @NotNull
    public List<DataSource> getVideo() {
        return TrackMap.DefaultImpls.getVideo(this);
    }

    @Override
    @NotNull
    public List<DataSource> getAudio() {
        return TrackMap.DefaultImpls.getAudio(this);
    }

    @Override
    public boolean getHasVideo() {
        return TrackMap.DefaultImpls.getHasVideo(this);
    }

    @Override
    public boolean getHasAudio() {
        return TrackMap.DefaultImpls.getHasAudio(this);
    }

    @Override
    @Nullable
    public List<DataSource> getOrNull(@NotNull TrackType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return TrackMap.DefaultImpls.getOrNull(this, type);
    }

    @Override
    @Nullable
    public List<DataSource> videoOrNull() {
        return TrackMap.DefaultImpls.videoOrNull(this);
    }

    @Override
    @Nullable
    public List<DataSource> audioOrNull() {
        return TrackMap.DefaultImpls.audioOrNull(this);
    }

    @Override
    public int getSize() {
        return TrackMap.DefaultImpls.getSize(this);
    }

    @Override
    @NotNull
    public Iterator<List<DataSource>> iterator() {
        return TrackMap.DefaultImpls.iterator(this);
    }
}

