/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.opengl.draw;

import android.graphics.PointF;
import android.opengl.GLES20;
import com.otaliastudios.opengl.core.Egloo;
import com.otaliastudios.opengl.draw.Gl2dDrawable;
import com.otaliastudios.opengl.extensions.MatrixKt;
import com.otaliastudios.opengl.internal.GlKt;
import com.otaliastudios.opengl.types.BuffersJvmKt;
import java.nio.FloatBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0014J\b\u0010*\u001a\u00020(H\u0002J\b\u0010+\u001a\u00020(H\u0002R,\u0010\b\u001a\u00060\u0006j\u0002`\u00072\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R$\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R$\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0010\"\u0004\b\u001b\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/otaliastudios/opengl/draw/GlPolygon;", "Lcom/otaliastudios/opengl/draw/Gl2dDrawable;", "sides", "", "(I)V", "value", "Landroid/graphics/PointF;", "Lcom/otaliastudios/opengl/geometry/PointF;", "center", "getCenter", "()Landroid/graphics/PointF;", "setCenter", "(Landroid/graphics/PointF;)V", "", "centerX", "getCenterX", "()F", "setCenterX", "(F)V", "centerY", "getCenterY", "setCenterY", "radius", "getRadius", "setRadius", "rotation", "getRotation", "setRotation", "vertexArray", "Ljava/nio/FloatBuffer;", "Lcom/otaliastudios/opengl/types/FloatBuffer;", "getVertexArray", "()Ljava/nio/FloatBuffer;", "setVertexArray", "(Ljava/nio/FloatBuffer;)V", "viewportScaleX", "viewportScaleY", "viewportTranslationX", "viewportTranslationY", "draw", "", "onViewportSizeChanged", "onViewportSizeOrCenterChanged", "updateArray", "library_release"})
public class GlPolygon
extends Gl2dDrawable {
    private final int sides;
    private float viewportTranslationX;
    private float viewportTranslationY;
    private float viewportScaleX;
    private float viewportScaleY;
    private float radius;
    private float rotation;
    private float centerX;
    private float centerY;
    @NotNull
    private FloatBuffer vertexArray;

    public GlPolygon(int sides) {
        this.sides = sides;
        if (this.sides < 3) {
            throw new IllegalArgumentException("Polygon should have at least 3 sides.");
        }
        this.viewportScaleX = 1.0f;
        this.viewportScaleY = 1.0f;
        this.radius = 1.0f;
        this.vertexArray = BuffersJvmKt.floatBuffer((this.sides + 2) * this.getCoordsPerVertex());
        this.updateArray();
    }

    public final float getRadius() {
        return this.radius;
    }

    public final void setRadius(float value) {
        this.radius = value;
        this.updateArray();
    }

    public final float getRotation() {
        return this.rotation;
    }

    public final void setRotation(float value) {
        this.rotation = value % (float)360;
        this.updateArray();
    }

    public final float getCenterX() {
        return this.centerX;
    }

    public final void setCenterX(float value) {
        this.centerX = value;
        this.updateArray();
        this.onViewportSizeOrCenterChanged();
    }

    public final float getCenterY() {
        return this.centerY;
    }

    public final void setCenterY(float value) {
        this.centerY = value;
        this.updateArray();
        this.onViewportSizeOrCenterChanged();
    }

    @NotNull
    public final PointF getCenter() {
        return new PointF(this.centerX, this.centerY);
    }

    public final void setCenter(@NotNull PointF value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setCenterX(value.x);
        this.setCenterY(value.y);
    }

    @Override
    @NotNull
    public FloatBuffer getVertexArray() {
        return this.vertexArray;
    }

    @Override
    public void setVertexArray(@NotNull FloatBuffer floatBuffer) {
        Intrinsics.checkNotNullParameter((Object)floatBuffer, (String)"<set-?>");
        this.vertexArray = floatBuffer;
    }

    private final void updateArray() {
        FloatBuffer array = this.getVertexArray();
        array.clear();
        array.put(this.centerX);
        array.put(this.centerY);
        float angle = 0.0f;
        angle = this.rotation * ((float)Math.PI / 180);
        float step = (float)Math.PI * 2 / (float)this.sides;
        int n = this.sides;
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl2 = false;
            float f = angle;
            boolean bl3 = false;
            array.put(this.getCenterX() + this.getRadius() * (float)Math.cos(f));
            f = angle;
            bl3 = false;
            array.put(this.getCenterY() + this.getRadius() * (float)Math.sin(f));
            angle += step;
        }
        array.put(array.get(2));
        array.put(array.get(3));
        array.flip();
        this.notifyVertexArrayChange();
    }

    @Override
    protected void onViewportSizeChanged() {
        super.onViewportSizeChanged();
        this.onViewportSizeOrCenterChanged();
    }

    private final void onViewportSizeOrCenterChanged() {
        MatrixKt.scale$default(this.getModelMatrix(), 1.0f / this.viewportScaleX, 1.0f / this.viewportScaleY, 0.0f, 4, null);
        MatrixKt.translate$default(this.getModelMatrix(), -this.viewportTranslationX, -this.viewportTranslationY, 0.0f, 4, null);
        if (this.getViewportWidth() > this.getViewportHeight()) {
            this.viewportScaleX = (float)this.getViewportHeight() / (float)this.getViewportWidth();
            this.viewportScaleY = 1.0f;
            this.viewportTranslationX = this.centerX * (1.0f - this.viewportScaleX);
            this.viewportTranslationY = 0.0f;
        } else if (this.getViewportWidth() < this.getViewportHeight()) {
            this.viewportScaleY = (float)this.getViewportWidth() / (float)this.getViewportHeight();
            this.viewportScaleX = 1.0f;
            this.viewportTranslationY = this.centerY * (1.0f - this.viewportScaleY);
            this.viewportTranslationX = 0.0f;
        } else {
            this.viewportScaleX = 1.0f;
            this.viewportScaleY = 1.0f;
            this.viewportTranslationX = 0.0f;
            this.viewportTranslationY = 0.0f;
        }
        MatrixKt.translate$default(this.getModelMatrix(), this.viewportTranslationX, this.viewportTranslationY, 0.0f, 4, null);
        MatrixKt.scale$default(this.getModelMatrix(), this.viewportScaleX, this.viewportScaleY, 0.0f, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw() {
        void first$iv;
        void mode$iv;
        int n = GlKt.getGL_TRIANGLE_FAN();
        boolean bl = false;
        int count$iv = this.getVertexCount();
        boolean bl2 = false;
        boolean bl3 = false;
        GLES20.glDrawArrays((int)mode$iv, (int)first$iv, (int)count$iv);
        Egloo.checkGlError("glDrawArrays");
    }
}

