/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.opengl.draw;

import android.graphics.PointF;
import android.opengl.GLES20;
import com.otaliastudios.opengl.core.Egloo;
import com.otaliastudios.opengl.draw.Gl2dDrawable;
import com.otaliastudios.opengl.geometry.IndexedSegmentF;
import com.otaliastudios.opengl.geometry.SegmentF;
import com.otaliastudios.opengl.internal.GlKt;
import com.otaliastudios.opengl.types.BuffersJvmKt;
import com.otaliastudios.opengl.types.BuffersKt;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u0014\u001a\u00020\u000e2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u00060\u0016j\u0002`\u00170\u0010J\"\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0010R\u001e\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/otaliastudios/opengl/draw/Gl2dMesh;", "Lcom/otaliastudios/opengl/draw/Gl2dDrawable;", "()V", "vertexArray", "Ljava/nio/FloatBuffer;", "Lcom/otaliastudios/opengl/types/FloatBuffer;", "getVertexArray", "()Ljava/nio/FloatBuffer;", "setVertexArray", "(Ljava/nio/FloatBuffer;)V", "vertexIndices", "Ljava/nio/ByteBuffer;", "Lcom/otaliastudios/opengl/types/ByteBuffer;", "computeIndicesFromIndexedSegments", "", "segments", "", "Lcom/otaliastudios/opengl/geometry/IndexedSegmentF;", "draw", "release", "setPoints", "points", "Landroid/graphics/PointF;", "Lcom/otaliastudios/opengl/geometry/PointF;", "x", "", "y", "library_release"})
public class Gl2dMesh
extends Gl2dDrawable {
    @NotNull
    private FloatBuffer vertexArray = BuffersJvmKt.floatBuffer(6);
    @Nullable
    private ByteBuffer vertexIndices;

    @Override
    @NotNull
    public FloatBuffer getVertexArray() {
        return this.vertexArray;
    }

    @Override
    public void setVertexArray(@NotNull FloatBuffer floatBuffer) {
        Intrinsics.checkNotNullParameter((Object)floatBuffer, (String)"<set-?>");
        this.vertexArray = floatBuffer;
    }

    public final void setPoints(@NotNull List<? extends PointF> points) {
        Object object;
        PointF it;
        Collection<Float> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Iterable iterable = points;
        Gl2dMesh gl2dMesh = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PointF pointF = (PointF)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = Float.valueOf(it.x);
            collection.add((Float)object);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = points;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PointF)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Float f = Float.valueOf(it.y);
            object.add(f);
        }
        object = (List)destination$iv$iv;
        gl2dMesh.setPoints((List<Float>)collection, (List<Float>)object);
    }

    public final void setPoints(@NotNull List<Float> x, @NotNull List<Float> y) {
        Intrinsics.checkNotNullParameter(x, (String)"x");
        Intrinsics.checkNotNullParameter(y, (String)"y");
        if (x.size() != y.size()) {
            throw new IllegalArgumentException("x.size != y.size");
        }
        int points = x.size();
        int coords = points * 2;
        if (this.getVertexArray().capacity() < coords) {
            BuffersKt.dispose(this.getVertexArray());
            this.setVertexArray(BuffersJvmKt.floatBuffer(coords));
        } else {
            this.getVertexArray().clear();
        }
        int n = 0;
        List segments = new ArrayList();
        n = 0;
        if (n < points) {
            do {
                int i = n++;
                float xi = ((Number)x.get(i)).floatValue();
                float yi = ((Number)y.get(i)).floatValue();
                this.getVertexArray().put(xi);
                this.getVertexArray().put(yi);
                int n2 = i + 1;
                if (n2 >= points) continue;
                do {
                    int j = n2++;
                    float xj = ((Number)x.get(j)).floatValue();
                    float yj = ((Number)y.get(j)).floatValue();
                    segments.add(new IndexedSegmentF(i, j, xi, yi, xj, yj));
                } while (n2 < points);
            } while (n < points);
        }
        this.getVertexArray().flip();
        this.notifyVertexArrayChange();
        List $this$sortBy$iv = segments;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            boolean xi = false;
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    IndexedSegmentF it = (IndexedSegmentF)a;
                    boolean bl2 = false;
                    Comparable comparable = Float.valueOf(it.getLength());
                    it = (IndexedSegmentF)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Float f = Float.valueOf(it.getLength());
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)f);
                }
            });
        }
        boolean bl = false;
        List accepted = new ArrayList();
        for (IndexedSegmentF s : segments) {
            boolean bl2;
            block11: {
                Iterable $this$none$iv = accepted;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        IndexedSegmentF it = (IndexedSegmentF)element$iv;
                        boolean bl3 = false;
                        if (!it.intersects(s)) continue;
                        bl2 = false;
                        break block11;
                    }
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            accepted.add(s);
        }
        this.computeIndicesFromIndexedSegments(accepted);
    }

    /*
     * WARNING - void declaration
     */
    private final void computeIndicesFromIndexedSegments(List<IndexedSegmentF> segments) {
        void buffer;
        ByteBuffer byteBuffer;
        Object s1;
        int n = 0;
        List indices = new ArrayList();
        n = 0;
        int n2 = segments.size() + -1;
        if (n <= n2) {
            block0: do {
                int si = n++;
                s1 = segments.get(si);
                boolean hasPositiveTriangle = false;
                boolean hasNegativeTriangle = false;
                int n3 = si + 1;
                int n4 = segments.size();
                if (n3 >= n4) continue;
                block1: do {
                    int n5;
                    int n6;
                    int sj = n3++;
                    if (hasPositiveTriangle && hasNegativeTriangle) continue block0;
                    IndexedSegmentF s2 = segments.get(sj);
                    int s2UnsharedIndex = 0;
                    float s2UnsharedX = 0.0f;
                    float s2UnsharedY = 0.0f;
                    if (((IndexedSegmentF)s1).hasIndex(s2.getI())) {
                        s2UnsharedIndex = s2.getJ();
                        s2UnsharedX = s2.getJx();
                        s2UnsharedY = s2.getJy();
                    } else {
                        if (!((IndexedSegmentF)s1).hasIndex(s2.getJ())) continue;
                        s2UnsharedIndex = s2.getI();
                        s2UnsharedX = s2.getIx();
                        s2UnsharedY = s2.getIy();
                    }
                    int orientation = ((SegmentF)s1).orientation(s2UnsharedX, s2UnsharedY);
                    if (orientation == 0 || orientation > 0 && hasPositiveTriangle || orientation < 0 && hasNegativeTriangle || (n6 = sj + 1) >= (n5 = segments.size())) continue;
                    do {
                        int sk;
                        IndexedSegmentF s3;
                        if (!(s3 = segments.get(sk = n6++)).hasIndex(s2UnsharedIndex) || !s3.hasIndex(((IndexedSegmentF)s1).getI()) && !s3.hasIndex(((IndexedSegmentF)s1).getJ())) continue;
                        indices.add((byte)((IndexedSegmentF)s1).getI());
                        indices.add((byte)((IndexedSegmentF)s1).getJ());
                        indices.add((byte)s2UnsharedIndex);
                        if (orientation > 0) {
                            hasPositiveTriangle = true;
                        }
                        if (orientation >= 0) continue block1;
                        hasNegativeTriangle = true;
                        continue block1;
                    } while (n6 < n5);
                } while (n3 < n4);
            } while (n <= n2);
        }
        if ((byteBuffer = this.vertexIndices) != null) {
            BuffersKt.dispose(byteBuffer);
        }
        byteBuffer = BuffersJvmKt.byteBuffer(indices.size());
        n2 = 0;
        boolean bl = false;
        s1 = byteBuffer;
        Gl2dMesh gl2dMesh = this;
        boolean bl2 = false;
        Iterable $this$forEach$iv = indices;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            byte it = ((Number)element$iv).byteValue();
            boolean bl3 = false;
            buffer.put(it);
        }
        buffer.clear();
        Unit unit = Unit.INSTANCE;
        gl2dMesh.vertexIndices = byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw() {
        ByteBuffer byteBuffer = this.vertexIndices;
        if (byteBuffer != null) {
            void count$iv;
            void mode$iv;
            ByteBuffer byteBuffer2 = byteBuffer;
            boolean bl = false;
            boolean bl2 = false;
            ByteBuffer it = byteBuffer2;
            boolean bl3 = false;
            Egloo.checkGlError("glDrawElements start");
            int n = GlKt.getGL_TRIANGLES();
            int n2 = it.limit();
            int type$iv = GlKt.getGL_UNSIGNED_BYTE();
            boolean bl4 = false;
            boolean bl5 = false;
            bl5 = false;
            GLES20.glDrawElements((int)mode$iv, (int)count$iv, (int)type$iv, (Buffer)it);
            Egloo.checkGlError("glDrawElements end");
        }
    }

    @Override
    public void release() {
        super.release();
        ByteBuffer byteBuffer = this.vertexIndices;
        if (byteBuffer != null) {
            BuffersKt.dispose(byteBuffer);
        }
    }
}

