/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.opengl.surface;

import android.graphics.Bitmap;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import com.otaliastudios.opengl.core.EglCore;
import com.otaliastudios.opengl.core.Egloo;
import com.otaliastudios.opengl.surface.EglNativeSurface;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0015"}, d2={"Lcom/otaliastudios/opengl/surface/EglSurface;", "Lcom/otaliastudios/opengl/surface/EglNativeSurface;", "eglCore", "Lcom/otaliastudios/opengl/core/EglCore;", "eglSurface", "Landroid/opengl/EGLSurface;", "(Lcom/otaliastudios/opengl/core/EglCore;Landroid/opengl/EGLSurface;)V", "Lcom/otaliastudios/opengl/internal/EglSurface;", "(Lcom/otaliastudios/opengl/core/EglCore;Lcom/otaliastudios/opengl/internal/EglSurface;)V", "toByteArray", "", "format", "Landroid/graphics/Bitmap$CompressFormat;", "toFile", "", "file", "Ljava/io/File;", "toOutputStream", "stream", "Ljava/io/OutputStream;", "Companion", "library_release"})
public abstract class EglSurface
extends EglNativeSurface {
    @NotNull
    private static final String TAG;
    @NotNull
    public static final Companion Companion;

    public final void toOutputStream(@NotNull OutputStream stream, @NotNull Bitmap.CompressFormat format) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        if (!this.isCurrent()) {
            throw (Throwable)new RuntimeException("Expected EGL context/surface is not current");
        }
        int width = this.getWidth();
        int height = this.getHeight();
        ByteBuffer buf = ByteBuffer.allocateDirect(width * height * 4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)buf);
        Egloo.checkGlError("glReadPixels");
        buf.rewind();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.copyPixelsFromBuffer((Buffer)buf);
        bitmap.compress(format, 90, stream);
        bitmap.recycle();
    }

    public static /* synthetic */ void toOutputStream$default(EglSurface eglSurface, OutputStream outputStream, Bitmap.CompressFormat compressFormat, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toOutputStream");
        }
        if ((n & 2) != 0) {
            compressFormat = Bitmap.CompressFormat.PNG;
        }
        eglSurface.toOutputStream(outputStream, compressFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void toFile(@NotNull File file, @NotNull Bitmap.CompressFormat format) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        BufferedOutputStream stream = null;
        try {
            stream = new BufferedOutputStream(new FileOutputStream(file.toString()));
            this.toOutputStream(stream, format);
        }
        catch (Throwable throwable) {
            BufferedOutputStream bufferedOutputStream = stream;
            if (bufferedOutputStream != null) {
                bufferedOutputStream.close();
            }
            throw throwable;
        }
        stream.close();
    }

    public static /* synthetic */ void toFile$default(EglSurface eglSurface, File file, Bitmap.CompressFormat compressFormat, int n, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toFile");
        }
        if ((n & 2) != 0) {
            compressFormat = Bitmap.CompressFormat.PNG;
        }
        eglSurface.toFile(file, compressFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] toByteArray(@NotNull Bitmap.CompressFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Closeable closeable = stream;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
            boolean bl3 = false;
            this.toOutputStream(it, format);
            byte[] byArray = it.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"it.toByteArray()");
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ byte[] toByteArray$default(EglSurface eglSurface, Bitmap.CompressFormat compressFormat, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toByteArray");
        }
        if ((n & 1) != 0) {
            compressFormat = Bitmap.CompressFormat.PNG;
        }
        return eglSurface.toByteArray(compressFormat);
    }

    public EglSurface(@NotNull EglCore eglCore, @NotNull com.otaliastudios.opengl.internal.EglSurface eglSurface) {
        Intrinsics.checkNotNullParameter((Object)eglCore, (String)"eglCore");
        Intrinsics.checkNotNullParameter((Object)eglSurface, (String)"eglSurface");
        super(eglCore, eglSurface);
    }

    protected EglSurface(@NotNull EglCore eglCore, @NotNull EGLSurface eglSurface) {
        Intrinsics.checkNotNullParameter((Object)eglCore, (String)"eglCore");
        Intrinsics.checkNotNullParameter((Object)eglSurface, (String)"eglSurface");
        this(eglCore, new com.otaliastudios.opengl.internal.EglSurface(eglSurface));
    }

    static {
        Companion = new Companion(null);
        String string = com.otaliastudios.opengl.internal.EglSurface.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EglSurface::class.java.simpleName");
        TAG = string;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/otaliastudios/opengl/surface/EglSurface$Companion;", "", "()V", "TAG", "", "getTAG$annotations", "getTAG", "()Ljava/lang/String;", "library_release"})
    public static final class Companion {
        protected static /* synthetic */ void getTAG$annotations() {
        }

        @NotNull
        protected final String getTAG() {
            return TAG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

