/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.opengl.draw;

import android.graphics.RectF;
import android.opengl.GLES20;
import com.otaliastudios.opengl.core.Egloo;
import com.otaliastudios.opengl.draw.Gl2dDrawable;
import com.otaliastudios.opengl.internal.GlKt;
import com.otaliastudios.opengl.types.BuffersJvmKt;
import java.nio.FloatBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0014J\b\u0010\u001e\u001a\u00020\u0014H\u0002J\u000e\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u001bJ&\u0010\u001f\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001bJ\u0012\u0010%\u001a\u00020\u00142\n\u0010&\u001a\u00060'j\u0002`(J&\u0010%\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006*"}, d2={"Lcom/otaliastudios/opengl/draw/GlRoundRect;", "Lcom/otaliastudios/opengl/draw/Gl2dDrawable;", "()V", "bottom", "", "bottomLeftCorner", "bottomRightCorner", "left", "right", "top", "topLeftCorner", "topRightCorner", "vertexArray", "Ljava/nio/FloatBuffer;", "Lcom/otaliastudios/opengl/types/FloatBuffer;", "getVertexArray", "()Ljava/nio/FloatBuffer;", "setVertexArray", "(Ljava/nio/FloatBuffer;)V", "addCornerArc", "", "array", "pivotX", "pivotY", "width", "height", "startAngle", "", "draw", "onViewportSizeChanged", "recompute", "setCornersPx", "corners", "topLeft", "topRight", "bottomLeft", "bottomRight", "setRect", "rect", "Landroid/graphics/RectF;", "Lcom/otaliastudios/opengl/geometry/RectF;", "Companion", "library_release"})
public class GlRoundRect
extends Gl2dDrawable {
    private float topLeftCorner;
    private float topRightCorner;
    private float bottomLeftCorner;
    private float bottomRightCorner;
    private float top = 1.0f;
    private float bottom = -1.0f;
    private float left = -1.0f;
    private float right = 1.0f;
    @NotNull
    private FloatBuffer vertexArray = BuffersJvmKt.floatBuffer(82 * this.getCoordsPerVertex());
    @Deprecated
    private static final int POINTS_PER_CORNER = 20;
    @NotNull
    private static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public FloatBuffer getVertexArray() {
        return this.vertexArray;
    }

    @Override
    public void setVertexArray(@NotNull FloatBuffer floatBuffer) {
        Intrinsics.checkNotNullParameter((Object)floatBuffer, (String)"<set-?>");
        this.vertexArray = floatBuffer;
    }

    public final void setCornersPx(int corners) {
        this.setCornersPx(corners, corners, corners, corners);
    }

    public final void setCornersPx(int topLeft, int topRight, int bottomLeft, int bottomRight) {
        this.topLeftCorner = topLeft;
        this.topRightCorner = topRight;
        this.bottomLeftCorner = bottomLeft;
        this.bottomRightCorner = bottomRight;
        this.recompute();
    }

    public final void setRect(@NotNull RectF rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.setRect(rect.left, rect.top, rect.right, rect.bottom);
    }

    public final void setRect(float left, float top, float right, float bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.recompute();
    }

    @Override
    protected void onViewportSizeChanged() {
        super.onViewportSizeChanged();
        this.recompute();
    }

    private final void recompute() {
        boolean hasBottomLeftCorner;
        boolean hasBottomRightCorner;
        boolean hasTopRightCorner;
        boolean hasTopLeftCorner;
        FloatBuffer array = this.getVertexArray();
        array.clear();
        float centerX = (this.right + this.left) / 2.0f;
        float centerY = (this.top + this.bottom) / 2.0f;
        array.put(centerX);
        array.put(centerY);
        boolean hasCorners = this.getViewportHeight() > 0 && this.getViewportWidth() > 0;
        boolean bl = hasTopLeftCorner = hasCorners && this.topLeftCorner > 0.0f;
        if (hasTopLeftCorner) {
            float cornerWidth = this.topLeftCorner / (float)this.getViewportWidth() * 2.0f;
            float cornerHeight = this.topLeftCorner / (float)this.getViewportHeight() * 2.0f;
            float cornerPivotX = this.left + cornerWidth;
            float cornerPivotY = this.top - cornerHeight;
            this.addCornerArc(array, cornerPivotX, cornerPivotY, cornerWidth, cornerHeight, 180);
        } else {
            array.put(this.left);
            array.put(this.top);
        }
        boolean bl2 = hasTopRightCorner = hasCorners && this.topRightCorner > 0.0f;
        if (hasTopRightCorner) {
            float cornerWidth = this.topRightCorner / (float)this.getViewportWidth() * 2.0f;
            float cornerHeight = this.topRightCorner / (float)this.getViewportHeight() * 2.0f;
            float cornerPivotX = this.right - cornerWidth;
            float cornerPivotY = this.top - cornerHeight;
            this.addCornerArc(array, cornerPivotX, cornerPivotY, cornerWidth, cornerHeight, 90);
        } else {
            array.put(this.right);
            array.put(this.top);
        }
        boolean bl3 = hasBottomRightCorner = hasCorners && this.bottomRightCorner > 0.0f;
        if (hasBottomRightCorner) {
            float cornerWidth = this.bottomRightCorner / (float)this.getViewportWidth() * 2.0f;
            float cornerHeight = this.bottomRightCorner / (float)this.getViewportHeight() * 2.0f;
            float cornerPivotX = this.right - cornerWidth;
            float cornerPivotY = this.bottom + cornerHeight;
            this.addCornerArc(array, cornerPivotX, cornerPivotY, cornerWidth, cornerHeight, 0);
        } else {
            array.put(this.right);
            array.put(this.bottom);
        }
        boolean bl4 = hasBottomLeftCorner = hasCorners && this.bottomLeftCorner > 0.0f;
        if (hasBottomLeftCorner) {
            float cornerWidth = this.bottomLeftCorner / (float)this.getViewportWidth() * 2.0f;
            float cornerHeight = this.bottomLeftCorner / (float)this.getViewportHeight() * 2.0f;
            float cornerPivotX = this.left + cornerWidth;
            float cornerPivotY = this.bottom + cornerHeight;
            this.addCornerArc(array, cornerPivotX, cornerPivotY, cornerWidth, cornerHeight, -90);
        } else {
            array.put(this.left);
            array.put(this.bottom);
        }
        array.put(array.get(2));
        array.put(array.get(3));
        array.flip();
        this.notifyVertexArrayChange();
    }

    private final void addCornerArc(FloatBuffer array, float pivotX, float pivotY, float width, float height, int startAngle) {
        int endAngle = startAngle - 90;
        int points = 20;
        float t = 0.0f;
        float tDelta = 1.0f / (float)(points - 1);
        boolean bl = false;
        int n = 0;
        n = 0;
        int n2 = points;
        while (n < n2) {
            int it = n++;
            boolean bl2 = false;
            float angle = (float)startAngle + t * (float)(endAngle - startAngle);
            float radians = (float)((double)angle * Math.PI / (double)180);
            boolean bl3 = false;
            float f = width * (float)Math.sin(radians);
            int n3 = 2;
            boolean bl4 = false;
            float f2 = (float)Math.pow(f, n3);
            boolean bl5 = false;
            float f3 = height * (float)Math.cos(radians);
            n3 = 2;
            bl4 = false;
            f3 = f2 + (float)Math.pow(f3, n3);
            n3 = 0;
            float radius = width * height / (float)Math.sqrt(f3);
            bl3 = false;
            array.put(pivotX + radius * (float)Math.cos(radians));
            bl3 = false;
            array.put(pivotY + radius * (float)Math.sin(radians));
            t += tDelta;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw() {
        void first$iv;
        void mode$iv;
        int n = GlKt.getGL_TRIANGLE_FAN();
        boolean bl = false;
        int count$iv = this.getVertexCount();
        boolean bl2 = false;
        void var5_5 = mode$iv;
        boolean bl3 = false;
        GLES20.glDrawArrays((int)var5_5, (int)first$iv, (int)count$iv);
        Egloo.checkGlError("glDrawArrays");
    }

    public GlRoundRect() {
        this.recompute();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/otaliastudios/opengl/draw/GlRoundRect$Companion;", "", "()V", "POINTS_PER_CORNER", "", "library_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

