/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.gif.transcode.internal;

import androidx.annotation.NonNull;
import com.otaliastudios.gif.internal.Logger;

public abstract class VideoFrameDropper {
    private static final String TAG = VideoFrameDropper.class.getSimpleName();
    private static final Logger LOG = new Logger(TAG);

    private VideoFrameDropper() {
    }

    public abstract boolean shouldRenderFrame(long var1);

    @NonNull
    public static VideoFrameDropper newDropper(int inputFrameRate, int outputFrameRate) {
        return new Dropper1(inputFrameRate, outputFrameRate);
    }

    private static class Dropper1
    extends VideoFrameDropper {
        private double mInFrameRateReciprocal;
        private double mOutFrameRateReciprocal;
        private double mFrameRateReciprocalSum;
        private int mFrameCount;

        private Dropper1(int inputFrameRate, int outputFrameRate) {
            this.mInFrameRateReciprocal = 1.0 / (double)inputFrameRate;
            this.mOutFrameRateReciprocal = 1.0 / (double)outputFrameRate;
            LOG.i("inFrameRateReciprocal:" + this.mInFrameRateReciprocal + " outFrameRateReciprocal:" + this.mOutFrameRateReciprocal);
        }

        @Override
        public boolean shouldRenderFrame(long presentationTimeUs) {
            this.mFrameRateReciprocalSum += this.mInFrameRateReciprocal;
            if (this.mFrameCount++ == 0) {
                LOG.v("RENDERING (first frame) - frameRateReciprocalSum:" + this.mFrameRateReciprocalSum);
                return true;
            }
            if (this.mFrameRateReciprocalSum > this.mOutFrameRateReciprocal) {
                this.mFrameRateReciprocalSum -= this.mOutFrameRateReciprocal;
                LOG.v("RENDERING - frameRateReciprocalSum:" + this.mFrameRateReciprocalSum);
                return true;
            }
            LOG.v("DROPPING - frameRateReciprocalSum:" + this.mFrameRateReciprocalSum);
            return false;
        }
    }
}

