/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.gif.transcode.internal;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.SurfaceTexture;
import android.opengl.Matrix;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import com.otaliastudios.gif.internal.Logger;
import com.otaliastudios.opengl.draw.GlDrawable;
import com.otaliastudios.opengl.draw.GlRect;
import com.otaliastudios.opengl.program.GlTextureProgram;

public class VideoDecoderOutput {
    private static final String TAG = VideoDecoderOutput.class.getSimpleName();
    private static final Logger LOG = new Logger(TAG);
    private static final long NEW_IMAGE_TIMEOUT_MILLIS = 10000L;
    private SurfaceTexture mSurfaceTexture;
    private Surface mSurface;
    private GlTextureProgram mProgram;
    private GlRect mDrawable;
    private float mScaleX = 1.0f;
    private float mScaleY = 1.0f;
    private int mRotation = 0;
    @GuardedBy(value="mFrameAvailableLock")
    private boolean mFrameAvailable;
    private final Object mFrameAvailableLock = new Object();

    public VideoDecoderOutput() {
        this.mProgram = new GlTextureProgram();
        this.mDrawable = new GlRect();
        this.mSurfaceTexture = new SurfaceTexture(this.mProgram.getTextureId());
        this.mSurfaceTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                LOG.v("New frame available");
                Object object = VideoDecoderOutput.this.mFrameAvailableLock;
                synchronized (object) {
                    if (VideoDecoderOutput.this.mFrameAvailable) {
                        throw new RuntimeException("mFrameAvailable already set, frame could be dropped");
                    }
                    VideoDecoderOutput.this.mFrameAvailable = true;
                    VideoDecoderOutput.this.mFrameAvailableLock.notifyAll();
                }
            }
        });
    }

    public void setSize(int width, int height) {
        this.mSurfaceTexture.setDefaultBufferSize(width, height);
        this.mSurface = new Surface(this.mSurfaceTexture);
    }

    public void setScale(float scaleX, float scaleY) {
        this.mScaleX = scaleX;
        this.mScaleY = scaleY;
    }

    public void setRotation(int rotation) {
        this.mRotation = rotation;
    }

    public void release() {
        this.mProgram.release();
        this.mSurface.release();
        this.mSurface = null;
        this.mSurfaceTexture = null;
        this.mDrawable = null;
        this.mProgram = null;
    }

    public void drawFrame(@NonNull Bitmap bitmap) {
        this.drawBitmap(bitmap);
        this.awaitNewFrame();
        this.renderNewFrame();
    }

    private void drawBitmap(@NonNull Bitmap bitmap) {
        Canvas canvas = this.mSurface.lockCanvas(null);
        if (bitmap.getWidth() != canvas.getWidth() || bitmap.getHeight() != canvas.getHeight()) {
            throw new RuntimeException("Unexpected width / height. bw:" + bitmap.getWidth() + " bh:" + bitmap.getHeight() + " cw:" + canvas.getWidth() + " ch:" + canvas.getHeight());
        }
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        this.mSurface.unlockCanvasAndPost(canvas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitNewFrame() {
        Object object = this.mFrameAvailableLock;
        synchronized (object) {
            while (!this.mFrameAvailable) {
                try {
                    this.mFrameAvailableLock.wait(10000L);
                    if (this.mFrameAvailable) continue;
                    throw new RuntimeException("Surface frame wait timed out");
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
            }
            this.mFrameAvailable = false;
        }
        this.mSurfaceTexture.updateTexImage();
    }

    private void renderNewFrame() {
        this.mSurfaceTexture.getTransformMatrix(this.mProgram.getTextureTransform());
        float glScaleX = 1.0f / this.mScaleX;
        float glScaleY = 1.0f / this.mScaleY;
        float glTranslX = (1.0f - glScaleX) / 2.0f;
        float glTranslY = (1.0f - glScaleY) / 2.0f;
        Matrix.translateM((float[])this.mProgram.getTextureTransform(), (int)0, (float)glTranslX, (float)glTranslY, (float)0.0f);
        Matrix.scaleM((float[])this.mProgram.getTextureTransform(), (int)0, (float)glScaleX, (float)glScaleY, (float)1.0f);
        Matrix.translateM((float[])this.mProgram.getTextureTransform(), (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
        Matrix.rotateM((float[])this.mProgram.getTextureTransform(), (int)0, (float)this.mRotation, (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix.translateM((float[])this.mProgram.getTextureTransform(), (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
        this.mProgram.draw((GlDrawable)this.mDrawable);
    }
}

