/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.gif.transcode;

import android.graphics.Bitmap;
import android.media.MediaCodec;
import android.media.MediaFormat;
import androidx.annotation.NonNull;
import com.otaliastudios.gif.internal.Logger;
import com.otaliastudios.gif.internal.MediaCodecBuffers;
import com.otaliastudios.gif.sink.DataSink;
import com.otaliastudios.gif.source.DataSource;
import com.otaliastudios.gif.time.TimeInterpolator;
import com.otaliastudios.gif.transcode.BaseTranscoder;
import com.otaliastudios.gif.transcode.internal.VideoDecoderOutput;
import com.otaliastudios.gif.transcode.internal.VideoEncoderInput;
import com.otaliastudios.gif.transcode.internal.VideoFrameDropper;

public class VideoTranscoder
extends BaseTranscoder {
    private static final String TAG = VideoTranscoder.class.getSimpleName();
    private static final Logger LOG = new Logger(TAG);
    private VideoDecoderOutput mDecoderOutputSurface;
    private VideoEncoderInput mEncoderInputSurface;
    private MediaCodec mEncoder;
    private VideoFrameDropper mFrameDropper;
    private final TimeInterpolator mTimeInterpolator;
    private final int mExtraRotation;

    public VideoTranscoder(@NonNull DataSource dataSource, @NonNull DataSink dataSink, @NonNull TimeInterpolator timeInterpolator, int rotation) {
        super(dataSource, dataSink);
        this.mTimeInterpolator = timeInterpolator;
        this.mExtraRotation = rotation;
    }

    @Override
    protected void onConfigureEncoder(@NonNull MediaFormat format, @NonNull MediaCodec encoder) {
        int width = format.getInteger("width");
        int height = format.getInteger("height");
        boolean flip = this.mExtraRotation % 180 != 0;
        format.setInteger("width", flip ? height : width);
        format.setInteger("height", flip ? width : height);
        super.onConfigureEncoder(format, encoder);
    }

    @Override
    protected void onStartEncoder(@NonNull MediaFormat format, @NonNull MediaCodec encoder) {
        this.mEncoderInputSurface = new VideoEncoderInput(encoder.createInputSurface());
        super.onStartEncoder(format, encoder);
    }

    @Override
    protected void onStarted(@NonNull MediaFormat inputFormat, @NonNull MediaFormat outputFormat, @NonNull MediaCodec encoder) {
        super.onStarted(inputFormat, outputFormat, encoder);
        this.mEncoder = encoder;
        this.mDecoderOutputSurface = new VideoDecoderOutput();
        this.mDecoderOutputSurface.setRotation(this.mExtraRotation % 360);
        this.mFrameDropper = VideoFrameDropper.newDropper(inputFormat.getInteger("frame-rate"), outputFormat.getInteger("frame-rate"));
        int rotation = this.mExtraRotation % 360;
        boolean flip = rotation % 180 != 0;
        float inputWidth = inputFormat.getInteger("width");
        float inputHeight = inputFormat.getInteger("height");
        float inputRatio = inputWidth / inputHeight;
        float outputWidth = flip ? (float)outputFormat.getInteger("height") : (float)outputFormat.getInteger("width");
        float outputHeight = flip ? (float)outputFormat.getInteger("width") : (float)outputFormat.getInteger("height");
        float outputRatio = outputWidth / outputHeight;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        if (inputRatio > outputRatio) {
            scaleX = inputRatio / outputRatio;
        } else if (inputRatio < outputRatio) {
            scaleY = outputRatio / inputRatio;
        }
        this.mDecoderOutputSurface.setSize((int)inputWidth, (int)inputHeight);
        this.mDecoderOutputSurface.setScale(scaleX, scaleY);
    }

    @Override
    public void release() {
        if (this.mDecoderOutputSurface != null) {
            this.mDecoderOutputSurface.release();
            this.mDecoderOutputSurface = null;
        }
        if (this.mEncoderInputSurface != null) {
            this.mEncoderInputSurface.release();
            this.mEncoderInputSurface = null;
        }
        super.release();
        this.mEncoder = null;
    }

    @Override
    protected boolean onFeedEncoder(@NonNull MediaCodec encoder, @NonNull MediaCodecBuffers encoderBuffers, long timeoutUs) {
        return false;
    }

    @Override
    protected void onDrainSource(long timeoutUs, @NonNull Bitmap bitmap, long presentationTimeUs, boolean endOfStream) {
        long interpolatedTimeUs = this.mTimeInterpolator.interpolate(presentationTimeUs);
        if (this.mFrameDropper.shouldRenderFrame(interpolatedTimeUs)) {
            this.mDecoderOutputSurface.drawFrame(bitmap);
            this.mEncoderInputSurface.onFrame(interpolatedTimeUs);
        }
        if (endOfStream) {
            this.mEncoder.signalEndOfInputStream();
        }
    }
}

