/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.gif.transcode;

import android.graphics.Bitmap;
import android.media.MediaCodec;
import android.media.MediaFormat;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import com.otaliastudios.gif.internal.MediaCodecBuffers;
import com.otaliastudios.gif.sink.DataSink;
import com.otaliastudios.gif.source.DataSource;
import com.otaliastudios.gif.transcode.Transcoder;
import java.io.IOException;

public abstract class BaseTranscoder
implements Transcoder {
    private static final int DRAIN_STATE_NONE = 0;
    private static final int DRAIN_STATE_SHOULD_RETRY_IMMEDIATELY = 1;
    private static final int DRAIN_STATE_CONSUMED = 2;
    private final DataSource mDataSource;
    private final DataSource.Chunk mDataChunk;
    private final DataSink mDataSink;
    private final MediaCodec.BufferInfo mBufferInfo = new MediaCodec.BufferInfo();
    private MediaCodec mEncoder;
    private MediaCodecBuffers mEncoderBuffers;
    private boolean mEncoderStarted;
    private MediaFormat mActualOutputFormat;
    private boolean mIsEncoderEOS;
    private boolean mIsDataSourceEOS;

    protected BaseTranscoder(@NonNull DataSource dataSource, @NonNull DataSink dataSink) {
        this.mDataSource = dataSource;
        this.mDataSink = dataSink;
        this.mDataChunk = new DataSource.Chunk();
    }

    @Override
    public final void setUp(@NonNull MediaFormat desiredOutputFormat) {
        try {
            this.mEncoder = MediaCodec.createEncoderByType((String)desiredOutputFormat.getString("mime"));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.onConfigureEncoder(desiredOutputFormat, this.mEncoder);
        this.onStartEncoder(desiredOutputFormat, this.mEncoder);
        this.onStarted(this.mDataSource.getTrackFormat(), desiredOutputFormat, this.mEncoder);
    }

    protected void onConfigureEncoder(@NonNull MediaFormat format, @NonNull MediaCodec encoder) {
        encoder.configure(format, null, null, 1);
    }

    @CallSuper
    protected void onStartEncoder(@NonNull MediaFormat format, @NonNull MediaCodec encoder) {
        encoder.start();
        this.mEncoderStarted = true;
        this.mEncoderBuffers = new MediaCodecBuffers(encoder);
    }

    protected void onStarted(@NonNull MediaFormat inputFormat, @NonNull MediaFormat outputFormat, @NonNull MediaCodec encoder) {
    }

    @Override
    public final boolean isFinished() {
        return this.mIsEncoderEOS;
    }

    @Override
    public void release() {
        if (this.mEncoder != null) {
            if (this.mEncoderStarted) {
                this.mEncoder.stop();
                this.mEncoderStarted = false;
            }
            this.mEncoder.release();
            this.mEncoder = null;
        }
    }

    @Override
    public final boolean transcode(boolean forceInputEos) {
        int status;
        boolean busy = false;
        while (this.drainEncoder(0L) != 0) {
            busy = true;
        }
        do {
            if ((status = this.drainSource(0L, forceInputEos)) == 0) continue;
            busy = true;
        } while (status == 1);
        while (this.feedEncoder(0L)) {
            busy = true;
        }
        return busy;
    }

    private int drainSource(long timeoutUs, boolean forceInputEos) {
        if (this.mIsDataSourceEOS) {
            return 0;
        }
        if (this.mDataSource.isDrained() || forceInputEos) {
            this.mIsDataSourceEOS = true;
            return 0;
        }
        this.mDataSource.read(this.mDataChunk);
        this.onDrainSource(timeoutUs, this.mDataChunk.bitmap, this.mDataChunk.timestampUs, this.mDataSource.isDrained());
        return 2;
    }

    protected abstract void onDrainSource(long var1, @NonNull Bitmap var3, long var4, boolean var6);

    @CallSuper
    protected void onEncoderOutputFormatChanged(@NonNull MediaCodec encoder, @NonNull MediaFormat format) {
        if (this.mActualOutputFormat != null) {
            throw new RuntimeException("Audio output format changed twice.");
        }
        this.mActualOutputFormat = format;
        this.mDataSink.setFormat(this.mActualOutputFormat);
    }

    private boolean feedEncoder(long timeoutUs) {
        return this.onFeedEncoder(this.mEncoder, this.mEncoderBuffers, timeoutUs);
    }

    private int drainEncoder(long timeoutUs) {
        if (this.mIsEncoderEOS) {
            return 0;
        }
        int result = this.mEncoder.dequeueOutputBuffer(this.mBufferInfo, timeoutUs);
        switch (result) {
            case -1: {
                return 0;
            }
            case -2: {
                this.onEncoderOutputFormatChanged(this.mEncoder, this.mEncoder.getOutputFormat());
                return 1;
            }
            case -3: {
                this.mEncoderBuffers.onOutputBuffersChanged();
                return 1;
            }
        }
        if (this.mActualOutputFormat == null) {
            throw new RuntimeException("Could not determine actual output format.");
        }
        if ((this.mBufferInfo.flags & 4) != 0) {
            this.mIsEncoderEOS = true;
            this.mBufferInfo.set(0, 0, 0L, this.mBufferInfo.flags);
        }
        if ((this.mBufferInfo.flags & 2) != 0) {
            this.mEncoder.releaseOutputBuffer(result, false);
            return 1;
        }
        this.mDataSink.write(this.mEncoderBuffers.getOutputBuffer(result), this.mBufferInfo);
        this.mEncoder.releaseOutputBuffer(result, false);
        return 2;
    }

    protected abstract boolean onFeedEncoder(@NonNull MediaCodec var1, @NonNull MediaCodecBuffers var2, long var3);
}

